<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IDBModel.php 1720 2009-04-21 03:39:16Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IDBModel extends JCAT_IModel
{
	/**
	 * create a db aggregation model by passing a ORM
	 *
	 * @access	public
	 * @param	$aORM			JCAT_ORM
	 * @static
	 * @return	JCAT_IDBModel
	 */
	static public function CreateByORM(JCAT_ORM $aORM) ;
	
	/**
	 * get db primary key
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPrimaryKey() ;
	
	
	/**
	 * get the primary key value
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetId() ;
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sFieldName	string	What's this Parameter ?
	 * @return	
	 */
	public function GetByField( $sFieldName )  ;
	
	/**
	 * set a find condition
	 *
	 * @access	public
	 * @param 	$sDataName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindBy($sDataName,$Value,$sOperator='=',$sRightB=null) ;
	
	/**
	 * set a find condition
	 *
	 * @access	public
	 * @param 	$sDataName			string
	 * @param 	$Value				mxied
	 * @param 	$sOperator='='		string
	 * @param 	$sRightB=null		mxied
	 * @return	void
	 */
	public function FindByField($sDataName,$Value,$sOperator='=',$sRightB=null) ;
	
	/**
	 * 设置查询条件
	 *
	 * @access	public
	 * @param	$sCondition		string
	 * @return	void
	 */
	public function FindByCondition($sCondition) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName			string
	 * @param	$bDesc=true			bool
	 * @return	void
	 */
	public function FindSort($sDataName,$bDesc=true) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateConditionIterator() ;

	/**
	 * set ORM
	 *
	 * @access	public
	 * @param 	$aORM		JCAT_ORM
	 * @return	void
	 */
	public function SetORM(JCAT_ORM $aORM) ;
	
	/**
	 * get ORM
	 *
	 * @access	public
	 * @return	JCAT_ORM
	 */
	public function GetORM() ;

	
	
}
?>