<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_AggregationModel.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class JCAT_AggregationModel extends JCAT_Model implements JCAT_IAggregationModel
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function JCAT_AggregationModel()
	{
		parent::JCAT_Model() ;
		
		$this->ResetInnerIterator() ;
	}	

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function ResetInnerIterator()
	{
		$this->aInnerIterator = $this->CreateModelIterator() ;
		$this->aInnerIterator->First() ;
	}
	
	///////// 实现 JCAT_IPaginal 接口 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * 设置 每页记录数
	 *
	 * @access      public
	 * @param       $nRecordCount   int             What's this Parameter ?
	 * @return      void
	 */
	public function SetCountPerPage( $nRecordCount )
	{
		JCAT_ASSERT::ASSERT_($nRecordCount>=0,JCAT_Language::SentenceEx('参数 $nRecordCount 必须大于等于0，传入数值为：“%d”','JCAT',null,$nRecordCount)) ;
		$this->nRecordsPerPage = $nRecordCount ;
	}
	
	
	/**
	 * 返回 每页记录数
	 *
	 * @access      public
	 * @return      int
	 */
	public function GetCountPerPage()
	{
		return $this->nRecordsPerPage ;
	}
	
	/**
	 * 返回 本页记录数
	 *
	 * @access      public
	 * @return      int
	 */
	public function GetCount()
	{
		return $this->GetModelCount() ;
	}
	
	/**
	 * 返回 所有符合条件的记录数
	 *
	 * @access      public
	 * @return      int
	 */
	public function GetTotalCount()
	{
		return $this->nTotalRecordCount ;
	}
	
	/**
	 * 返回 所有符合条件的记录数
	 *
	 * @access     protected
	 * @param		$nCount		int
	 * @return     void
	 */
	protected function SetTotalCount($nCount)
	{
		$this->nTotalRecordCount = $nCount ;
	}
	
	/**
	 * 取回总页数
	 *
	 * @access      public
	 * @return      int
	 */
	public function GetPageCount()
	{
		$nCountPerPage = $this->GetCountPerPage() ;
		return $nCountPerPage? intval(ceil($this->GetTotalCount()/$nCountPerPage)): 0 ;
	}
	
	/**
	 * 设置当前页数
	 *
	 * @access      public
	 * @return      void
	 */
	public function SetPageNumber( $nPageNum )
	{
		$aPagination = $this->GetPagination() ;
		if($aPagination)
		{
			$aPagination->SetPageNumber($nPageNum) ;
		}
	}
	
	/**
	 * 取回当前页数
	 *
	 * @access      public
	 * @return      int
	 */
	public function GetPageNumber()
	{
		$aPagination = $this->GetPagination() ;
		return $aPagination? $aPagination->GetPageNumber(): 1 ;
	}

	
	/**
	 * 设置页码对象
	 *
	 * @access      public
	 * @param       $aPagination    JCAT_IPagination
	 * @return      void
	 */
	public function SetPagination(JCAT_IPagination $aPagination)
	{
		$this->aPagination = $aPagination ;
		$aPagination->SetPaginal($this);
	}
	 
	/**
	 * 返回页码对象
	 *
	 * @access      public
	 * @return      JCAT_IPagination
	 */
	public function GetPagination()
	{
		return $this->aPagination ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetStartPos()
	{
		$aPagination = $this->GetPagination() ;
		return $aPagination? $aPagination->GetStartPos(): 0 ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetEndPos()
	{
		$aPagination = $this->GetPagination() ;
		return $aPagination? 
					$aPagination->GetEndPos():
					($this->GetCountPerPage()-1) ;
	}
	
	

	
	///////// 实现 JCAT_IAggerationModel 接口 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * inner iterate: first
	 *
	 * @access	public
	 * @return	JCAT_IModel
	 */
	public function FirstModel()
	{
		return $this->aInnerIterator->First() ;
	}
	
	/**
	 * inner iterate: next
	 *
	 * @access	public
	 * @return	JCAT_IModel
	 */
	public function NextModel()
	{
		return $this->aInnerIterator->Next() ;
	}
	
	/**
	 * inner iterate: current
	 *
	 * @access	public
	 * @return	JCAT_IModel
	 */
	public function CurrentModel()
	{
		return $this->aInnerIterator->Current() ;
	}
	
	/**
	 * inner iterate: isDone
	 *
	 * @access	public
	 * @return	bool
	 */
	public function ModelIsDone()
	{
		return $this->aInnerIterator->IsDone() ;
	}
	
	///////// 实现 JCAT_IModel 接口 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * serialize a model
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Serialize()
	{
		if( !$this->IsChanged() )
		{
			return true ;
		}
		
		$aIterator = $this->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aChildModel = $aIterator->Current();
			if( !$aChildModel->Serialize() )
			{
				return false ;
			}
		}
		
		return true ;
	}


	/**
	 * restore a model
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Unserialize()
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Unserialize(): false ;
	}
	
	
	/**
	 * return if the model have been serialized
	 *
	 * @access	public
	 * @param	$bRequery=false		bool	对于高级模型（如数据库模型），查询 模型是否存在 会存在一定性能代价 ，该参数允许缓存查询结果
	 * @return	bool
	 */
	public function HaveSerialized( $bRequery=false )
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->HaveSerialized($bRequery): false ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Load()
	{
		$this->ResetInnerIterator() ;		
		return true ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Save()
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Save(): false ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Create()
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Create(): false ;
	}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete()
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Delete(): false ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName	string	What's this Parameter ?
	 * @return	
	 */
	public function Get( $sDataName )
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Get($sDataName): null ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName			string	What's this Parameter ?
	 * @param	$Value				mixed	What's this Parameter ?
	 * @param	$bSetChanged=true	bool	What's this Parameter ?
	 * @return	
	 */
	public function Set( $sDataName, $Value, $bSetChanged=true )
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->Set($sDataName,$Value,$bSetChanged): null ;
	}


	/**
	 * 检查模型数据 $sDataName 是否存在 
	 * 
	 * @access	public
	 * @param	$sDataName		string
	 * @return	bool
	 */
	public function IsDataExists($sDataName)
	{
		$aModel = $this->CurrentModel() ;
		return $aModel? $aModel->IsDataExists($sDataName): false ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsChanged()
	{
		$aModelIterator = $this->CreateModelIterator() ;
		for ( $aModelIterator->First(); !$aModelIterator->IsDone(); $aModelIterator->Next() )
		{
			$aModel = $aModelIterator->Current();
			
			if($aModel->IsChanged())
			{
				return true ;
			}
		}
		
		return false ;
	}

	
	/**
	 * 彻底 销毁一个模型 在  MVC 系统中的所有引用，以便在不需要该模型时能够立刻回收：
	 *  模型的全局名称上的引用
	 *  ... ...
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Destroy()
	{
		parent::Destroy() ;
		
		$aModelIterator = $this->CreateModelIterator() ;
		for ( $aModelIterator->First(); !$aModelIterator->IsDone(); $aModelIterator->Next() )
		{
			$aModel = $aModelIterator->Current();
			
			$aModel->Destroy() ;
		}
	}
	

	
	///////// 属性 ///////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nRecordsPerPage = 20 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nTotalRecordCount = 0 ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IIterator
	 */
	private $aInnerIterator ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IPagination
	 */
	private $aPagination ;
	

}
?>