<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IModel.php 1853 2009-05-20 17:17:07Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/






/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IModel extends JCAT_IViewContainer, JCAT_IModelContainer
{
	/**
	 * serialize a model
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Serialize()  ;


	/**
	 * restore a model
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Unserialize()  ;
	
	
	/**
	 * return if the model have been serialized
	 *
	 * @access	public
	 * @return	bool
	 */
	public function HaveSerialized() ;

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bSerialized=true		bool
	 * @return	void
	 */
	public function SetSerialized($bSerialized=true) ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Load()  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete()  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Create() ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Save() ;
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName	string	What's this Parameter ?
	 * @return	
	 */
	public function Get( $sDataName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sDataName			string	What's this Parameter ?
	 * @param	$Value				mixed	What's this Parameter ?
	 * @param	$bSetChanged=true	bool	What's this Parameter ?
	 * @return	
	 */
	public function Set( $sDataName, $Value, $bSetChanged=true )  ;

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName
	 * @param	$sAlias
	 * @return	void
	 */
	public function SetDataAlias($sDataName,$sAlias) ;

	/**
	 * 检查模型数据 $sDataName 是否存在 
	 * 
	 * @access	public
	 * @param	$sDataName		string
	 * @return	bool
	 */
	public function IsDataExists($sDataName) ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsChanged()   ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bChanged=true			bool	What's this Parameter ?
	 * @param	$bSetChildren=false		bool	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetChanged( $bChanged=true, $bSetChildren=false )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aBut=null	JCAT_IView	What's this Parameter ?
	 * @return	void
	 */
	public function UpdateAllView( JCAT_IView $aBut=null )  ;

	
	/**
	 * 彻底 销毁一个模型 在  MVC 系统中的所有引用，以便在不需要该模型时能够立刻回收：
	 *  模型的全局名称上的引用
	 *  ... ...
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Destroy() ;



}
?>