<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IModelContainer.php 1691 2009-04-19 12:10:06Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IModelContainer
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aDoc		JCAT_IModel	What's this Parameter ?
	 * @param	$sName=null	string			What's this Parameter ?
	 * @return	void
	 */
	public function AddModel( JCAT_IModel $aDoc, $sName=null )  ;


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel		JCAT_IModel	What's this Parameter ?
	 * @return	void
	 */
	public function RemoveModel( JCAT_IModel $aModel ) ;
	
	/**
	 * 是否存在传入的模型
	 *
	 * @access	public
	 * @param	$aModel		JCAT_IModel
	 * @return	bool
	 */
	public function HasModel(JCAT_IModel $aModel) ;
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	JCAT_IModel
	 */
	public function GetModel( $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetModelCount(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearModel(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateModelIterator(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateModelMemento(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrMemento	What's this Parameter ?
	 * @return	array
	 */
	public function SetModelMemento( $arrMemento )  ;




	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>