<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: interface.JCAT_IView.php 1608 2009-03-31 22:36:42Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/



include_once dirname(__FILE__).'/interface.JCAT_IViewContainer.php';
include_once dirname(__FILE__).'/interface.JCAT_IUICtrlContainer.php';


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
interface JCAT_IView extends JCAT_IViewContainer,JCAT_IUICtrlContainer
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetName(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetName( $sName )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IViewContainer
	 */
	public function GetParent(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IController
	 */
	public function GetParentController(  )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aModel	JCAT_IModel	What's this Parameter ?
	 * @return	old_var
	 */
	public function SetModel( JCAT_IModel $aModel )  ;



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_IModel
	 */
	public function GetModel(  )  ;


	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Update() ;

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$bShow=true	bool	What's this Parameter ?
	 * @return	
	 */
	public function ShowView()  ;

	
	
	/**
	 * 彻底 销毁一个视图 在  MVC 系统中的所有引用，以便在不需要该视图时能够立刻回收：
	 *  模型 对该视图的引用
	 *  控制器 对该视图的引用
	 *  视图的全局名称上的引用
	 *  ... ...
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Destroy() ;
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Package=null									 string,JCAT_LanguagePackage
	 * @param	$sLang=JCAT_Language::CURRENT_LANGUAGE	 string,JCAT_Language
	 * @return	void
	 */
	public function SetLanguage($Package=null,$Lang=JCAT_Language::CURRENT_LANGUAGE) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string,JCAT_LanguagePackage
	 */
	public function GetLanguage() ;

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string,JCAT_LanguagePackage
	 */
	public function GetLanguagePackage() ;
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////


}
?>