<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_EventProcessor.php 1604 2009-03-31 15:40:17Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_EventProcessor implements JCAT_IEventProcessor
{
	/**
	 * 响应事件
	 * 
	 * @access	public
	 * @param	$sEventName		string	事件名称
	 * @param	$arrEventData	array	事件数据
	 * @return	void
	 */
	public function ProcessEvent( $sEventName, array $arrEventData=array() )
	{
		// 调用已经注册的 事件处理函数
		if( isset($this->arrEventProcessFunctions[$sEventName]) )
		{
			foreach($this->arrEventProcessFunctions[$sEventName] as $arrCallback)
			{
				$arrArgs = array_merge($arrEventData,$arrCallback[1]);
				call_user_func_array($arrCallback[0],$arrArgs) ;
			}
		}
		
		// 调用缺省的事件处理函数
		$sDefaultFuncName = 'On'.str_replace('-','',$sEventName) ;
		if( method_exists($this,$sDefaultFuncName) ) 
		{
			call_user_func_array(array($this,$sDefaultFuncName),$arrEventData) ;
		}
	}
	
	/**
	 * 注册一个 事件处理函数
	 * 
	 * @access	public
	 * @param	$sEventName		string		事件名称
	 * @param	$Callback		callback	事件处理函数
	 * @return	bool
	 */
	public function RegisterEventProcessFunction( $sEventName, $Callback, $arrArgs=array() )
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Callback,array('callback')) ;
		
		if( !$this->HasEventProcessFunctionRegistered($sEventName, $Callback) )
		{
			$this->arrEventProcessFunctions[$sEventName][] = array($Callback,$arrArgs) ;
		}
		
		return true ;
	}
	
	/**
	 * 注销一个事件处理函数
	 * 
	 * @access	public
	 * @param	$sEventName		string		事件名称
	 * @param	$Callback		callback	事件处理函数
	 * @return	void
	 */
	public function UnregisterEventProcessFunction( $sEventName, $Callback )
	{
		$nIdx = $this->FindEventProcessFunction($sEventName, $Callback) ;
		if($nIdx===null)
		{
			return ;
		}
		
		unset($this->arrEventProcessFunctions[$sEventName][$nIdx]) ;
	}
	
	
	/**
	 * 查询一个事件处理函数是否已经注册
	 * 
	 * @access	public
	 * @param	$sEventName		string		事件名称
	 * @param	$Callback		callback	事件处理函数
	 * @return	bool
	 */
	public function HasEventProcessFunctionRegistered( $sEventName, $Callback )
	{
		return $this->FindEventProcessFunction($sEventName, $Callback)!==null ;		
	}



	/**
	 * 事件转发
	 * 此函数 整理事件处理函数的参数 后  转发事件
	 * 
	 * @access	public
	 * @return	void
	 * @static 
	 */
	static public function EventTransmitForGtkSignal()
	{
		JCAT_ASSERT::ASSERT_( func_num_args()>=2, JCAT_Language::SentenceEx('参数最后两位“转发对象”和“事件名称”是必须的','JCAT',null) ) ;
		
		$arrArgs = func_get_args() ;
		$sEventName = array_pop($arrArgs) ;
		$aObject = array_pop($arrArgs) ;
		
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,'JCAT_IEventProcessor');
		
		call_user_func_array(array($aObject,'ProcessEvent'),array($sEventName,$arrArgs)) ;
	}
	
	
	/**
	 * 找到事件处理函数的键值
	 * 
	 * @access	private
	 * @param	$sEventName		string		事件名称
	 * @param	$Callback		callback	事件处理函数
	 * @return	int,null
	 */
	private function FindEventProcessFunction($sEventName, $Callback)
	{
		if( !isset($this->arrEventProcessFunctions[$sEventName]) )
		{
			return null ;
		}
	
		foreach($this->arrEventProcessFunctions[$sEventName] as $nIdx=>$arrCallback)
		{
			if( $arrCallback[0]===$Callback )
			{
				return $nIdx ;
			}
		}
		
		return null ;
	}
	
	// 属性 /////////////////////////
	private $arrEventProcessFunctions = array() ;
	
}

?>