<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_ExceptionProcessorHtml.php 1732 2009-04-25 07:00:26Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/


class JCAT_ExceptionProcessorCMD extends JCAT_Controller 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aException		JCAT_Exception
	 * @return	void
	 */
	public function JCAT_ExceptionProcessorCMD(JCAT_Exception $aException)
	{
		$this->aException = $aException ;
		$this->JCAT_Controller(__CLASS__) ;
	}
	
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		JCAT_ASSERT::ASSERT_NOTNULL($this->aException);
		
		$sNewLine = JCAT_OS::GetNewline() ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('系统遇到无法处理的异常','JCAT',null)) ;
		echo $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('如果此异常在你的预计之中，请使用 Try-Catch 截获并处理。以下是该异常的详细信息：','JCAT',null)) ;
		echo  $sNewLine, $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('类型：　　%s','JCAT',null,get_class($this->aException))) ;
		echo $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('代号：　　%s','JCAT',null,$this->aException->getCode())) ;
		echo $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('消息：　　%s','JCAT',null,$this->aException->getMessage())) ;
		echo $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('发生地点： [脚本]','JCAT',null)) ;
		echo $this->aException->getFile(), $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('　　　　　 [行]%s','JCAT',null,$this->aException->getLine())) ;
		echo  $sNewLine, $sNewLine ;
		
		$this->PrintWord(JCAT_Language::SentenceEx('执行轨迹：','JCAT',null,$this->aException->getLine())) ;
		echo  $sNewLine ;
		echo $this->aException->getTraceAsString() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function PrintWord($sWord)
	{
		echo $sWord ;
	}
	
	/**
	 * 被抛出的异常对象
	 * 
	 * @access	private
	 * @var		JCAT_Exception
	 */
	private $aException ;
}

?>