<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class.JCAT_MVCDataExchanger.php 1950 2009-07-29 06:52:49Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

class JCAT_MVCDataExchanger
{
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$aView		JCAT_IView			what's this
	 * @return	void
	 */
	public function JCAT_MVCDataExchanger(JCAT_IView $aView)
	{
		$this->theView = $aView ;
	}
	
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$UICtrl				string,JCAT_IUICtrl		what's this
	 * @param	$sDocDataName		string					what's this
	 * @return	void
	 */
	public function LinkUICtrlToModelData($UICtrl,$sDocDataName)
	{
		JCAT_ASSERT::ASSERT_STRING($sDocDataName);
		JCAT_ASSERT::ASSERT_ISTHESE($UICtrl,array('string','JCAT_IUICtrlForm'));
		
		if( is_string($UICtrl) )
		{
			$sUICtrlName = $UICtrl ;
		}
		else
		{
			$sUICtrlName = $UICtrl->GetName() ;
		}
		
		JCAT_ASSERT::ASSERT_INSTANCE($this->theView->GetUICtrl($sUICtrlName),'JCAT_IUICtrlForm',JCAT_Language::SentenceEx('参数 $UICtrl 必须为视图中存在的 JCAT_IUICtrlForm 类型的 UI控件','JCAT',null)) ;
		
		// 加入
		if( !isset($this->arrLinks[$sUICtrlName]) )
			$this->arrLinks[$sUICtrlName] = array() ;
			
		if( !in_array($sDocDataName,$this->arrLinks[$sUICtrlName]) )
			$this->arrLinks[$sUICtrlName][] = $sDocDataName ;
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$UICtrl					string,JCAT_IUICtrl		what's this
	 * @param	$sDocDataName=null		string					what's this
	 * @return	void
	 */
	public function Unlink($UICtrl,$sDocDataName=null)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($sDocDataName,array('string','null'));
		JCAT_ASSERT::ASSERT_ISTHESE($UICtrl,array('string','JCAT_IUICtrlForm'));
		
		if( is_string($UICtrl) )
		{
			$sUICtrlName = $UICtrl ;
		}
		else
		{
			$sUICtrlName = $UICtrl->GetName() ;
		}
		
		if( !isset($this->arrLinks[$sUICtrlName]) )
		{
			return ;
		}
		
		if($sDocDataName===null)
		{
			unset($this->arrLinks[$sUICtrlName]) ;
		}
		
		else 
		{
			$sKey = array_search($sDocDataName,$this->arrLinks[$sUICtrlName]);
			if( $sKey===false or $sKey===null )
			{
				return ;
			}
			
			unset($this->arrLinks[$sUICtrlName][$sKey]) ;
		}
		
		
	}
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function ExchangeData($nExchangeWay=JCAT_IViewForm::UICTRL_TO_DOC)
	{
		foreach($this->arrLinks as $sUICtrlName=>$arrLinks)
		{
			$this->ExchangeOneData($sUICtrlName,$nExchangeWay) ;
		}
	}
	
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @param	$sUICtrlName						string	UICtrl名称
	 * @param	$nExchangeWay=self::UICTRL_TO_DOC	int		交换方向
	 * @param	$bSetDocChangedAtOnce=true			bool	如果 $nExchangeWay=self::UICTRL_TO_DOC， 是否立即将模型设置为 已变更
	 * @return	void
	 */
	public function ExchangeOneData( $sUICtrlName, $nExchangeWay=JCAT_IViewForm::UICTRL_TO_DOC, $bSetDocChangedAtOnce=true )
	{
		// 模型
		$aModel = $this->theView->GetModel() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aModel,'JCAT_IModel',JCAT_Language::SentenceEx('无法进行数据交换：尚未给视图“%s”设置模型。','JCAT',null,$this->theView->GetName())) ;
		
		// UICtrl
		$aUICtrl = $this->theView->GetUICtrl($sUICtrlName) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aUICtrl,'JCAT_IUICtrlForm',JCAT_Language::SentenceEx('请求交换的UICtrl(“%s”)不存在，或不是有效的 JCAT_IUICtrlForm 类型。','JCAT',null,$sUICtrlName)) ;
		
		// 设置的 数据项
		$arrDataNames = isset($this->arrLinks[$sUICtrlName])?
							$this->arrLinks[$sUICtrlName]:
							array() ;
		
		foreach($arrDataNames as $sDataName)
		{
		
			// 控件 => 模型
			if( $nExchangeWay==JCAT_IViewForm::UICTRL_TO_DOC )
			{
				$Value = $aUICtrl->GetExchangeData() ;
				$aModel->Set($sDataName,$Value,$bSetDocChangedAtOnce) ;
			}
			
			// 模型 => 控件
			else if( $nExchangeWay==JCAT_IViewForm::DOC_TO_UICTRL )
			{
				$Value = $aModel->Get($sDataName) ;
				if($Value!==null)
				{
					$aUICtrl->SetDataByExchange($Value) ;
				}
			}
			
			// 意外
			else
			{
				JCAT_ASSERT::ASSERT_(0,'!?');
			}
			
		
			// 设置 Gtk UI控件的 Change 状态
			if( JCAT_Global::HasImplementedTo($aUICtrl,'JCAT_IUIGtkCtrl') )
			{
				$aUICtrl->SetUICtrlChanged(false) ;
			}
		}
	}
	
	
	private $theView ;
	
	private $arrLinks = array() ;
}

?>