<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: class._JCAT_MVCObjectContainer.php 1925 2009-07-08 07:20:04Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/




/**
 * 用于实现  模型/视图/UI控件 的 内建容器
 *
 * @author		alee
 * @access		private
 */
class _JCAT_MVCObjectContainer
{


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sObjectType	string	对象类型
	 * @return	void
	 */
	public function _JCAT_MVCObjectContainer( $sObjectType, $bAnonymousObject=false ) 
	{
		JCAT_ASSERT::ASSERT_(
				in_array($sObjectType,array('JCAT_IModel','JCAT_IView','JCAT_IUICtrl','JCAT_IController')),
				JCAT_Language::SentenceEx('参数 $sObjectType 只能为：JCAT_IController,JCAT_IModel, JCAT_IView, JCAT_IUICtrl','JCAT',null) ) ;
		
		$this->sObjectType = $sObjectType ;
		$this->bAnonymousObject = $bAnonymousObject ;
	}

	public function __sleep()
	{
		$arrDataNames[] = JCAT_Package::MakePrivatePropertyNameForSerialize('arrObjects',__CLASS__) ;
		$arrDataNames[] = JCAT_Package::MakePrivatePropertyNameForSerialize('sObjectType',__CLASS__) ;
		$arrDataNames[] = JCAT_Package::MakePrivatePropertyNameForSerialize('bAnonymousObject',__CLASS__) ;
		return $arrDataNames ;
	}


	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$aObject	object	What's this Parameter ?
	 * @param	$sName		string	What's this Parameter ?
	 * @return	void
	 */
	public function Add( $aObject, $sName=null ) 
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,$this->sObjectType) ;
		
		if( $sName===null )
		{
			if($this->bAnonymousObject)
			{
				$sObName = null ;
			}
			else
			{
				$sObName = $aObject->GetName() ;
			}
		}
		else
		{
			$sObName = $sName ;
		}

		
		if($sObName===null)
		{
			$this->arrObjects[] = $aObject ;
		}
		else
		{
			$this->arrObjects[$sObName] = $aObject ;
		}
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$sName	string	What's this Parameter ?
	 * @return	object,null
	 */
	public function Get( $sName ) 
	{
		JCAT_ASSERT::ASSERT_STRING($sName) ;
		return isset($this->arrObjects[$sName])? $this->arrObjects[$sName]: null ;
	}

	/**
	 * remove and return a object
	 * 
	 * @access	public
	 * @param	$object		object,string	What's this Parameter ?
	 * @return	object
	 */
	public function Remove($Object)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Object,array('string','object')) ;
		
		$aObject = null ; 
		if( is_string($Object) )
		{
			if( isset($this->arrObjects[$Object]) )
			{
				$aObject = $this->arrObjects[$Object] ;
				unset($this->arrObjects[$Object]) ;
			}
		}
		
		else
		{
			$sKey = array_search($Object,$this->arrObjects) ;
			if( $sKey!==false and $sKey!==null )
			{
				$aObject = $this->arrObjects[$sKey] ;
				unset($this->arrObjects[$sKey]) ;
			}			
		}
		
		return $aObject ;
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetObjectCount(  ) 
	{
		return count($this->arrObjects) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function ClearObject(  ) 
	{
		$nCount = $this->GetObjectCount() ;
		$this->arrObjects = array() ;
		return $nCount ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	JCAT_ArrayIterator
	 */
	public function CreateObjectIterator(  ) 
	{
		return new JCAT_ArrayIterator($this->arrObjects) ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	array
	 */
	public function CreateObjectMemento(  ) 
	{
		return $this->arrObjects ;
	}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @param	$arrMemento	array	What's this Parameter ?
	 * @return	array
	 */
	public function SetObjectMemento( array $arrMemento ) 
	{
		JCAT_ASSERT::ASSERT_ISTHESE($arrMemento,array("array:{$this->sObjectType}")) ;
		$this->arrObjects = $arrMemento ;
	}


	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function DestroyAll()
	{
		$this->CreateObjectIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aItem = $aIterator->Current() ;
			
			$aItem->Destroy() ;
			$this->Remve($aItem) ;
			
			$aIterator->Next() ;
		}
	}


	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SortByName()
	{
		ksort($this->arrObjects) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aObject
	 * @return	bool
	 */
	public function HasObject($aObject)
	{
		JCAT_ASSERT::ASSERT_INSTANCE($aObject,$this->sObjectType) ;
		return in_array( $aObject, &$this->arrObjects, true ) ; //	使用引用传递给 in_array() ，因为 in_array() 无法直接访问对象的 private 成员
	}
	
	// 属性 ///////////////////////////////////////////////////////////////////////////////

	/**
	 * What's this Method ?
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sObjectType ;
	
	/**
	 * What's this Method ?
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrObjects = array() ;
	
	
	private $bAnonymousObject = false ;
	
}
?>