<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
//  这个文件是 JCAT PHP框架的一部，该项目和此文件 均遵循 GNU 自由软件协议
// 
//  Copyleft 2008 JeCat.cn(http://team.JeCat.cn)
//
//
//  JCAT PHP框架 的正式全名是：Jellicle Cat PHP Framework。
//  “Jellicle Cat”出自 Andrew Lloyd Webber的音乐剧《猫》（《Prologue:Jellicle Songs for Jellicle Cats》）。
//  JCAT 是一个开源项目，它像音乐剧中的猫一样自由，你可以毫无顾忌地使用JCAT PHP框架。JCAT 由中国团队开发维护。
//  正在使用的这个版本是：0.5.0 / SVN信息: $Id: inc.JCAT_Entrance.php 1905 2009-06-17 07:57:26Z alee $
//
//
//
//  相关的链接：
//    [主页] http://jcat.JeCat.cn
//    [下载(HTTP)] http://code.google.com/p/jcat-php/downloads/list
//    [下载(svn)] svn checkout http://jcat-php.googlecode.com/svn/branches/0.4.0/Framework/ JCAT0.4
//    [在线文档] http://jcat.JeCat.cn/document
//    [社区] http://jj.jecat.cn/forum-7-1.html
//  不很相关：
//    [MP3] http://www.google.com/search?q=jellicle+songs+for+jellicle+cats+Andrew+Lloyd+Webber
//    [VCD/DVD] http://www.google.com/search?q=CAT+Andrew+Lloyd+Webber+video
//
///////////////////////////////////////////////////////////////////////////////////////////////////////
/*-- Project Introduce --*/

// 输出所有 警告和错误 信息
// JCAT建议：不要忽视任何错误，在开发阶段将所有错误放大而不是隐藏或回避，是保持良好编程习惯的第一步
error_reporting(E_ALL) ;

// 定义用于表示 JCAT框架所在路径的 JCATPATH 常量 
if( !defined('JCATPATH') )
{
	define('JCATPATH',dirname(__FILE__).'/') ;
}

// 版本
define('JCAT_VERSION','0.5') ;


// 载入JCAT的核心类
include_once( JCATPATH.'Lib.php/Core/class.JCAT.php' ) ;														// 载入 核心类include_once( JCATPATH.'lib.php/Application/Language/class.JCAT_Language.php' ) ;			// 载入 语言类
include_once( JCATPATH.'Lib.php/Core/class.JCAT_Package.php' ) ;												// 载入 包管理类
include_once( JCATPATH.'Lib.php/Core/class.JCAT_Exception.php' ) ;											// 载入 异常类
include_once( JCATPATH.'Lib.php/Common/class.JCAT_ProjectState.php' ) ;											// 载入 项目状态类
include_once( JCATPATH.'Lib.php/Core/class.JCAT_Global.php' ) ;												// 载入 全局函数
include_once( JCATPATH.'Lib.php/Core/class.JCAT_ASSERT.php' ) ;												// 载入 全局函数


// JCAT 缺省语言设定
include_once( JCATPATH.'Lib.php/Core/Language/class.JCAT_Language.php' ) ;									// 载入 语言包
JCAT_LanguagePackage::AddPackageDir( JCATPATH.'/Resource/Language' ) ;											// 设置 JCAT内置语言包目录
JCAT_Language::SetCurrentLanguage('cn') ;																			// 当前语言设为 cn



// PHP Hook 函数
include_once( JCATPATH.'Lib.php/Core/Event/class.JCAT_EventManager.php' ) ;
$aEventManger = new JCAT_EventManager(true) ;
$aEventManger->TakeoverKernelEvent(JCAT_EventManager::PHP_ALL) ;
//$aEventManger->RegisterKernelHandle(JCAT_EventManager::PHP_AUTOLOAD,array('JCAT_Package','OnAutoLoad')) ;
$aEventManger->RegisterKernelHandle(JCAT_EventManager::PHP_UNCATCH_EXCEPTION,array('JCAT_Exception','ProcessUncaughtException')) ;

// 载入 JCAT 框架
include_once( JCATPATH.'Lib.php/Core/OOP/class.JCAT_ClassLoader.php' ) ;
$aClassLoader = new JCAT_ClassLoader($aEventManger) ;
JCAT_ClassLoader::SetGlobalInstance($aClassLoader) ;
$aClassLoader->Import(JCATPATH.'Lib.php/') ;
$aClassLoader->LoadClass('JCAT_DB') ;


// 配置 UI	
JCAT_UIHtml::AddTemplateDir(JCATPATH.'Resource/UITemplates/',true) ;		
JCAT_UIGtkGlade::AddTemplateDir(JCATPATH.'Resource/UITemplates/',true) ;				


// 配置 Gtk
// ----------------------------------------------------------------
if( JCAT_Package::ClassExists('Gtk') )
{
	Gtk::rc_parse( JCATPATH.'Resource/Style/JCAT.gtkrc' ) ;
}


// 配置 HTML
// ----------------------------------------------------------------
if( JCAT_Request::IsHTTPRequest() )
{
	// CSS 目录
	JCAT_CSS::AddResourceDirectory(JCATPATH.'Resource/Style/') ;

	// 缺省的 HTTP Entrance 设置
	JCAT_HTTPEntrance::SetEntrance($_SERVER['HTTP_HOST'],ROOTPATH) ;
}



// CSS 目录
JCAT_CSS::AddResourceDirectory(JCATPATH.'Resource/Style/') ;




// 设置消息类型 和 消息样式
// -------------------------------------------------------------
define('MSGMVC','MSGMVC') ;
define('MSGMVC_OK','MSGMVC_OK') ;
define('MSGMVC_BAD','MSGMVC_BAD') ;
define('MSGMVC_DEBUG','MSGMVC_DEBUG') ;

JCAT_MessageHTMLPrinter::RegisterMessageStyle(MSGMVC,'JCAT_Message_MSGMVC') ;
JCAT_MessageHTMLPrinter::RegisterMessageStyle(MSGMVC_OK,'JCAT_Message_MSGMVC_OK') ;
JCAT_MessageHTMLPrinter::RegisterMessageStyle(MSGMVC_BAD,'JCAT_Message_MSGMVC_BAD') ;
JCAT_MessageHTMLPrinter::RegisterMessageStyle(MSGMVC_DEBUG,'JCAT_Message_MSGMVC_DEBUG') ;

?>