<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 W3B_PlatformAdminResource 
 *
 * @access public
 */
class W3B_PlatformAdminDBSetting
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminDBSetting(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		
		$sHere = JCAT_Global::TidyPath( dirname(__FILE__) ) ;
		
		//<<[UnmodifiableBlock.Start]::Initialize Children::>>//
		// 创建并加载视图：W3B_PlatformAdminResourceView
		$aView = new W3B_PlatformAdminDBSettingView($this) ;
		$this->AddView($aView) ;

		// 创建并加载视图：W3B_PlatformAdminFrameView
		$aView = new W3B_PlatformAdminFrameView($this) ;
		$this->AddView($aView) ;
		//<<[UnmodifiableBlock.End]::Initialize Children::>>// 

		//<<[UnmodifiableBlock.Start]::Register Children Global Name::>>//
		// 注册全局对象
		$aView = JCAT_View::GetViewByGlobalName('W3B_PlatformAdminDBSettingView') ;
		JCAT_View::RegisterGlobalName($aView,'MainView') ;
		//<<[UnmodifiableBlock.End]::Register Children Global Name::>>// 
		
		//<<[UnmodifiableBlock.Start]::Set Document To View::>>//

		//<<[UnmodifiableBlock.End]::Set Document To View::>>// 
		

		// 在此添加代码 
		// TODO ... ... 
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun(array $arrArg=array())
	{
		// 载入平台配置属性
		$aPlatformPreference = new JCAT_FSPreference(PLATFORM_PREFERENCE_DIR) ;
		
		// 视图: W3B_PlatformAdminResourceView
		$aView = $this->GetView('W3B_PlatformAdminDBSettingView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminResourceView')) ;
		// 提交表单视图 W3B_PlatformAdminResourceView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->SetDataFromSubmited() ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{
				$sDatabaseHost = $aView->GetUICtrlExchangeData('DatabaseHost') ;
				$sDatabaseName = $aView->GetUICtrlExchangeData('DatabaseName') ;
				$sDatabaseUser = $aView->GetUICtrlExchangeData('DatabaseUser') ;
				$sDatabasePassword = $aView->GetUICtrlExchangeData('DatabasePassword') ;	
				
				$aPlatformPreference->SetItem('/Platform/Resource/Database','DatabaseHost',$sDatabaseHost) ;
				$aPlatformPreference->SetItem('/Platform/Resource/Database','DatabaseName',$sDatabaseName) ;
				$aPlatformPreference->SetItem('/Platform/Resource/Database','DatabaseUser',$sDatabaseUser) ;
				$aPlatformPreference->SetItem('/Platform/Resource/Database','DatabasePassword',$sDatabasePassword) ;
				
				new JCAT_Message(JCAT_Language::SentenceEx('设置已保存。','W3B_Platform',null),MSGMVC_OK) ;
			}
		}
		
		else 
		{
			$sDatabaseHost = $aPlatformPreference->GetItem('/Platform/Resource/Database','DatabaseHost') ;
			$sDatabaseName = $aPlatformPreference->GetItem('/Platform/Resource/Database','DatabaseName') ;
			$sDatabaseUser = $aPlatformPreference->GetItem('/Platform/Resource/Database','DatabaseUser') ;
			$sDatabasePassword = $aPlatformPreference->GetItem('/Platform/Resource/Database','DatabasePassword') ;
			
			$aView->SetUICtrlExchangeData('DatabaseHost',$sDatabaseHost) ;
			$aView->SetUICtrlExchangeData('DatabaseName',$sDatabaseName) ;
			$aView->SetUICtrlExchangeData('DatabaseUser',$sDatabaseUser) ;
			$aView->SetUICtrlExchangeData('DatabasePassword',$sDatabasePassword) ;	
		}

		// 视图: W3B_PlatformAdminFrameView
		$aView = $this->GetView('W3B_PlatformAdminFrameView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminFrameView')) ;
		$aView->ShowView() ;

		// TODO
		// ... ...
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUyNCVGQyU4MCU4OCVENCVBM1UlRTkrJTgwJUY4JTkyNSVFOVAlMUVqJTg2JUFBJUJDMSUxOGklMjJRJTFBSSU4NkhDJUE2JTBDbSVCMyVFQSVBNiVFQislOEIlMDAlMDUlQkElQ0MlQkElMjglREElQUYlQTklMEIlN0ZGJUNGJThDJTIyJTI3JTVFJTI0JUNFJTgy
JUUwcCVFNiU5QyU3QiVFRSUzRCVGNyUwRTMlQjclRUUlREUlMTRuJUQzJUI1JTgyJUFDJUNDJUFDJTkzJUNDbSVFOW8lMDclMUIlRkV6VW4lRDZKJUM5JUNEWVYlQ0UlQUMlMTMlRUMlM0ElOEVrJUQ1ZiVFQiVBNSVBQ2VKJUNBJURBJUQ5ZiUzRCU5NyVFMyVCMkYlQTQlOUYlOTUlQjVhJUMzJTNCU1klRjl6JUJEWSVE
NiVFRSUxNyVCRSVDQSU4QUIlMTYlQjUlQ0VkJTk5JUFGaiU4OSUyQyVENlclOUIlQjElMUMlQzglQjIlQ0NXJUQzJURBWCU5RiUzRSUwMyVGMSVFMkgwJUI4JTIzJUVDJUQ5JUU1JUVDJUQyJUU4JTNFJUM4JTI2JUNFJTk2UiVFRiVENiU1QiVBRSVGNUUlQUElMDYlRkMlRThaJUI0JTk4JUYyJUVBUiVFQSVCQSU3RXBv
ciVENyVDNiVDMiUxNCVEQ3YlQUQlRjElMkNXJTkzJThEJTVDJUU5QyVEQiVCRCVEOSVFQiVEMyUwMjAlOEIlMEUlQkE0JUY1JUFEJTEzJUVDOCU4RiVFMiU3RiUzQSVFMiUyRiVGQSUyRiUwRCVBNSVGRSUyOCVDNSVCMSVFRjklNUUlMjcwJUE0JUM2JUUzJUE0JUZBJTNEJTI5JTA4JTNEJUQxNSVCNCVFNiVBMzRIJTE5
ZCVFQiUxQiU5MSVGQkNFJUM1JUY0bCU5MyU5N3IlQTMlMjElOEQlQTNxJUNEJUFGJUYwXyVDMSUyQW0lOTclMUUlMTIlRDclM0ElRTUlRjQlRTclMjd3JTdGJUJDJUI5JTdEJUZCJThGdSVBMi1BJUI3JTFBJUFFRSVGQyUwRSVCRiVBMCVCMiUyOCVCMiVBOSVENCUxMGglQUMlOEMlQzhHJUE3JUJGLiU2MCUxRiUwNSUx
MCVBOSU1Qi4lOUUlREMlN0UlRjglRjMlRUUlQzMlQkIlRkYlREUlQkYlQjklOTdoJTNGJTk0JTAwJTI4JUM4MyVCNSU5RSU3RSVBRVMlRkZmJTFEJUY4cCVGQiVEQiVERiVGRiVGRSVGNSVGQiVERCVGQl8lOEYlMTIlMEQlRkIlQTElODQlQkYlNUUuJUIzJUQ1RCVFNSUyQiVGOUlkJTdGMEElMTQlMTIlM0UlQjIlMkJ5
ZSVBNiUxMSUzQiUwRSUwRSU4RCVCMCVGRiU5OSVCMHMlQjQlQjclQTElQjMlQzJMJTlCS3ElMUNwLSU4NiU5RSVGN18lRTklOEIlQTYlRUYlNDAlMDYlQTlNJUIwJTFFayUwMCVBRSVDNSVFQSVFM2UlRDAlODIlQzAlN0QlMEFsTiUyNyVFNk5DJUIyJThEJUUzJUU3JUNGb24lNDAlQkNaJUNBVWklQUUlQTUlRkIlQzUl
RTAlRkIlRkQlOEIlMTclREYlN0YlMjclRkQ0ZCU4MyVENE8lN0MlRDElQTJ5JTFBUiVEMVRsRzclODQlODc2JUUxJUQzJTNBJTExSSUxN28lODclRjBOJTAzJUVGLSVFMSUwQmclQTIlODQlQTIlRTElRjklMkZEJUY0diUwOTglRTAlNUUlRDMlODUzJTA3JTA3eCUxMiUxMiU5RSUwNiUzQyUxNyUzQiU5NiUwQiU4NyVF
REIlQzUlRTYlQ0MlMTYlN0UlMUElRDElMEElQjglM0MlMERoJTk1JUZBOCVEQiVCMiUzQyVGNSVCMSVFRSVDNiVDMyU5RUolODIlODUlRUElODcxYiUyNiUxMSUxMSVFNyU4OCVBMSUwMiVDMiUyM2hPJUYwJTFERyU5M0psJUE5JTJGJTJBJTNBJTEwTSUyQSVEQSU4QSUwNmNFOTglQkMlQTMlQTglRTglRTElQTElODd1
MCVDNSVDMyVGMC0lMTBzJThDJUJEJUIxJThBJTgzJTBFYiUyMyU5NiUxMC0lMjIlQTJQJUQ3JTAwJTlEcCUxOFElRDQlRTMlRjklRDglQUYlQ0MlQzMlRTFTOCU1QiUxMiVDRSVCNiUyOSVGMiVENHklQjFFck54JTFDJTExTiU4MCUxQiVCNSUxOCVGNGMlMUY5JUU0JUEyJThBJTIzJUE2JTkyOW0lQTElRUUtJTExJUFD
JThFJUI4JUNEdCVBRWtJJTA2JUYwJTA2MSUxOWIlMkElMkZ2JTE2JURBJUFGJTgyJUYwJTlFYyVGNHglMTQlMENPJUQ1ayVFNCU4MiVCOCVCMyUxMCVCOCVFQkNOJUFDJUE1JTNEJTA1JUFFcSVDODUlMEUlRTAlQTclN0YlQzhZc1MlQUMlN0IlRjAlQjglRDclMDQlMUU4JTEyJTI0JTBBJUI1JUU5WkUlRDJCJTJGJUJB
bCVEOSU4NCUyRmMlRjQwJTA2JUE2JUQzRCU5QyU1RFolMDklMUIlREU5JUM5JTAwJUZEJUNEJUQzJTg4LWwlQzUlQjglQkElOTYlODElNDBvRiUyQSUxNklxJTg4JUNEJTFDJTNFJTQwJTVEVSVFQSVDNSUxNXolQTclRTclMDElQkQlQTIlODElRTklMjElRTIlMTIlODUlM0NQJUE3JTg3JUJDJTI3JUM4JTI5JTg2JUE3
JUJBJUY2JUQ0JUQzJUZCJTkzJTBBJUIzJTIzQiVENCVERjElQkUlRjclMDMlRjQlQzUlOEVHJTE5JTNDJUVCJUZCJUE5JUM3JUU2JTk4JTFCJTNCJTNBJTA1JTE3JTdEJUY1UHclRTglOTg4JTgyJUExJTk2cCU4NyU1QyVFMSUwMyVFQSUxNyU4OGtiJTBCJUJEVyVENyU3RSU4QyVCQiVFRCVGMlAlQkJoJTBDJUMzJTg5
JUYxZiU4MHklRTglMEYlQ0MlOUM1JUY1JTFDYSU3RE13JTIzJUY4JTdFJUVFJTExQSVDRCVBQyVDMiUwMyVFNCVEN2slMTklMEQlMTElRDZRU1clQ0ZrJURGJTA3JTBGJUYzJTg4WkMlRTMlREIrJUVEJUMyJUEzayVCRE4wRyVDOSUwMiVCRCVFNyVGMSUwQyVGOSVDMSU5NyUxNCVCOSU5MCVFRSUyMSU5NiU4MCVBNyVC
RCVBRCU5RSVGMyVEMSVGNiVFOVMlRkQlMkIlRDglRkYlMEYlOUElRTZmUA!!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>