<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



/**
 * 控制器类 W3B_PlatformAdminInformation 
 *
 * @access public
 */
class W3B_PlatformAdminInformation 
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminInformation(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		$this->SetMessageQueue($aMessageQueue) ;
		$sMsgPrinter = new JCAT_MessageHTMLPrinter() ;
		$aMessageQueue->AddPrinter($sMsgPrinter) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		
		$sHere = JCAT_Global::TidyPath( dirname(__FILE__) ) ;
		
		//<<[UnmodifiableBlock.Start]::Initialize Children::>>//
		// 创建并加载视图：W3B_PlatformAdminInformationView
		$aView = new W3B_PlatformAdminInformationView($this) ;
		$this->AddView($aView) ;

		// 创建并加载视图：W3B_PlatformAdminFrameView
		$aView = new W3B_PlatformAdminFrameView($this) ;
		$this->AddView($aView) ;
		//<<[UnmodifiableBlock.End]::Initialize Children::>>// 

		//<<[UnmodifiableBlock.Start]::Register Children Global Name::>>//
		// 注册全局对象
		$aView = JCAT_View::GetViewByGlobalName('W3B_PlatformAdminInformationView') ;
		JCAT_View::RegisterGlobalName($aView,'MainView') ;
		//<<[UnmodifiableBlock.End]::Register Children Global Name::>>// 
		
		//<<[UnmodifiableBlock.Start]::Set Document To View::>>//

		//<<[UnmodifiableBlock.End]::Set Document To View::>>// 
		

		// 在此添加代码 
		// TODO ... ... 
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun(array $arrArg=array())
	{
		$aInfoView = $this->GetView('W3B_PlatformAdminInformationView') ;
		
		// 载入平台配置属性
		$aPlatformPreference = new JCAT_FSPreference(PLATFORM_PREFERENCE_DIR) ;
				
		// 接受 用户提交表单
		if( $aInfoView->IsSubmitingForm() )
		{
			$aInfoView->SetDataFromSubmited() ;
			
			// 用户输入校验
			if( $aInfoView->VerifyData() )
			{
				$sEmail = $aInfoView->GetUICtrlExchangeData('Email') ;
				$sPassword = $aInfoView->GetUICtrlExchangeData('Password') ;
				
				// 保存
				$aPlatformPreference->SetItem('/Platform/Administrator','Email',$sEmail) ;
				if($sPassword)
				{
					$sPassword = md5($sPassword) ;
					$aPlatformPreference->SetItem('/Platform/Administrator','Password',$sPassword) ;

					new JCAT_Message( JCAT_Language::SentenceEx('平台管理密码已更新。','W3B_Platform',null),MSGMVC_OK) ;
				}
				
				new JCAT_Message( JCAT_Language::SentenceEx('信息已保存。','W3B_Platform',null),MSGMVC_OK) ;
			}
		}
		
		// 初始化表单
		else 
		{
			$sEmail = $aPlatformPreference->GetItem('/Platform/Administrator','Email') ;
			$aInfoView->SetUICtrlExchangeData('Email',$sEmail) ;
		}
		
		$aInfoView->SetUICtrlExchangeData('Password','') ;
		$aInfoView->SetUICtrlExchangeData('PasswordRepeat','') ;
		
		// 显示视图 W3B_PlatformAdminFrameView
		$aFrameView = $this->GetView('W3B_PlatformAdminFrameView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFrameView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminFrameView')) ;
		$aFrameView->ShowView() ;
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUwNCVGQSU4MCU4OCVENCVBM3UlRTkrJTgwJUY4UiVDNHRIJTBGNUNHJURFJTE4NCVDREolMTRHJTkyJTIzJUQyJTk1JTI1QyVEQiVBQyVCQSVFOSVCQSVFOCUyMiU0MCU4MS4lQjMuJThBJUY2ayVFQSVDMiU5RiVEMXNHJTk2YyUyRmpnJTIxJTBDZyVFNiVEQyU3
QiVFRSUzRCVGNyU4Q1IlQUJlJTVEV1YlQzdqJUI4aSU5RDYlMEVTJUFCSyU3QiUxMyUwNyVDRWIlNUUlMkYlMTdKJUU1JUNCJUEzJUI0JTlFNCUwRXFqJTFBViVBMzlZJUNDJUYyZiVBQSVGMiVCQ3klQjQlNUNMJUYzJUFDbiUwNiVCOSU5MyVENiVDRCVFMyVCNiU3RCVBNCVEMiVGQSU4NyVDNXIlRDYlQkMlRkZwVFpV
eSVENSVFQyU5RCVDRiU4QXlzMCVBNyVDMyVCNC4lMTYlRjNmRjclMkYlMTF0JUJBJTA3ayVDQyUwMyVDOCVDQiU4QiVDOSU4NSVBNiU3RFRMJTk4JUNFciUzQW0lMURYJThEJUE3JUEyJTA5JUYzJUFEJUQ1JTYwJUQ1WCVBQyUyRnIlRUElRUMlMUIlRUIlQkElQjAlMEMlN0MlRTglOTYlMTElOUVNJTBBdSVCRSVDQyVF
N3RpWCVENyU1QiVCQSVBRCUwMGslQjBhJTlGJTI1TiVFMyUxMCUyNyVFNiVCMyVGOCVFRiVGNiVGOCVEMyVFOCVBRCUwRWklM0QlMUJCJTNBJURFJUM1JUQ4JTNEVyUwNyVCNSU5RiUwRmolREQlMDclQjklOUUtJUZCJTNBJUFDJUYzbCUxOCVBODQlQjIlRkIlODUlQzglRUQlQUUlQTNqJTdDJUI0JTJDJUVBJTdDSSU5
MCVGNiU1RSVCOCVDRSUxMyVGMWclOTAlOEElRTQlMjIlOUJYJThENyU4MiU3RCVGRiVFMiVGNiVGNyUwRjclQkYlRkMlREQ4JTI0STAlQjAlQjYlRDUlMDglOUMlOUU4ZXlVJUE1JUUzJTlDKyVFMCU5OGslOTIlM0IlQTUlOUYlMjYwJUY2JTA0JUM4JUQ0JUFGJUNCJTE3NyU5RiVGRSVCOCVGRCVGNCVFQiVCRiUxRiUz
RiVEQ1MlMUMlM0MlQTYlMDAlQzgtUiVCNSUxOCUzRiVFNGklN0QxJTBGdCVCOCVGOSVGOSVBRiU3RiVGRSVGQyVFRCVGNiVFM08lN0IlOEElQjYlRjElOTglQzJZJUNDZiVFOSVGQyU1QyUxNSVGMyVGQzMlQzl2JTI3JTgyJUFDciVFOCVDOCUyRiVGM0slRURYJTlDJTk4JUI4JUQ0JUM0JUNFJTAzYnMlMkZvJTlCJUFB
JUVBJUEyJTJBeiUxQSVEQSVFMyVERCUxRCUxOWYlMUUlOUQlRDFTJUEzZyU5MCU4MmolRTkuMiUwMiVFMGUlQ0MlRUYlREUlMDMlMTElMDIlRjc5JUIxJUJFJTNEJUQ3JUFGJTFBJUFEdHAlRkQlRUElRDUlRjU1JTAyJTJGZyVGOSVCQyVENiUwRiVEMyVGQSVERiVFNCVEQiVFRCVFQiVEN18lN0YlOTUlM0IlODklQzcl
ODclODklMTMlM0IlQjIlQ0JKJTNGJTBBJTI0JURCMEclNUUxTyVBQVglOEVUJTJDJTA2JThBJUI5TCVDNSVFRVhFJTFFJUM3JTlFYSUzRlIlOTElMTglMkIucSVFRXklQ0IlQjdrJUQ5JTBEJTg3JUQyJUQwcSVDMyVDNCVFNkMlRDliJUJFJTBBJTAzJUM5JUQ3JUU5MTAlODIlMkIlQkUlODklRTMlNDAlRjgueCVENiVD
MHZDJTI3cSVGOCU4QyUyMU8lODYlREMlM0QlRTQlOTQlOEElODMlMkJyJUMxJTI3JUYwJTVEJTBFNCUzRiUxMyUyNVYlN0NjJUNGJUNCJUREJTlFTUMlMkYlOTAlQTNVKyUxMyUzRiUxMCU3QyUxNSU4OCVERVUrJTAzJTA3JUI1JUI3JUU4JUZCeCUyOCUzQiU3Q1glODElMTMlRENTJUUwRTBKZiVEOE8lQjElOTclQTgl
MDU5JTIyJTE5JUJGRyUzRCVGNkklMjElQ0R4JTI4TSVCRSU5Nm0lRkNWJUE4JTdEJTE1JUFFJTEzJThGYSVFNVglMjMlRDQlQ0IlRTklQkUlNDBfJTlCTCVFNyU4QiVBMCUwMSUxNyVBM3YrJUNBVlolQzglMEUwbSVCRSU5MTglMkYlQjVWJThDJUVFJUE3SSUzRHQlMTIlMUIlOUElQUMlOTElRUIlOEElOTUlQzklOEYl
RUYlRDYlODklMEQlRUMlMTUlRjR2QyUwNzUlOTIlQjYyJUY0JUIyJTI0JUQzWnIlQzklQ0QlNDB6ZislRDAlOUYlMTh3JUUyNiVGQSU5RSU4RSU5MCUwQnolQzglOTNBKyVBNSUxMSUwOCVEQiVBMyVCRSU4N1QlQTclODMlMUElOEIlMEUlRjRLJUVDJTQwJTA0ditjJTNGJTkwJTAzJUU0OHElMDIlMDElN0QlQzQlQTAl
MDUlNUQlM0MlRTglQjFGbyUxRCVENCVCMSU4OSUxRHAlQUYlMTMlOTclOTclRTYlMjRzJUE4JTNGJUZDaCVGRSU4OSVBQSVBMCUwNzQlOEMlOTFfJUI2JUNFMCUyMyVFNk4lMTYlRDglMjMlRDclQjklQkYlQUIlQzl3dW4lRDJaJTg0JUJFKyVDQ04lOUZNJUVDJUExJUNFJUYyJUU0JTBEJUIwVCUxRmolMDlRJTBCJURG
JTkwJTA3MCU5MzZWJUNDJUE2JUM0JUNDRiUxRCVEMiUwRCUyQiVDRSUyNyVDOCU1QiU5QSVEMCVDM0dNJUZEJUE4JTdGJTgwJTFDNCU3QiVEMiUwMiVEQSUxOCVGMCU4MyU4MCVENyVFMCVDNSVDOCVGNTAlM0JPJTg1JTA2eCU4NCVBRnYlRjElM0QlRTQlMUYlMTklQTglQTMlMTMlMTdyRSUxRSVBNiVGRSVEMGc3JUVF
JTkzJUU3eiU4OCVDNSUzQ0hDJTgzJUJDMFYlQ0MlRjMwJTlGMSUzQyU5OSVFRCVCQyVFRCU5MSUzRkslNjBVNSUyQTAlOUI1eiVGMTMlQ0MlMTElNUUlMjclN0YlQzMlRUIlRTQlN0QlMDYlMkM3OCVFQSU2MCVEQSU5NyUxQyUzRSVFMCVEMyUxRXJ6JUZBTXB6JTJCJUM4JTFGJTdCJTAzJUZEJTNFJUE4JTBGeiUyRiUy
MXglMTklQ0QlMTYlREVhJURFJUM5JTNCJUNDJUI1JTBCJTlGJTVFYSU4RTYlRkQlOERsJUZGJTAzJUM0JTk2JTgyJUZC
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>