<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 W3B_PlatformAdminLogin 
 *
 * @access public
 */
class W3B_PlatformAdminLogin 
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminLogin(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		$sMsgPrinter = new JCAT_MessageHTMLPrinter() ;
		$aMessageQueue->AddPrinter($sMsgPrinter) ;
		
		$sHere = JCAT_Global::TidyPath( dirname(__FILE__) ) ;
		
		// 创建并加载视图：LoginView
		$aView = new W3B_PlatformAdminLoginView($this) ;
		$this->AddView($aView) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun(array $arrArg=array())
	{
		$aLoginView = $this->GetView('W3B_PlatformAdminLoginView') ;
		
		// 接受 用户提交表单
		if( $aLoginView->IsSubmitingForm() )
		{
			$aLoginView->SetDataFromSubmited() ;
			
			// 用户输入校验
			if( $aLoginView->VerifyData() )
			{
				$sPassword = $aLoginView->GetUICtrlExchangeData('Password') ;
				
				// 开始验证用户
				$aAdministrator = new W3B_PlatformAdministrator() ;
				$aAdministrator->Login('',$sPassword) ;
			}
		}
		
		//$aLoginView->EnableView( JCAT_IdentityManager::QueryIdentity('W3B_PlatformAdministrator')? false: true ) ;
		
		// 显示视图
		$aLoginView->ShowView() ;
	}
}

?>