<?php

/**
 * W3B 平台管理员
 */
class W3B_PlatformAdministrator extends JCAT_Document 
		implements JCAT_IIdentity 
{
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	public function W3B_PlatformAdministrator()
	{		
		$this->JCAT_Document(__CLASS__) ;
		$this->_InitializeIdentityObject() ;
	}
	
	/**
	 * 初始化对象，独立于构造函数，以便构造函数和 __wakeup() 均能访问
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function _InitializeIdentityObject()
	{
		// 创建默认的 会话对象
		$this->aSession = JCAT_Session::StartSession() ;
	}
	
	/**
	 * 主要用于会话恢复时
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __wakeup()
	{
		// 初始化 对象
		$this->_InitializeIdentityObject() ;
		
		// 父类函数
		parent::__wakeup() ;
		
		// 注册到 身份中心
		if( $this->IsLogined() )
		{
			JCAT_IdentityManager::IdentityLogin($this) ;
		}
		
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		$aPlatformPreference->SetItem('/Platform/Administrator','ActiveTime',time()) ;	
	}

	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __sleep()
	{
		$arrParentPropertys = parent::__sleep() ;
		$arrParentPropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('bLogined',__CLASS__) ;		
		return $arrParentPropertys ;
	}
	
	/**
	 * 取得身份类型
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetIdentityClass()
	{
		return __CLASS__ ;
	}
	
	/**
	 * 用户注册
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Register(){return false;}
	
	/**
	 * 用户注销
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Unregister(){return false;}

	
	/**
	 * 修改用户信息
	 * 
	 * @access	public
	 * @param	$arrDataNamesForModify=array()		array		被修改的指定数据名称,如果为空则修改所有数据
	 * @return	bool
	 */
	public function ModifyUserInfomation( array $arrDataNamesForModify=array() ){return false;}
	
	/**
	 * 登录
	 * 
	 * @access	public
	 * @param 	$sAuthName		string	认证用户名
	 * @param 	$sAuthPassword	string	认证用户密码
	 * @return	bool
	 */
	public function Login($sAuthName,$sAuthPassword)
	{
		// 载入平台配置
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		
		// 比较密码
		if( md5($sAuthPassword) == $aPlatformPreference->GetItem('/Platform/Administrator','Password') )
		{
			$this->bLogined = true ;
			
			// 保存 Session
			$aSession = $this->GetSession() ;
			$aSession->SetVariable($this->GetIdentityClass(),$this) ;
			
			// 提交到身份管理器
			JCAT_IdentityManager::IdentityLogin($this) ;

			// 更改信息
			$aPlatformPreference->SetItem('/Platform/Administrator','LastLoginTime',time()) ;
			$aPlatformPreference->SetItem('/Platform/Administrator','LastLoginIP',$_SERVER['REMOTE_ADDR']) ;
			
			// 消息
			new JCAT_Message(JCAT_Language::SentenceEx('登录成功。','W3B_Platform',null,$sAuthName),'MSGMVC_OK') ;
			
			return true ;
		}
		
		else
		{
			return false ;
		}
	}

	/**
	 * 登出
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Logout()
	{
		$this->bLogined = false ;
		
		// 从 会话里面移除
		$aSession = $this->GetSession() ;
		$aSession->DeleteVariable($this->GetIdentityClass()) ;
		
		return true ;
	}
	
	/**
	 * 加查是否已登录
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function IsLogined()
	{
		return $this->bLogined ;
	}
	
	
	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$nPurviewBit		int			权限位
	 * @param	$sPurviewName=null	string		指定权限名称
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewName=null)
	{
		return true ;
	}
	
	
	/**
	 * 设置最新的活动时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function Active()
	{
		return true ;
	}
	
	
	/**
	 * 设置会话对象
	 * 
	 * @access	public
	 * @param	$aSession	JCAT_ISession	会话
	 * @return	old_value
	 * @see JCAT_IIdentity::SetSession()
	 */
	public function SetSession(JCAT_ISession $aSession)
	{		
		$old_value = $this->aSession ;
		$this->aSession = $aSession ;
		return $old_value ;
	}

	
	/**
	 * 取得会话对象
	 * 
	 * @access	public
	 * @return	JCAT_ISession
	 * @see JCAT_IIdentity::GetSession()
	 */
	public function GetSession()
	{
		return $this->aSession ;
	}
	
	/**
	 * 设置最新的活动时间
	 * 
	 * @access	public
	 * @param 	$nAuthID		int		认证用户ID
	 * @param 	$sSessionKey	string	认证用户会话名
	 * @return	int
	 */
	public function LoadFromSession($nAuthID,$sSessionKey){return time();}

	
	/**
	 * 设置密码加密方式
	 * 
	 * @access	public
	 * @param	$Encryption=JCAT_Authentication::MD5_PASSWORD		callback	加密函数
	 * @return	void
	 */
	public function SetEncryption( $Encryption=JCAT_Authentication::PASSWORD_MD5 ){}
	
	/**
	 * 取得密码加密方式
	 * 
	 * @access	public
	 * @return	callback
	 */
	public function GetEncryption(){return JCAT_Authentication::PASSWORD_PLAIN;}
	
	/**
	 * 取得认证用户名
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthName(){return 'PlatformAdministrator';}
	
	/**
	 * 取得认证密码（加密过的密文）
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetAuthPassword(){return '**********';}
	
	/**
	 * 取得帐号创建时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetCreateTime(){return 0;}
	
	/**
	 * 取得最近登录时间
	 * 
	 * @access	public
	 * @return	int
	 */
	public function GetLastLoginTime()
	{
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		return intval($aPlatformPreference->GetItem('/Platform/Administrator','LastLoginTime')) ;
	}
	
	/**
	 * 取得最近登录IP
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetLastLoginIP()
	{
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		return intval($aPlatformPreference->GetItem('/Platform/Administrator','LastLoginIP')) ;
	}
	
	/**
	 * 取得最近活动时间
	 * 
	 * @access	public
	 * @return	string
	 */
	public function GetActiveTime()
	{
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		return intval($aPlatformPreference->GetItem('/Platform/Administrator','ActiveTime')) ;
	}
	
	

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Load() {}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Save() {}



	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Create() {}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Delete() {}

	/**
	 * 文档是否存在
	 * 
	 * @access	public
	 * @param	$bRequery=false		bool	对于高级文档（如数据库文档），查询 文档是否存在 会存在一定性能代价 ，该参数允许缓存查询结果
	 * @return	bool
	 */
	public function IsExists( $bRequery=false ) {return true ;}
	
	
	
	/**
	 * 用于保存身份的会话类类名
	 * 
	 * @access	private
	 * @var		string
	 */
	private $aSession ;
	
	/**
	 * 记录是否已经的登录 
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bLogined = false ;
}

?>
