<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



/**
 * 控制器类 W3B_PlatformAdminRegEdit 
 *
 * @access public
 */
class W3B_PlatformAdminRegEdit 
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminRegEdit(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		
		
		// 创建并加载视图：W3B_PlatformAdminRegEditKeysView
		$aView = new W3B_PlatformAdminRegEditKeysView($this) ;
		JCAT_View::RegisterGlobalName($aView,'MainView') ;
		$this->AddView($aView) ;

		// 创建并加载视图：W3B_PlatformAdminFrameView
		$aView = new W3B_PlatformAdminFrameView($this) ;
		$this->AddView($aView) ;

		// 在此添加代码 
		// TODO ... ... 
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		// 操作
		if( !empty($_REQUEST['act']) )
		{
			switch ($_REQUEST['act'])
			{
				case 'copy' :
					$this->CopyKey() ;
					break ;

				case 'delete' :
					$this->DeleteKey() ;
					break ;

				case 'rename' :
					$this->RenameKey() ;
					break ;

				case 'add' :
					$this->AddKey() ;
					break ;
			}
		}
		
		// 加载 配置
		$aPreference = W3B_Platform::GetPreference() ;
		$aRootKey = $aPreference->GetKey('/') ;
		$sKeysViewStream = $this->IteratorKeys($aRootKey) ;
		
		$aView = $this->GetView('W3B_PlatformAdminRegEditKeysView') ;
		$aUI = $aView->GetUI() ;
		$aUI->SetVar('sKeysViewStream',$sKeysViewStream) ;
		

		
		// 视图: W3B_PlatformAdminFrameView
		$aView = $this->GetView('W3B_PlatformAdminFrameView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminFrameView')) ;
		$aView->ShowView() ;
	}
	
	/**
	 * 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function CopyKey()
	{
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['keypath']) ) ;
		$sKeyPath = base64_decode($_REQUEST['keypath']) ;
		JCAT_ASSERT::ASSERT_DIR($sKeyPath)  ;
		
		$sParentDir = dirname($sKeyPath).'/' ;
		$sKeyName = basename($sKeyPath) ;
		
		$sNewKeyName = 'copy.of.' . $sKeyName.'_'.date('G.i.s') ;
		
		if( JCAT_FSO::CopyDir($sKeyPath,$sParentDir.$sNewKeyName,array('.svn')) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('复制键“%s”。','W3B_Platform',null,$sKeyName),MSGMVC_OK) ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法复制键“%s”。','W3B_Platform',null,$sKeyName),MSGMVC_BAD) ;			
		}
	}

	/**
	 * 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function DeleteKey()
	{
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['keypath']) ) ;
		$sKeyPath = base64_decode($_REQUEST['keypath']) ;
		JCAT_ASSERT::ASSERT_DIR($sKeyPath)  ;
		$sKeyName = basename($sKeyPath) ;
	
		if( JCAT_FSO::DeleteDir($sKeyPath,true) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除了键“%s”。','W3B_Platform',null,$sKeyName),MSGMVC_OK) ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法删除键“%s”。','W3B_Platform',null,$sKeyName),MSGMVC_BAD) ;			
		}
	}

	/**
	 * 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function RenameKey()
	{
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['keypath']) ) ;
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['newname']) ) ;
		$sKeyPath = base64_decode($_REQUEST['keypath']) ;
		JCAT_ASSERT::ASSERT_DIR($sKeyPath)  ;
		$sKeyName = basename($sKeyPath) ;
		$sKeyParent = dirname($sKeyPath).'/' ;

		if( rename($sKeyPath,$sKeyParent.$_REQUEST['newname']) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('键“%s”重命名为：“%s”。','W3B_Platform',null,$sKeyName,$_REQUEST['newname']),MSGMVC_OK) ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法重命名键“%s”为：“%s”。','W3B_Platform',null,$sKeyName,$_REQUEST['newname']),MSGMVC_BAD) ;			
		}
	}
	
	/**
	 * 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function AddKey()
	{
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['parentkeypath']) ) ;
		JCAT_ASSERT::ASSERT_( isset($_REQUEST['newname']) ) ;
		$sParentKeyPath = base64_decode($_REQUEST['parentkeypath']) ;
		JCAT_ASSERT::ASSERT_DIR($sParentKeyPath)  ;
		
		$aParentKey = new JCAT_FSPreferenceKey($sParentKeyPath) ;
		if( $aParentKey->CreateKey($_REQUEST['newname']) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建键“%s”','W3B_Platform',null,$_REQUEST['newname']),MSGMVC_OK) ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法创建键“%s”','W3B_Platform',null,$_REQUEST['newname']),MSGMVC_BAD) ;			
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	string
	 */
	protected function IteratorKeys(JCAT_IPreferenceKey $aParentKey,$nDepth=1)
	{
		$sRet = '' ;
		$aUI = JCAT_ViewHtml::CreateShareUI() ;
		
		$aIterator = $aParentKey->CreateChildKeyIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aChildKey = $aIterator->Current() ;
			$sChildKeyName = $aChildKey->GetName() ;
			$sChildKeyPath = $aChildKey->GetFSPath() ;
			$sChildrenViewStream = $this->IteratorKeys($aChildKey,$nDepth+1) ;
			
			$aUI->SetVar('sChildrenViewStream',$sChildrenViewStream) ;
			$aUI->SetVar('sKeyName',$sChildKeyName) ;
			$aUI->SetVar('nDepth',$nDepth) ;
			$aUI->SetVar('sPath',$sChildKeyPath) ;
			$aUI->SetVar('sEncodedPath',base64_encode($sChildKeyPath)) ;
			$aUI->SetVar('sKeyHash',md5($sChildKeyPath)) ;
			
			$sRet.= $aUI->Display('template.W3B_PlatformAdminRegEditKey.html',false) ;
			
			$aIterator->Next() ;
		}
		
		return $sRet ;
	}
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUwNCVGQyU4MCU4OCVFMiVBM00lRTgrJTgwNCVBNCUxODMlMTklRDIlN0MlMENVeWMlRDAlMTIlMkJRJTFDUSU4NkhHJUEyJTA0bSVCMyVDQSVBNiVFQiVBMiU4QiUwMCUwNSVCQSVDQyVCQSUyOCVEQSVBRiVBOSUwQiU3RkYlQ0YlOEMlMkMlMjclNUUlMjQlQ0Ul
ODIlQTA4JUY3cSUxRSVGNyU4RTJLJUIzdiVCNWVYJThBJTlENSU5OXIlOTJZJUE2JUY4JUVFJUUyJTgwJTJDJUFCZiVCNSVFNCUzQ18lOURlJUNETDklQzElQTklQUFZSmclQjYlNUMlRTQlOUQlOEMlRTd5JUU3bCVCNSU5QyVFNyVFMyVBNiVFMyVFNSUyNGslM0FDJUJEJTdGJUM2JUIzJUU2JUU3JUU1aiVEMSVCOSVG
RkF4ViVEN3klREQlRTlNJTE2RSVENSU4OSVGMiVBOTMlMjklOUElQ0VYJTlDJTNFRSVDMSVDNTFRJUM2JUVGJUMyTyVBRmZXJTEyJUVFJTAxJTA5JTNGJTVCJUU0JUUyVCVDMyVFOSU5NyUyQUUlRkNHSyVBMSVGNTRpJUFGciVBMSVFNiUwN2tXWCUyQSU3RUglOTklQ0YlMkNlJTNDJTJCJUY4ZCU5NVclMjIlQThaJUJC
JUJEJTg4JUQ2SFNoJUVDJUQyJTk0JTI4JTI3OCVFOSUzRSU5QSVGRiVGQyU5OCU3RiUxMSVCQyU5NiUyNSVEQSVBMyUyNSU1RCVGNSVCRSVBNiVERiVCM2UlOTElRkV4JTkxdl9kJTNCJTdEJUU2JUNBMiVFMyVEMTIlNDAlQzlMJUYzJTFCMyVGNyUwN0UlRjUlRjRsVTQlRjlKJUE0JUU4RyVFMyU4QyVBRiVENF8lQzIl
MkFhJTE3JTg4di0lRTVVQiVERiUzQyVCOSVGRCVFMyVERCVDRCVBRiVGRiUyOCUyNyVDMiUxMiUwQ0slQjclMTQlOEYlRjQlOTIlMEIlOUElRDd1NiVDREUlMEEwJTJBJTA5ciVFNyVGNCVENyUwMSVENCUyMyUwMCUzQSVCOU0lRjklRTQlRTYlRTMlOUYlQjclMUYlN0YlRkIlRUYlQzMlQkIlN0IlODhnJTBGJTIxJTkw
ZCUxNyUxOV9OJTNGJUM3JUQxJUJFJTE5JTA3JTNFJURDJUZDJUYyJUY3JUJGJTdGJUZEJTdFJUZCJUUxJUZEJTExQlclMUZCJTkwJUU1YiU5MVUlMTMlNUVUJUY5JTI3JTkwJUZEJUMxJTA0ViVFNyVGMDElQkMlQ0UlQUYlRTUlQjYlRTIlQTQlOEIlQTAlMDQlMjYlOUYlMDF3JThGJUY2JUVBJTgyJTk1JTA5ViVFMkol
QzglRkQ2JTBGJTYwJTk4eXAlMjklQUUlOTclQjglMDIlMTklQTBWJUY2ciUyQyUxMiVCMCVGRiVENSVERCU1RCUxMCU4MCVDOCVGQiVENFhGJTI3JUYyJTI2QyU4QSUwQTElMkYlNUUlRUN2JTI4JUJDJTVFJUU0VSUyMyUyRiVBMyVGNSVDNSVFNiVGQiVGRCVDQiU5NyVERiU3RiU5NyU5MyVENCUwOSVFMyU5NEQlODQl
OTklQjQlRUMlMDYlMUUlQTMlNUJKJUQ4JTA2JThGJUUxJUM3JUU5KyUyQSVEMiUwMS0lRDglOUElQjYlQTklMTMlRTBMJUU2JUI1bCVFRCUxNyVDQyUwQ0glREElMEYlRDUlMjUlOEYlRTYlQjMlOTUlOTc4JTFCJTJGOTUlM0M2JUU4JTdCJTg5JUQ3JTFGJTBFRiUzQ0glRkMyRk0lRDgyMyVEQ055JUUwOCUzQyVCMCUy
OSVBNyVGMyUxOSVGMSVEOCVBOSVFOSUyNSUzRSU5OSU5NCVGQyVGQ3UlQ0IlREEwJTlEJUYycCVFRXBfJTNEJUU1JTAxYyVGMiVCN3hHJUNFSCUxRiVCNSVFMEIlQzAlMDElNUMlQTMlQjglRUIlODAlRTMlRkFNJUQ1JUUzJUJFJUREJTAzJUM2aCUwNSUwQyUzRCUyQSVEODYlOEElQzElMkJmJUE2XyVBNCU4RV8uJTEx
JTFCcyVBQSU4NiVFOCU5NSUyNkklOUMlREElMTQlMEYlQjglMTglMDFyJUE4JUZBJTdDJTA2JUJFJUUwJTVDJTFBJTVFJUQyJUMzJTNCJTA1JTI3JUE3JUVCJTI1JTgyJTlCJThGJUJGJTk3JUQ0JTBEJUUyJUI0JTBGJUNDJTAxdCU5QiVFOCVEQiVFMlklODd4JTI4JTFGQ0slQzglMjMlRjQlMEYlQjclN0QlRTcyZiUx
QiU5Q29oJTkxJUY2JTg1RyUwMUMlQ0MlODYlN0UlRTZVJUMyJTBCJUY0JUQ3JUEwdyU4MyVGRS0lN0NSJUYxJUFEJTAzJTE3JURGJTkxcyUwRSVBRiVDMyU4NSVBRiU1RVYlRTclMDU4JTNBJUUwTiVDMjZ1JTg1JTVFJUUwJTE5JUMxJTkwJTFEJTNDSyUxOCVBNzYlN0YlMEIlRUQlOUJzJUNDJUNCJTNGJUNDYUMlMEYz
JTEyMyVCNCVDMSVDMSUwQ0slMEVMRyU4QiUwQiVBNiU4OSUxOSVDQSVGOSVDNSVEMCU5MiU4QyVDMCU4OUIlQUJvJTAzJURCJUY0JTk4NyUxOCUwQSVBRkQlOEUlOEIlMTklREElMTMlMDYlMEYlMUMlQzQlQjQlMEMlMUMlQzRsJTdEJUU4JUYzVSVDRiUwOCU1RUUlRkElMjElMjZnJUVCQiVDN1YlRjBGbyUxNyVGQiVC
MCU4RVIlMjYlRTclMTYlMjUlOTglQTElMEElQkUlMDklQzUlREMlQzAlRDlOJTg3JUUwJUIyJTA2JTE2SSVDMSVDMyUxN1olQjElM0JhJTIxJUY2SGp1JUUxJTk5JTgzJUQ5JUU5JUExJUNFJTdGJTlBJTg4JTNEJTgwJTI2JUNDZyUyQiVFMyVFMCUxRCU5NSVBNyVFOCU4OSVERSVGMyUyOSVGQSU4RCUwRiUxOCVFQyU5
NFMlRUMlMDYlMTVvVSVFQyU5NHglN0IlMUVmJUU3JTAyJUNGTCU4OCVEQ00lRThGJUFGJUE0JTI3OSU4NSU1QiVFNCUyNyUwRXQlMjIlQjclMUNhJTI3JTI4JUVBJUY4ZkJYV3AlODJHJTg0JUJBTTMlMTYlQkJDJUUwJTdGJTlCJUY2JUEzJTIxJUYwSiVFQyVDRiUxNiVERSVDRDFrJUQ0RSU4OSVGNyUxNiUzRSU2MEdG
JTg2JUU0XzklRTAlMDElQUQlRUElMDglRkN6JTkySzQlMDclRTdtJUNGJTEwJTdGJTEzJUZCJUZGJTAxY21uJUVG
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>