<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



/**
 * 控制器类 W3B_PlatformAdminSMTPSetting 
 *
 * @access public
 */
class W3B_PlatformAdminSMTPSetting 
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminSMTPSetting(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		
		$sHere = JCAT_Global::TidyPath( dirname(__FILE__) ) ;
		
		//<<[UnmodifiableBlock.Start]::Initialize Children::>>//
		// 创建并加载视图：W3B_PlatformAdminSMTPSettingView
		$aView = new W3B_PlatformAdminSMTPSettingView($this) ;
		$this->AddView($aView) ;

		// 创建并加载视图：W3B_PlatformAdminFrameView
		$aView = new W3B_PlatformAdminFrameView($this) ;
		$this->AddView($aView) ;
		//<<[UnmodifiableBlock.End]::Initialize Children::>>// 

		//<<[UnmodifiableBlock.Start]::Register Children Global Name::>>//
		// 注册全局对象
		$aView = JCAT_View::GetViewByGlobalName('W3B_PlatformAdminSMTPSettingView') ;
		JCAT_View::RegisterGlobalName($aView,'MainView') ;
		//<<[UnmodifiableBlock.End]::Register Children Global Name::>>// 
		
		//<<[UnmodifiableBlock.Start]::Set Document To View::>>//

		//<<[UnmodifiableBlock.End]::Set Document To View::>>// 
		

		// 在此添加代码 
		// TODO ... ... 
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun(array $arrArg=array())
	{
		// 载入平台配置属性
		$aPlatformPreference = new JCAT_FSPreference(PLATFORM_PREFERENCE_DIR) ;
		
		// 视图: W3B_PlatformAdminSMTPSettingView
		$aView = $this->GetView('W3B_PlatformAdminSMTPSettingView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminSMTPSettingView')) ;

		// 提交表单视图 W3B_PlatformAdminSMTPSettingView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->SetDataFromSubmited() ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{
				$sSMTPServer = $aView->GetUICtrlExchangeData('SMTPServer') ;
				$sSMTPUser = $aView->GetUICtrlExchangeData('SMTPUser') ;
				$sSMTPPassword = $aView->GetUICtrlExchangeData('SMTPPassword') ;
				$sReply = $aView->GetUICtrlExchangeData('Reply') ;	
				$sAuthorName = $aView->GetUICtrlExchangeData('AuthorName') ;	
				$sMaxBCC = $aView->GetUICtrlExchangeData('MaxBCC') ;	
				
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','SMTPServer',$sSMTPServer) ;
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','SMTPUser',$sSMTPUser) ;
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','SMTPPassword',$sSMTPPassword) ;
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','Reply',$sReply) ;
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','AuthorName',$sAuthorName) ;
				$aPlatformPreference->SetItem('/Platform/Resource/SMTP','MaxBCC',$sMaxBCC) ;
				
				new JCAT_Message(JCAT_Language::SentenceEx('设置已保存。','W3B_Platform',null),MSGMVC_OK) ;
			}
		}
		
		else 
		{
			$sSMTPServer = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','SMTPServer') ;
			$sSMTPUser = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','SMTPUser') ;
			$sSMTPPassword = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','SMTPPassword') ;
			$sReply = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','Reply') ;
			$sAuthorName = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','AuthorName') ;
			$sMaxBCC = $aPlatformPreference->GetItem('/Platform/Resource/SMTP','MaxBCC') ;
			
			$aView->SetUICtrlExchangeData('SMTPServer',$sSMTPServer) ;
			$aView->SetUICtrlExchangeData('SMTPUser',$sSMTPUser) ;
			$aView->SetUICtrlExchangeData('SMTPPassword',$sSMTPPassword) ;
			$aView->SetUICtrlExchangeData('Reply',$sReply) ;	
			$aView->SetUICtrlExchangeData('AuthorName',$sAuthorName) ;	
			$aView->SetUICtrlExchangeData('MaxBCC',$sMaxBCC) ;	
		}

		// 视图: W3B_PlatformAdminFrameView
		$aView = $this->GetView('W3B_PlatformAdminFrameView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminFrameView')) ;

		// 显示视图 W3B_PlatformAdminFrameView
		$aView->ShowView() ;

	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFRNbyVEQkYlMTAlQkQlMTclRTglN0ZIJUY0JTAzJTIyUiUxRiVBREslMDclMDElQTQlMjUlQTVoJUQzJTI1JUI1JUQ0LlUlRkJiMCUxMktRWlIlODZIJUQ1JUEyJTBDJTVEcyVFQSVBNSVFNyVBMiU4NyUwMCUwNXolQ0MlQjklMjglREFfUyUxNyVGRSUxOSU3REtaJThFJTdEJUE4JUREJTgzJTQwciVGNiVD
RCVCQzdvZiUxNVotJUVCJTNBJUI3JTNBViVDMyUwRSU4QiVCMHElMUFaJTVEJUZEbSUyMiU0MCVENlklQjFZJTJCJTE1bSVDNmElQjFoJTlDJTIyaiUxQVYlQTMlQjlYJUE3UTNUUSVENCUxQ28lRDYlQ0JoVjRpRCVDMiVBMjltJUY3JUM3JTJBJTJDJUJFX28lRDIlRTYlRkQlMEJRYSU5RUd5JUIzN08lOTMlQUM5YWIl
M0MlODklOEElMjIlQzklRTIlRTZMJTlGJUJDQiVEMiVDNSUxMSU1Q2ElMUUlNDAlNUUlNUQuLiUyQiVEQUdiJURDMCU4RHQlQjR1YjUlOUUlQ0ElRDYlOTglQUYlQUQlMDYlQ0JjUSU1RUZ3JTlEJTI1JTk2JTgxJTk3JUFBZSVBNCVDRiUxNiU4OSU5QW8lQTJMJTFGJTFBJUQ2JUY1QSU5RiVFNiVENldIJTlBJTBDWSU0
MCUxQSVBNyU4OCU5OCVDRiVFMiVCRjklRTIlMkYlQkN3VUolRUIlRDklMTQlRUQlRTMlNUROJUJGZ1dJJUVEJUU3JTkzWiVGN0klQjYlRDMlOTclQzMlMkElQUQlRjNsJTFBJUE4JTgwJTNDJUQ0JTNBJUYzeCVCQ0klOEFoJUEzJTIxJUVEJUEzJTFEJTlEJTI3JUYyJURGJUMzJTAwbSU4MiUxRSVCRSVENXglMkIlRDgl
QjclMkZuJTdGJUZCcCVGMyVGM18lOERTJUREJTI4JUM2JUQwJUI2JTFBJTk0JUY0JUM0JTA1JThCJUYyJTNDJThDJTIzJTBEJTAxR1YlOTElREMlRjklRjc0JTgxcSUyNCU0MCVBNWElQjF6cSVGMyVFOSVGNyVEQk8lQkYlRkMlRjMlRjElQzMlM0QlQzUlQzljJTBBJTgwJUVDJTI0VCVFQiVGOCUyMU8lRUIlN0YlRjMl
QzAlODclOUIlOUYlRkUlRkMlRkIlOEZfbyUzRiVGRXglQTRoJTFCJThGJTI5JUM4JTNBTSVDM2wlQUUlOTIlMkMlRkFMciVBOE0lOTB5JTA0JTFGJUY5NiVEQVYlN0IlODglODglODklQzMlOEElOTglM0MrNiU4RiVGNiVCNiVCNSVBQS5UJUU5JTg1JUFGNiVCNyU1QiU5M2ElOTIlREUlN0IlN0QlODElRjRyJTg3JUEw
JURBJUQ4JUVCJTk5JTA2JTYwJURGJUIzJUJCLSVENyU4NCVDMCU3RC4lNUMlOUQlQ0UlQUIlQkIlOEFWJUJBJUQ4JUYwJUQ3JUFGJUFGJUFGJTkxJUI4TSVBMyVBQyVBOCVBRSU5QiVGNSU5RiVDNSUwRiU4NzdvJUJFJUZDJTIyJTIyJTgxJUMzJTI3JTAxJUYxJTg5JUVDJUIyJTI0cCU5OCVFQyUyOCVDRmZXVDglMDYl
MTVxJThCSiU3RkglQTVjUiVEMSVDNyU5MyUyMyVCRSUxOFAlQzlKSSVFNCU5NSVBRmYlOEElMDklQTYlQjhwJUI3JTg4dSU4MSVCMWclOTIlMkIlQjYlM0FTJTlFJUMwJTk5JUNEJTE0MyUyOCUxMSU5MyVBMCVDRiUyNiVCMiVFMyU4MiVDQk0lQTAlODUlMDQ2JURFJTg3JThDJTA0JTAzJTdGJTIyJUJCJTg4JUQ5JTFF
JUNFJUY5JURFJUQ5RkkwcCUyNyU4MSVFMyUwMyVFQmdMeSVEMlElMUMlRjUlRkMlRDV5JTVCJTI0ciU4NyUzQVclMkMlOEIlMTVfJUEyJUI2JUU4JTgxQyU5RlMlMDIlQURtJTJBJUE4JUNEUU8lRDdlZTBEJUNEJTFENyUxNyUyMSVFMiU4NEolRUFQJTE5JUUwJUU5JTQwJUE3ciVDMkQlNUUlRjElRTklOTlyJUE1JTA0
JTA3UyVBRSUwMSVERHYlQUMlOTgzUiVEMCU4MSUyN1MlQkUlRkUlNUU5JUMwcCVFNSUwQiVGQ3AlRTYlMEIlQTklRkRBJUNGJUY0JTNCJTJBVi0lMkFGJTFEJTJBeiVGOCVDRG0lMTclREMlQkUlRDZXQmclMTklMTB3JUFBRiVFMCU4M2clMjMlRTAlOUNyJTNBJTNEJTAxJTk3RCVBRTIlQ0VWUiVCMSVFNSUwQSVGRTgl
RjAlQ0FBbSUzRiVBNXIlRDRlJTk4JTA1R18lQUVBdyVBMiVBQyVGRCVFMiVFOCVDNSUyNSVCMkQlRkQlOEU3JUFEJUY5WSVBNWMlMDUlOEQlQzglQjclQTElRDklQTBrJUY0OSUwNCVENyUxRTMlQzMlOENGJTI2JUU2ZSU4NiUzQSUwRjUlRkMlMDElQjglOTYxJUIwJUU4JTBEJUJEenYlM0QlMjMlREYlQTElMEMlMUEl
RjclRDBPWCUyMiVEQiVGMCU5RCU0MCVCQiVFMyVEOSVEMCUyOSVCNS4lOEUlMjclQkNYJUJBOXQlRDglM0VmJUU5QSVBMyU5QiVDOCUzRCVCQyVERSVGQiVEQWMlRTglRDMlM0IlQzQlMTMlRkQlMEQlMEM4MSVFMyUzRSVFQSUwQyVBMCU3QiVDNyU4OCVBRSUyQiUzQiVBOCVERCVBRnIlREViJTlFYk4lQTklOTQlQkIl
OUElN0IlODQlOTklQzQlREFDJUE3JTlFJUQ1WVklRUYlOTljJUZBaSUwRW4lRjUlMDMlRTYlODdvalM5JUMwJUFDJTVEUiU3QiVERiVCNyVFQiU3RTl6JTNEJTFGciVFQyUxMSU3RUMlMEYlQkIlRTklODIlMUIlMUElMDYlRDAlQjQlQUI0JUQ2eiUzQiVEOCU5RiUzRCVBRiVGNi0lRTglRkIlODklRUNqJThDJURFJTI5
JTE3JTlFcyUwMyUzRCVFRjElOTclQ0FXJTNBJTg2JTg3JUQwJTE2d2clMTMlQkQlQUIlRDIlRTQlMjVmJThCJTNFJUYxJUJFJUUzJUE5JTgxJTFEJTgxJTNGJUI2JURGJUQ2JURBJUNFJUUxJThEJTVCJUVBJTFFJUMxJUE3JTdEJTg0JTBGJUQ1JTFFJTJGJUQxJUVCJUIyXyVBMFclMDN3ZCU4RiVERCUyNFUlOURSJTdC
JUE0JUIxJTk4JTBEJUVFJTlEJTFGJUJGJTdDJUE5JUZGViUwRSVGRiUwMnUlRDZ1JUFG
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>