<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 W3B_PlatformAdminService 
 *
 * @access public
 */
class W3B_PlatformAdminService 
	extends JCAT_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_PlatformAdminService(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		// 初始化文档、视图、子控制器 
		$this->Initialize() ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;		
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 文档
		$aDoc = new W3B_ServiceDocument() ;
		$this->AddDocument($aDoc,'ServiceDocument') ;
		
		
		// 创建并加载视图：W3B_PlatformAdminFrameView
		$aView = new W3B_PlatformAdminFrameView($this) ;
		$this->AddView($aView) ;

		// 创建并加载视图：W3B_PlatformAdminServiceView
		$aView = new W3B_PlatformAdminServiceView($this) ;
		JCAT_View::RegisterGlobalName($aView,'MainView') ;
		$aView->SetDocument($aDoc) ;
		
		$this->AddView($aView) ;
		
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun(array $arrArg=array())
	{
		$aServiceView = $this->GetView('W3B_PlatformAdminServiceView') ;
		$aDoc = $this->GetDocument('ServiceDocument') ;
	
		// 修改服务信息
		if( isset($_REQUEST['nServiceId']) )
		{
			$aDoc->SetPrimaryKeyValue($_REQUEST['nServiceId']) ;
			if( !$aDoc->Load() )
			{
				new JCAT_Message( JCAT_Language::SentenceEx('指定的文档不存在; nServiceId:“%s”','W3B_Platform',null,$_REQUEST['nServiceId']), MSGMVC_BAD) ;
				//$aServiceView->EnableView(false) ;
			}
			
			else 
			{
				$aServiceView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
			}
		}
		
						
		// 接受 用户提交表单
		if( $aServiceView->IsSubmitingForm() )
		{
			$aServiceView->SetDataFromSubmited() ;
			
			do{
				// 用户输入校验
				if( !$aServiceView->VerifyData() )
				{
					break ;
				}				
				
				// 文档交换
				$aServiceView->ExchangeData() ;
				
				// 保存文档
				if( $aDoc->Serialize() )
				{
					new JCAT_Message( JCAT_Language::SentenceEx('保存成功。','W3B_Platform',null), MSGMVC_OK) ;
					//$aServiceView->EnableView(false) ;

					// 加入域名
					try
					{
						$sServiceDomain = $aServiceView->GetUICtrlExchangeData('ServiceDomain') ;
						$aDoc->AddDoname($sServiceDomain) ;
					}
					catch (W3B_ServiceException $e)
					{
						new JCAT_Message( $e->getMessage(), MSGMVC_BAD) ;
						break ;	
					}
				}

				else 
				{
					new JCAT_Message( JCAT_Language::SentenceEx('保存失败。','W3B_Platform',null), MSGMVC_BAD) ;
				}
				

			}while(0) ;
		}
		
		// 显示视图
		else 
		{
		}

		// 显示视图 W3B_PlatformAdminFrameView
		$aFrameView = $this->GetView('W3B_PlatformAdminFrameView') ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFrameView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','W3B_PlatformAdminFrameView')) ;
		$aFrameView->ShowView() ;
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQzFuJURCRiUxMCVCRCUxNyVFOCUzRiVBNCVGQSU4MCU4OCU5MiVBOCVENiVBNSU4MyUwMCVEMiU5MlIlQzRmSSVFRiU5MktHJUJBJTE4JTBDJUM1SiU5NFYlOTIlMjElQ0ElQjUlMjlDJUQ3JTlDeiVDOTklRTglMjElNDAlODElMUVzLiU4QSVGNmslRUElQzIlOUYlRDE3JTJCJUNCJTg5JTBGJTg5cyUx
MCVDMCU5RCU5RHklRUYlQ0QlOUJZJUE1TiVEMyVCOS4lMUQlREIlQTklQjklRTklMjYlQUQlMUQlQTdOJTlCJUNFJTBEJTA0JUQ4aiVCOVklQUYlQjQlQ0UlRDclMjclRTlmWiUzQkYlRDRqOSVCNSVGQXQlQjUlQzglRUIlQTklQ0UlRjMlRkElQzl6NSVDQiVCM00lREQlQ0ZZJUJBJUE5JTlGJUI2JUJBJTI3JTNBJURE
JUZDJUJDWiUyRiVFQSVGNyUxRkwlQTdlJTk5JTk3JUY1JUNFeFElMkMlRUJRJUJFJUZFJUE1JUM4cCVDQyUyOCVGQyUxNCUxNWclODdMJTkzcHclRkYlRjQlN0N6biVGOCUxRSVBOCUwOCVEMkVOJUQxJTI2JUEyJTlGJUFCJUE0JUZCJTFGJTlDJTFBJTJGJTI3cXUlOUVTJTNCJURGJTNCJUQ3JTg1YyVFMSVDMyVGNHkl
RTQlRDQlQjJpJUExJUM3JUVCJTdDSSU5NyU5NnMlQkQlQTMlREIlMTJpNSUxRSVGNXklQzJqJUM3JTg4NCUxRSVDRCVGRiVGMSU5MCU3RiUxNiVGRWRKJTlBJThGJTk2NCVBQyVGQiU5QW4lQzc1RSVBRCVDNyU4QiU5QSVGN0UlQUUlRDdVJTdEU2YlM0ZaJTA2JTJBJTkzJUQ5JUZFJUNBJUNDJUREJUJFJUEzcnIlQjIu
NiVGOSU5QVJaJTA3JUUzJUVDJTJGJUQ0JUJGJTg2VWQlMTclODQ2JTlDJURBJThCJTk4JUJGJTdDciVGQiVDNyU5QiU5QnclRkYlRDQlOEUlQzklMTIlMEMlMEIlMUIlRTMlQjNOJTdDJUM2JUYzJUIyTCUyNzklQTUlODBjaUglRUUlOUMlRkUyJTgxdSslMDBSJTdGMyU3RnIlRjMlRTElQ0YlREIlMEYlQkYlRkQlRjcl
RkUlQ0QlM0QlQzUlRDFDJTBBJTI0JUI5RSVBQVclOTNPeSU5QV8lQ0QlMDMlMUZuJURFJUZFJUZEJUVGXyVCRiVERiVCRSVGRiVGNSU0MCVEMSVCMiUxRVIlQjAlRDViJTkxLiVDNyVCQVglRTYlMUZJdiU3QiUxM1QlOTklQzNHcSU5MV8lOThtRCVBNCU4MUtDJUNDJTNFJTIxbiUxQyVFQ20lOTElQUE2VCVEMSU5MzAl
RkIlREQlREUlOTNhJUU2JUUxa3pfJUY0JTA0UlAlQUQlRERVRiUwOSVEOCVGRiVFNSVERCU1QitCJUU0JTdEJTA0NiVCN2MlRjMlOTQlRDElOEElODUlRUJnJUNGJUFFJUFGUXglQjElQzglOTclMUIlRjMlMUElOUQlQ0YlODIlRUZ2JUNGJTlGJTdGJUZCTSVDRSUxMk9EJTA5JTkzTCVCNXklOTElQjhibmslQjElRTUl
OTclN0UlRUMlNUQlQ0ElMjglRTlLJUM0JTgySCU1RCVDOUI1JUI5JTlCJUU5JUQwJTFCJUVBJUQwJTFEViVBNyU5MWolMDdRJUE5RSVEQyVEMWElQUN0JUUwdjQlOEYlN0JqJURDJUQzJTgxJUFGRCVFNSUyQiVFRiU4QSUwMyUxNyU5OCUzRCU1RSUyNW4lQzglRDQlQTVMJTkwJUUzJUNFJUI1RCVCRSUwNCU4RSU5OHkl
QTglRjdQJUE3NCVDNyU5OSVFMyU1QiVDQ3olQjNxJUE1JUI2JUIyJUNGJUVGciVFNiVEMCU5MzVFJUExLiUwMyU5NnQlQTElMDM4JTAzJTFEJUNDJTNBJUMwJUM5JUI0dCUyNyU5QSVDRiVCOCUxNiVENiVDMCVENCVDQnglODAlMUFoUiVDMHQlODElM0RHJTVDJTExJTBGcGYlRDAlMUUlMEYlODElREJzJUUzJTI4cSVB
OSVERiU4MCUyOSUxQiVEOG0lNUUlMDElOTclQjQlQTIlQTclMTAlRjklMUMlRkQlMDQlOEEwJTkxJTBGJTdDJUU5JTI2JThCJTJDUiUxNSVFNSU4NCU5MSVCMiU4MyUyOCVFOSU5MSUyRiVCQ1AlMTUlRDdHJUUwJTE3JUUwJTgwJURFbSVENyUxQm4lMDUlRUElQjUlOTIlRDAlMEIlMEUlMDYlREQlQkQlODA4UCUyMyUy
MiVENSU5MCVDMCUxMVUlRDIlMERJJTAzMyVFN3YlRDAlQ0IlOEMlMkYlQzIlMjIlM0YlQTYlODklMUYlQ0YlREIlQkUlRjIlM0RfJTBEbCUzRiUxRTRGJTk1aiVDQiVEMyVBQiU2MFglMDAlRjNVJUVGJTA1YiVENSUyOUslRkElMUMlRkRLTyU5MEclRjAlMDElREUlMkElRUElQ0YlODN2JTgxJTE5TiUxOWElRDAlQUMl
MDQlRkElRTMlRTBGJUFGVSVEMCVDNCUxQyU5NSUxRiUwRCVDRCU3QzFXJUU4JTE0JTA2JTFGJTdEJUNDJTkyJUQyJThGJUZEJTNFJTdFblolQTgtJUY0JURBUiU1RGo5JUU3JTE3JTdFJUFDJTExJTFGbCU3RCVDNW1fJTBELWUlRDklQzYlMUIlRDIlMUMlRDJuJUMwJUZGJTEwJUZCK2clM0ElQ0EwJTI3JUFBJTE1JUFE
JTQwJTAyJThCJThEJUUxJUIzJTI0JTJDJUY4KyUwQSVFOCU4RTBLJUY4JTExJTI2JTk4JTlGRSVCMyUxMiVDMCU5OCVFOCVDMCUxQS0lQzAlRTMlRkFqJTg0JURFeSU5NSU3QiVGMGU2JTFBYSVBNyU5QUNoJTg0JTk3JTdEJUQ0JUI5JTgxJUJCJUY3SmIlQTYlQjQlMDNyLiVGQiVCRUolOTglMUYlOEYlRDklNUUlQTNn
JUJGJUMyJTFFJTg5JUZEJTVDJTE5JTdDJUI2aSVDNkElMDVNJUY4JTE5JURGJTE5JUU2JTkwcCVCMyU4M2JOWCVFNCUzRCVDRCUwMSVFNyVBRCVGRiUxMiVERSUwMXMlODQlOUUlMjdNJUZBViUxNSVCOCU4MSUxMyVEMiU1RXklOUMlREUlMDl2ayU2MCVGNlQlQ0UlQTAlMDclQkIlMjYlRTclODMlRUYlRTglRUZhJUY3
JTNGJTdGU3ElMUQ!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>