<?php 

class W3B_DependenceAdvIterator implements JCAT_IBothwayIterator
{
	/**
	 * ignore Platform
	 * 
	 * @access	const
	 * @var		int
	 */
	const IGNORE_PLATFORM = 1 ;
	
	/**
	 * return object of item, but not  W3B_DependenceItem object
	 * 
	 * @access	const
	 * @var		int
	 */
	const DEPTH_FIRST = 2 ;
	
	/**
	 * return object of item, but not  W3B_DependenceItem object
	 * 
	 * @access	const
	 * @var		int
	 */
	//const RETURN_ITEM_OB = 4 ;
	
	/**
	 * return object of item, but not  W3B_DependenceItem object
	 * 
	 * @access	const
	 * @var		int
	 */
	const FLAG_DEFAULT = 3 ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aDependenceItem				W3B_DependenceItem
	 * @param	$bReverse=false					bool
	 * @param	$nDepth=1						int						$nDepth=0 表示无限递归
	 * @param	$nFlag=self::FLAG_DEFAULT		int
	 * @return	void
	 */
	public function W3B_DependenceAdvIterator(W3B_DependenceItem $aDependenceItem,$bReverse=false,$nDepth=1,$nFlag=self::FLAG_DEFAULT)
	{
		$this->nFlag = $nFlag ;
		$this->sInsId = $aDependenceItem->GetItemName() . '_' . ++self::$nAssignedInsId ;
		
		$arrIterators = array() ;
		$aTopIterator = $aDependenceItem->CreateDependenceIterator($bReverse) ;
		
		// 递归
		if($nDepth!=1)
		{
			for ( $aTopIterator->First(); !$aTopIterator->IsDone(); $aTopIterator->Next() )
			{
				$aItem = $aTopIterator->Current();
				$arrIterators[] = new W3B_DependenceAdvIterator($aItem,$bReverse,$nDepth-1,$nFlag) ;
			}
		}
		
		// 本层迭代
		$aTopIterator = $aDependenceItem->CreateDependenceIterator($bReverse) ;
		($nFlag&self::DEPTH_FIRST) ?
						array_push($arrIterators,$aTopIterator) :
						array_unshift($arrIterators,$aTopIterator) ;

		// the iterators's iterator ^_^!
		$this->aIteratorsIterator = new JCAT_ArrayIterator($arrIterators) ;
		
		
		// initialize
		$this->First() ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param 	$sTry			string		First/Next/Previous/Last
	 * @param 	$sTill		string		First/Next/Previous/Last
	 * @return	W3B_DependenceItem
	 */
	private function Iterate($sTry,$sTill,$sSwitch)
	{
		while( $aIterator=$this->aIteratorsIterator->Current() )
		{
			$aItem = $aIterator->$sTry() ;
			
			while($aItem and $this->IsIgnore($aItem))
			{
				$aItem=$aIterator->$sTill() ;
			}
			
			if($aItem)
			{
				return $aItem ;
			}
			
			else 
			{
				$aIterator = $this->aIteratorsIterator->$sTill() ;
				
				// 所有迭代器 全部完成		
				if( !$aIterator )
				{
					return null ;
				}
				
				else
				{
					if( $aItem=$aIterator->{$sSwitch}() and !$this->IsIgnore($aItem) )
					{
						return $aItem ;
					}
					
					else
					{
						continue ;
					}
				}
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function First()
	{
		$this->aIteratorsIterator->First() ;
		return $this->Iterate('First','Next','First') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Next()
	{
		return $this->Iterate('Next','Next','First') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Current()
	{
		$aIterator = $this->aIteratorsIterator->Current() ;
		return $aIterator? $aIterator->Current(): null ;		
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Previous()
	{
		return $this->Iterate('Previous','Previous','Last') ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function Last()
	{
		$this->aIteratorsIterator->Last() ;
		return $this->Iterate('Last','Previous','Last') ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsDone()
	{
		$aIterator = $this->aIteratorsIterator->Current() ;
		return $aIterator? $aIterator->IsDone(): true ;	
	}
	

	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aDependenceItem		W3B_DependenceItem
	 * @return	bool
	 */
	private function IsIgnore(W3B_DependenceItem $aDependenceItem)
	{
		return $this->nFlag&self::IGNORE_PLATFORM and ($aDependenceItem->GetItemName()=='Platform') ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aDependenceItem		W3B_DependenceItem
	 * @return	mixed
	 */
	private function GetReturn(W3B_DependenceItem $aDependenceItem=null)
	{
		// return item object or not
		return ($this->nFlag&self::RETURN_ITEM_OB) ?
			($aDependenceItem? $aDependenceItem->GetAttachment(): null ):
			$aDependenceItem ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nFlag ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDependencies ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IIterator
	 */
	private $aIteratorsIterator ;
	
	private $sInsId = 0 ;
	static private $nAssignedInsId = 0 ; 
	
}

?>