<?php


class W3B_DependenceException extends JCAT_Exception 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sMsg=''	string	异常消息
	 * @param	$nCode		int		JCAT统一异常ID，是一个2进制24位整数，左八位代表包ID，左16位代表Class ID，右8位代表异常ID
	 * @return	void
	 */
	public function W3B_DependenceException($sRequrieItemName, JCAT_Version $aRequrieItemVersion=null, W3B_DependenceItem $aExistItem=null, $sMsg='', $nCode=0)
	{
		$this->sRequrieItemName = $sRequrieItemName ;
		$this->aRequrieItemVersion = $aRequrieItemVersion ;
		$this->aExistItem = $aExistItem ;
		
		$this->JCAT_Exception($sMsg,$nCode) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetRequrieItemName()
	{
		return $this->sRequrieItemName ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetRequrieItemVersion()
	{
		return $this->aRequrieItemVersion ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_DependenceItem
	 */
	public function GetExistItem()
	{
		return $this->aExistItem ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sRequrieItemName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aRequrieItemVersion ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_DependenceItem
	 */
	private $aExistItem ;
}
?>