<?php


class W3B_DependenceItem
{
	/**
	 *
	 * @access	public
	 * @param	$sItemName					string
	 * @param	$aCompatibleVersions		JCAT_VersionCompat
	 * @param	$aVersion					JCAT_Version
	 * @return	void
	 */
	public function W3B_DependenceItem($sItemName,JCAT_VersionCompat $aCompatibleVersions,JCAT_Version $aVersion=null)
	{
		$this->sItemName = $sItemName ;
		$this->aVersion = $aVersion ;
		$this->aCompatibleVersions = $aCompatibleVersions ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetItemName()
	{
		return $this->sItemName ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetItemVersion()
	{
		return $this->aVersion ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_VersionCompat
	 */
	public function GetItemCompatibleVersions()
	{
		return $this->aCompatibleVersions ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aItem 						W3B_DependenceItem
	 * @param	$aDependenceVersion 		JCAT_Version
	 * @return	bool
	 */
	public function AddDependenceItem(W3B_DependenceItem $aItem,JCAT_Version $aDependenceVersion=null,$bTest=false)
	{
		// 版本检查
		if($aDependenceVersion)
		{
			$aCompatibleVersions = $aItem->GetItemCompatibleVersions() ;
			if( !$aCompatibleVersions->Check($aDependenceVersion) )
			{
				return false ;
			}		
		}
		
		// 建立依赖/被依赖 关系
		if( !$bTest )
		{
			self::BuildDependenceShip($this,$aItem) ;
		}
		
		// 返回
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aDependItem		W3B_DependenceItem
	 * @return	void
	 */
	public function RemoveDependenceItem(W3B_DependenceItem $aDependItem)
	{
		self::DestroyDependenceShip($this,$aDependItem) ;
	}
	
	static private function BuildDependenceShip(W3B_DependenceItem $aFrom,W3B_DependenceItem $aTo)
	{
		$aFrom->arrDependencies[$aTo->GetItemName()] = $aTo ;
		$aTo->arrReverseDependencies[$aFrom->GetItemName()] = $aFrom ;
	}
	
	static private function DestroyDependenceShip(W3B_DependenceItem $aFrom,W3B_DependenceItem $aTo)
	{
		unset($aFrom->arrDependencies[$aTo->GetItemName()]) ;
		unset($aTo->arrReverseDependencies[$aFrom->GetItemName()]) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName		string
	 * @return	W3B_DependenceItem
	 */
	public function GetDependenceItem($sItemName)
	{
		return isset($this->arrDependencies[$sItemName])?
						$this->arrDependencies[$sItemName]: null ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName		string
	 * @return	W3B_DependenceItem
	 */
	public function GetReverseDependenceItem($sItemName)
	{
		return isset($this->arrReverseDependencies[$sItemName])?
						$this->arrReverseDependencies[$sItemName]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$bReverse=false														bool
	 * @return	JCAT_IIterator
	 */
	public function CreateDependenceIterator($bReverse=false)
	{
		return $bReverse?
				 new JCAT_ArrayIterator($this->arrReverseDependencies) :
				 new JCAT_ArrayIterator($this->arrDependencies) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Attachment		mixed
	 * @return	void
	 */
	public function Attach($Attachment)
	{
		$this->Attachment = $Attachment ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	mixed
	 */
	public function GetAttachment()
	{
		return $this->Attachment ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sItemName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aVersion ;
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_VersionCompat
	 */
	private $aCompatibleVersions ;
	
	private $arrDependencies = array() ;
	
	private $arrReverseDependencies = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		mixed
	 */
	private $Attachment ;
}
?>