<?

class W3B_DependenceTree
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aItem						W3B_DependenceItem
	 * @param	$aDependenceIterator		JCAT_IIterator
	 * @param	$bTest=false				bool
	 * @return	void
	 */
	public function AppendItem(W3B_DependenceItem $aItem,JCAT_IIterator $aDependenceIterator,$bTest=false)
	{
		for ( $aDependenceIterator->First(); !$aDependenceIterator->IsDone(); $aDependenceIterator->Next() )
		{
			$sDepenItem=$aDependenceIterator->Current();
			//@list( $sDependItemName, $sDependItemVersion ) = explode(':',$sDepenItem) ;	
			$arrDependSegments = explode(':',$sDepenItem) ;
			$sDependItemName = isset($arrDependSegments[0])? $arrDependSegments[0]: '' ;
			$sDependItemVersion = isset($arrDependSegments[1])? $arrDependSegments[1]: '' ;
			$aDependItemVersion = $sDependItemVersion? JCAT_Version::FromString($sDependItemVersion): null ;		
			
			$aDependenceItem = $this->GetDependenceItem($sDependItemName) ;
			if(!$aDependenceItem)
			{
				throw new W3B_DependenceException(
					$sDependItemName
					, $aDependItemVersion
					, null 
					, JCAT_Language::SentenceEx(
						'无法满足 %s 的依赖项: %s'
						, 'W3B_Extensions', null
						, $aItem->GetItemName(), $sDependItemName
				)) ;
			}
			
			// 加入依赖项
			if( !$aItem->AddDependenceItem($aDependenceItem,$aDependItemVersion,$bTest) )
			{
				throw new W3B_DependenceException(
					$sDependItemName
					, $aDependItemVersion
					, $aDependenceItem 
					, JCAT_Language::SentenceEx(
						'%s 依赖  %s 版本:%s，存在的版本为：%s（与指定的版本不兼容）'
						, 'W3B_Extensions', null
						, $aItem->GetItemName(), $sDependItemName, $aDependItemVersion, $aDependenceItem->GetItemVersion()
				)) ;
			}
		}
		
		if(!$bTest)
		{
			$this->arrDependenceItems[$aItem->GetItemName()] = $aItem ;
		}
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName		string
	 * @return	bool
	 */
	public function RemoveItem($sItemName)
	{
		$aItem = $this->GetDependenceItem($sItemName) ;
		$aItemReverseDependIter = $aItem->CreateDependenceIterator(true) ;
		if( $aItemReverseDependIter->First() )
		{
			return false ;
		}
		
		$aItemDependIter = $aItem->CreateDependenceIterator() ;
		for ( $aItemDependIter->First(); !$aItemDependIter->IsDone(); $aItemDependIter->Next() )
		{
			$aDependItem = $aItemDependIter->Current() ;
			$aItem->RemoveDependenceItem($aDependItem) ;
		}
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sItemName		string
	 * @return	W3B_DependenceItem
	 */
	public function GetDependenceItem($sItemName)
	{
		return isset($this->arrDependenceItems[$sItemName])? $this->arrDependenceItems[$sItemName]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateDependItemIter()
	{
		return new JCAT_ArrayIterator($this->arrDependenceItems) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aItems		array
	 * @return	void
	 */
	public function AppendItemsFromArray(array $arrItems)
	{
		foreach ($arrItems as $arrItemObs)
		{
			list($aItem,$aItemDepends) = $arrItemObs ;
			
			JCAT_ASSERT::ASSERT_INSTANCE($aItem, 'W3B_DependenceItem', JCAT_Language::SentenceEx(
				'参数 $arrItems 必须是一个二维数组，每个元素必须包含 W3B_DependenceItem对象及其依赖项的迭代器。'
				,'W3B_Platform',null))  ;

			JCAT_ASSERT::ASSERT_INSTANCE($aItemDepends, 'JCAT_IIterator', JCAT_Language::SentenceEx(
				'参数 $arrItems 必须是一个二维数组，每个元素必须包含 W3B_DependenceItem对象及其依赖项的迭代器。'
				,'W3B_Platform',null))  ;

			$this->RecursionAddItem($arrItems,$aItem,$aItemDepends) ;
		}
	}

	private function RecursionAddItem(array $arrItems,W3B_DependenceItem $aItem,JCAT_IIterator $aItemDepends)
	{
		// 已经存在
		if( $this->GetDependenceItem( $aItem->GetItemName() ) )
		{
			return ;
		}
		
		// 先加入依赖项
		for ( $aItemDepends->First(); !$aItemDepends->IsDone(); $aItemDepends->Next() )
		{
			$sDepend = $aItemDepends->Current();
			list($sDependItem,) = explode(':',$sDepend) ;
			
			// 依赖项满足
			if( $this->GetDependenceItem( $sDependItem ) )
			{
				continue ;
			}
		
			if( !isset($arrItems[$sDependItem]) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'遇到无法满足的依赖项:%s', 'W3B_Platform', null, $sDepend
				)) ;
			}
			
			$this->RecursionAddItem($arrItems,$arrItems[$sDependItem][0],$arrItems[$sDependItem][1]) ;
		}
		
		$this->AppendItem($aItem,$aItemDepends) ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDependenceItems = array() ;
}
?>