<?
/*-- Project Introduce --*/


/**
 * 安装一个扩展包
 * 前置条件：安装包路径
 * 这个类不会积累状态，可以重复使用
 *
 * @author		alee
 * @access		public
 */
class W3B_EnableExtension extends W3B_Controller 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	bool
	 */
	static public function EnableExtension(W3B_Service $aService,$sExtName,$bEnable=true,$nPriority=null)
	{
		$aRequest = new JCAT_Request(JCAT_Request::TYPE_CUS) ;
		$aRequest->SetParam('sExtName',$sExtName) ;
		$aRequest->SetParam('aService',$aService) ;
		$aRequest->SetParam('aPlatform',$aService->GetPlatform()) ;
		$aRequest->SetParam('nPriority',$nPriority) ;
		$aRequest->SetParam('bDisable',!$bEnable) ;

		$aEnableExtension = W3B_Controller::CreateController('W3B_EnableExtension',$aService) ;
		$aEnableExtension->SetRequest($aRequest) ;
		return $aEnableExtension->MainRun() ;
	}
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_EnableExtension(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		$sExtName = $aRequest->GetParam('sExtName') ;
		$aService = $this->GetEnableService($aRequest) ;
		$bEnable = $this->GetEnable($aRequest) ;
		$nPriority = $this->GetEnablePriority($aRequest) ;
		
		// 检查前置条件:扩展包是否存在，是否可以读取
		if(!$this->CheckPrecondition($aRequest,$sExtName))
		{
			return false ;
		}		
		
		$aServicePreference = $aService->GetPreference() ;
		$arrEnableExtensions = $aServicePreference->GetItem('/Extensions',W3B_Platform::ITEM_ENABLE_EXTS) ;
		
		if( !is_array($arrEnableExtensions) )
		{
			$arrEnableExtensions = array() ;
		}
		
		// 扩展的安装对象
		$aExtDependItem = $this->GetEnablePlatform($aRequest)->GetExtensionManager()->GetExtensionDependenceTree()->GetDependenceItem($sExtName) ;
		$aExtInfo = $aExtDependItem->GetAttachment() ;
		
		$aSetup = $aExtInfo->CreateInstaller($this->GetPlatform()) ;
		 
		
		// 激活扩展
		if($bEnable)
		{
			// 调用扩展的 激活程序
			$aSetup->Enable($aService) ;
		
			
			if( !isset($arrEnableExtensions[$nPriority]) )
			{
				$arrEnableExtensions[$nPriority] = array() ;
			}
		
			if( !in_array($sExtName,$arrEnableExtensions[$nPriority]) )
			{
				$arrEnableExtensions[$nPriority][] = $sExtName ;
			}
		}
		
		// 禁用扩展
		else
		{
			// 调用扩展的 禁用程序
			$aSetup->Disable($aService) ;
			
			
			foreach ($arrEnableExtensions as $nPriority=>$arrExtsInPriority)
			{
				$nIdx = array_search($sExtName,$arrExtsInPriority) ;
				if( $nIdx!==false )
				{
					unset($arrEnableExtensions[$nPriority][$nIdx]) ;
					break ;
				}
			}
		}
		
		// 保存
		$aServicePreference->SetItem('/Extensions',W3B_Platform::ITEM_ENABLE_EXTS,$arrEnableExtensions) ;
		$aServicePreference->GetKey('/Extensions')->Save() ;
		
		// 消息
		new JCAT_Message(JCAT_Language::SentenceEx('扩展 %s 已经%s。','W3B_Extensions',null,$sExtName
				,JCAT_Language::SentenceEx(($bEnable?'激活':'禁用'),'W3B_Extensions',null)),W3B_IExtensionSetup::MSG_SUCCEED) ;
		
		// 添加到依赖树中
		$aPlatform = $aService->GetPlatform() ;
		$aService->GetExtensionManager()->AppendExtensionByName($sExtName,$aPlatform->GetExtensionVersion($sExtName)) ;
		
		return true ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	bool
	 */
	private function CheckPrecondition(JCAT_Request $aRequest,$sExtName)
	{
		// 检查参数
		if(!$sExtName)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sExtName','W3B_Extensions',null),MSGMVC_BAD) ;
			return false ;
		}
		
		// 检查扩展是否安装
		$aPlatform = $this->GetEnablePlatform($aRequest) ;
		if( !$aExtDependItem=$aPlatform->GetExtensionManager()->GetExtensionDependenceTree()->GetDependenceItem($sExtName) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('系统尚未安装指定的扩展 %s 。','W3B_Extensions',null,$sExtName),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		// 检查 参数 Priority
		$nPriority = $this->GetEnablePriority($aRequest) ;
		$bEnable = $this->GetEnable($aRequest) ;
		
		if( $bEnable and ($nPriority<=0 or $nPriority>10) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('参数 $nPriority(%s) 必须为 1-10 整数','W3B_Extensions',null,$aRequest->GetParam('nPriority')),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		
		
		$aService = $this->GetEnableService($aRequest) ;
		$aExtMgr = $aService->GetExtensionManager() ;
		$aExtDependTree = $aExtMgr->GetExtensionDependenceTree() ;
		
		// 检查依赖关系
		if($bEnable)
		{
			$arrMissExts = array() ;
			$aDependIter = $aExtDependItem->CreateDependenceIterator(false) ;
			for ( $aDependIter->First(); !$aDependIter->IsDone(); $aDependIter->Next() )
			{
				$aItem = $aDependIter->Current() ;
				$sDependExtName = $aItem->GetItemName() ;
				if(!$aExtDependTree->GetDependenceItem($sDependExtName))
				{
					$arrMissExts[] = $sDependExtName ;
				}
			}
			
			if(count($arrMissExts))
			{
				$sMissExts = implode(', ',$arrMissExts) ;
				new JCAT_Message(JCAT_Language::SentenceEx('扩展(%s)依赖项未满足：%s，无法被激活','W3B_Extensions',null,$sExtName,$sMissExts),W3B_IExtensionSetup::MSG_FAILED) ;
				return false ;
			}
		}
		
		// 检查被依赖关系
		else 
		{
			$aExtSrvDependItem = $aExtDependTree->GetDependenceItem($sExtName) ;
			if(!$aExtSrvDependItem)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定禁用的扩展(%s)尚未被激活','W3B_Extensions',null,$sExtName),W3B_IExtensionSetup::MSG_FAILED) ;
				return false ;
			}
			
			$aDependIter = $aExtSrvDependItem->CreateDependenceIterator(true) ;
			if($aDependIter)
			{
				$arrDependedExts = array() ;
				for ( $aDependIter->First(); !$aDependIter->IsDone(); $aDependIter->Next() )
				{
					$aItem = $aDependIter->Current() ;
					$arrDependedExts[] = $aItem->GetItemName() ;
				}
				
				if(count($arrDependedExts))
				{
					$sDependedExts = implode(', ',$arrDependedExts) ;
					new JCAT_Message(JCAT_Language::SentenceEx('无法禁用指定扩展(%s)，该扩展被以下扩展依赖：%s','W3B_Extensions',null,$sExtName,$sDependedExts),W3B_IExtensionSetup::MSG_FAILED) ;
					return false ;
				}
			}
			
		}
		
		return true ;
	}


	/**
	 * Description
	 *
	 * @access	private
	 * @return	W3B_Platform
	 */
	private function GetEnablePlatform(JCAT_Request $aRequest)
	{
		$aPlatform = $aRequest->GetParam('aPlatform') ;
		return $aPlatform? $aPlatform: $this->GetPlatform() ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	W3B_Service
	 */
	private function GetEnableService(JCAT_Request $aRequest)
	{
		$aService = $aRequest->GetParam('aService') ;
		return $aService? $aService: $this->GetService() ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	bool
	 */
	private function GetEnable(JCAT_Request $aRequest)
	{
		return $aRequest->GetParam('bDisable')? false: true ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	int
	 */
	private function GetEnablePriority(JCAT_Request $aRequest)
	{
		$nPriority = $aRequest->GetParam('nPriority') ;
		return ($nPriority===null)? 3: intval($nPriority) ;
	}
	
	
}

?>