<?php

class W3B_ExtensionDefaultSetup implements W3B_IExtensionSetup 
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$sExtName			string
	 * @param	$aExtVersion		JCAT_Version
	 * @return	void
	 */
	public function W3B_ExtensionDefaultSetup($sExtName,JCAT_Version $aExtVersion)
	{
		$this->sExtName = $sExtName ;
		$this->aExtVersion = $aExtVersion ;
	}

	
	// 平台  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 安装扩展
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Setup(W3B_Platform $aPlatform)
	{$aPlatform ;
		return true ;
	}
	
	/**
	 * 卸载扩展
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Unsetup(W3B_Platform $aPlatform,$bCompletely=false)
	{$aPlatform; $bCompletely;
		return true ;
	}

	
	
	// 服务 //////////////////////////////////////////////////////////////////////
	
	/**
	 * 在一个服务中启用扩展
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function Enable(W3B_Service $aService)
	{$aService ;
		return true ;
	}
	
	/**
	 * 在一个服务中禁用扩展
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function Disable(W3B_Service $aService)
	{$aService ;
		return true ;
	}
	
	
	/**
	 * 终止服务，回收扩展为服务提供的资源
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function TerminateService(W3B_Service $aService)
	{$aService ;
		return true ;		
	}
	
	
	
	
	// 资源  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 初始化平台资源（全新安装时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Platform
	 * @return	void
	 */
	public function InitializeResource(W3B_Platform $aPlatform)
	{
		$arrTables = $this->GetResourceDBTables() ;
		if(empty($arrTables))
		{
			return ;
		}
		
		// 创建数据表
		$aDB = $aPlatform->GetDefaultDB() ;
		
		foreach ($arrTables as $sTable=>$sSQL)
		{
			if($aDB->Query($sSQL))
			{
				new JCAT_Message(JCAT_Language::SentenceEx('创建数据表 %s','W3B_Platform',null,$sTable),W3B_IExtensionSetup::MSG_SUCCEED) ;
			}
			
			else
			{
				new JCAT_Message(JCAT_Language::SentenceEx('创建数据表 %s 失败。','W3B_Platform',null,$sTable),W3B_IExtensionSetup::MSG_FAILED) ;
			}
		}
	}
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Platform
	 * @return	void
	 */
	public function ClearPlatformResource(W3B_Platform $aPlatform)
	{
		// 清除分配给扩展的注册表
		// -----------------------------------------------------------------------------
		$sPreferencePath = "/Extensions/{$this->sExtName}" ;
		$aPlatformPreference = $aPlatform->GetPreference() ;
		if( $aPlatformPreference->HasKey($sPreferencePath) )
		{
			$aPlatformPreference->DeleteKey($sPreferencePath)?
				new JCAT_Message(JCAT_Language::SentenceEx('删除了扩展 %s 的注册表数据。','W3B_Extensions',null,$this->sExtName),W3B_IExtensionSetup::MSG_SUCCEED) :
				new JCAT_Message(JCAT_Language::SentenceEx('删除扩展 %s 的注册表数据时遇到错误。','W3B_Extensions',null,$this->sExtName),W3B_IExtensionSetup::MSG_FAILED) ;
		}
		
		// 清除分配给扩展的用户资源目录
		// -----------------------------------------------------------------------------
		$sRCFolder = W3B_DATA_ROOT."Extensions/{$this->sExtName}/" ;
		if( is_dir($sRCFolder) )
		{
			JCAT_FSO::DeleteDir($sRCFolder,true) ?
				new JCAT_Message(JCAT_Language::SentenceEx('清除了曾经分配给扩展 %s 的资源。','W3B_Extensions',null,$this->sExtName),W3B_IExtensionSetup::MSG_SUCCEED) :		
				new JCAT_Message(JCAT_Language::SentenceEx('没有完全清除分配给扩展 %s 的资源（有些文件删除失败）。','W3B_Extensions',null,$this->sExtName),W3B_IExtensionSetup::MSG_FAILED) ;
		}		
			
		
		// 删除数据表
		// -----------------------------------------------------------------------------
		$arrTables = $this->GetResourceDBTables() ;
		if( is_array($arrTables) and !empty($arrTables) )
		{
			$arrTables = array_keys($arrTables) ;
	
			$aDB = $aPlatform->GetDefaultDB() ;
			foreach ($arrTables as $sTable)
			{
				if($aDB->Query("DROP TABLE {$sTable}"))
				{
					new JCAT_Message(JCAT_Language::SentenceEx('删除数据表 %s','W3B_Platform',null,$sTable),W3B_IExtensionSetup::MSG_SUCCEED) ;
				}
				
				else
				{
					new JCAT_Message(JCAT_Language::SentenceEx('删除数据表 %s 失败。','W3B_Platform',null,$sTable),W3B_IExtensionSetup::MSG_FAILED) ;
				}
			}
		
		}
	}
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Service
	 * @return	void
	 */
	public function ClearServiceResource(W3B_Service $aService)
	{$aService ;
		return true ;	
	}
	
	
	
	// 交互  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 返回是否需要交互式安装
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsInteractiveSetup()
	{
		return false ;
	}
	
	/**
	 * 返回是否需要交互式卸载
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsInteractiveUnsetup()
	{
		return false ;
	}
	
	
	
	// 资源 ////
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetResourceDBTables()
	{
		return null ;
	}
	
	

	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ClearSrvRCBySrvId(W3B_Service $aService)
	{
		$aPlatform = $aService->GetPlatform() ;
		$aDB = $aPlatform->GetDefaultDB() ;
		$nSrvId = $aService->GetServiceId() ;
		
		// 创建数据表 Ext_JCUser 中的记录
		$arrTables = array_keys($this->GetResourceDBTables()) ;
		foreach ($arrTables as $sTable)
		{
			if( $aDB->Query("Delete FROM {$sTable} where nServiceId={$nSrvId} ;") )
			{
				$nAffectedRows = $aDB->GetConnect()->GetAffectedRows() ;
				new JCAT_Message(JCAT_Language::SentenceEx('删除数据表 %s %s项用户记录','W3B_Platform',null,$sTable,$nAffectedRows),W3B_IExtensionSetup::MSG_EXECUTED) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('删除数据表 %s 中的用户记录失败。','W3B_Platform',null,$sTable),W3B_IExtensionSetup::MSG_FAILED) ;
			}
		}
	}
	
	// 属性 /////////////////////////////////////////
	
	private $sExtName ;
	private $aExtVersion ;
}

?>
