<?php 

abstract class W3B_ExtensionRCUpgrade extends W3B_Controller
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	abstract public function GetExtentionName() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	abstract public function GetVersionFrom() ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	abstract public function GetVersionTo() ;
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$Parameter
	 * @return	void
	 */
	protected function CheckPlatformRCVersion()
	{
		$aPlatform = $this->GetPlatform() ;
		
		$aPlatformVersion = JCAT_Version::FromString( $aPlatform->GetExtensionRCVersion($this->GetExtentionName()) ) ;
		$aVerFrom = $this->GetVersionFrom() ;
		$aVerTo = $this->GetVersionTo() ;
		
		if( $aPlatformVersion->Compare($aVerFrom)!=0 )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'在升级时遇到了意外，当前平台中的资源版本为：%s，升级程序被设计为从 %s 升级到 %s', 'Ext_JCUser', null
				, $aPlatformVersion, $aVerFrom, $aVerTo
			)) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function UpdatePlatformRCVersion(JCAT_Version $aRCVer=null)
	{
		if(!$aRCVer)
		{
			$aRCVer = $this->GetVersionTo() ;
		}
		$aPlatform = $this->GetPlatform() ;
				
		// 更改资源版本
		$aPreferenceKey = $aPlatform->GetPreference()->GetKey('/Extensions') ;
		$arrExts = $aPreferenceKey->GetItem(W3B_Platform::ITEM_INSTALLED_EXTS) ;
		$arrExts['Ext_JCUser']['sRCVersion'] = $aRCVer->toString(false) ;
		$arrExts = $aPreferenceKey->SetItem(W3B_Platform::ITEM_INSTALLED_EXTS,$arrExts) ;
		$aPreferenceKey->Save() ;
		
		new JCAT_Message(JCAT_Language::SentenceEx('扩展 %s 资源升级到了版本：%s','Ext_JCUser',null
				, $this->GetExtentionName(), $aRCVer ),W3B_IExtensionSetup::MSG_SUCCEED) ;
	}
}


?>