<?
/*-- Project Introduce --*/


/**
 * 升级路径计算
 *
 * @author		alee
 * @access		public
 */
class W3B_ExtensionRCUpgradePathWeb
{		
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddUpgrader(JCAT_Version $aFrom,JCAT_Version $aTo,$sClassName,$sClassPath)
	{
		$aUpgrader = new W3B_ExtensionRCUpgradeLink($aFrom,$aTo,$sClassName,$sClassPath) ;
		$aUpgrader->SetTargetPoint($this->GetVersionPoint($aTo));
		
		$aPoint = $this->GetVersionPoint($aFrom) ;
		$aPoint->AddUpgrader($aUpgrader) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aVersion	JCAT_Version
	 * @return	W3B_ExtensionRCUpgradePoint
	 */
	public function GetVersionPoint(JCAT_Version $aVersion)
	{
		$a32InrVersion = $aVersion->Get32Integer() ;
		
		if( !isset($this->arrPoints[$a32InrVersion]) )
		{
			$this->arrPoints[$a32InrVersion] = new W3B_ExtensionRCUpgradePoint($aVersion) ;
		}
		
		return $this->arrPoints[$a32InrVersion] ;
	}
	
	/**
	 * 在所有升级补丁中，找到最优的升级路径
	 *
	 * @access	public
	 * @return	W3B_ExtensionRCUpgradePath
	 */
	public function FindUpgradePath(JCAT_Version $aBegin,JCAT_Version $aEnd)
	{
		$aTargetPath = new W3B_ExtensionRCUpgradePath($aBegin,$aEnd) ;
		
		// 找到所有 有效的升级路径
		$arrValidPaths = array() ;
		foreach($this->arrPoints as $aPoint)
		{
			$arrValidPaths = array_merge($arrValidPaths,$aPoint->BuildUpgradePath($aTargetPath)) ;
		}
		
		if(empty($arrValidPaths))
		{
			return null ;
		}

		// 找到最短的升级路径
		$arrPathPatchs = array() ;
		foreach($arrValidPaths as $nIdx=>$aUpgradePath)
		{
			$arrPathPatchs[$nIdx] = $aUpgradePath->GetPatchCount() ;
		}
		asort($arrPathPatchs) ;
		reset($arrPathPatchs) ;
		$nIdx = key($arrPathPatchs) ;
		
		return $arrValidPaths[$nIdx] ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrPoints = array() ;
}


/**
 * 描述升级路径上的一个版本节点
 * 该对象主要用于在 升级路径网络中，维护每一个版本点上 相关的补丁（那些可以从此本版升级到其他版本的补丁）
 *
 */
class W3B_ExtensionRCUpgradePoint
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$n32IntVersion	int
	 * @return	void
	 */
	public function W3B_ExtensionRCUpgradePoint(JCAT_Version $aVersion)
	{
		$this->SetVersion($aVersion) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aPath		W3B_ExtensionRCUpgradePath
	 * @return	array
	 */
	public function BuildUpgradePath(W3B_ExtensionRCUpgradePath $aPath)
	{
		if( $aPath->GetCurrentVersion(false)->Compare($this->GetVersion(false)) != 0 )
		{
			return array() ;
		}
		
		$arrValidPath = array() ;
		foreach ($this->arrUpgrader as $aUpgrader)
		{
			// 有效的升级
			if( $aPath->AddLink($aUpgrader,true) )
			{
				// 分叉出一条新的路径
				$aNewPath = clone $aPath ;
				
				// 路径向前推进
				$aNewPath->AddLink($aUpgrader,false) ;
				
				
				// 完成
				if($aNewPath->IsComplete())
				{
					$arrValidPath[] = $aNewPath ;
				}
				
				// 继续向前
				else 
				{
					// 下一个版本
					$aNextVersion = $aUpgrader->GetTargetPoint() ;
					JCAT_ASSERT::ASSERT_INSTANCE($aNextVersion,'W3B_ExtensionRCUpgradePoint') ;
					
					// 递归继续
					$arrValidPath = array_merge($arrValidPath,$aNextVersion->BuildUpgradePath($aNewPath)) ;
				}
			}
		}
		
		return $arrValidPath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreatePatchIterator()
	{
		return new JCAT_ArrayIterator($this->arrUpgrader) ;
	}
	
	/**
	 * 设置对象属性 self::$n32IntVersion
	 *
	 * @access	public
	 * @param	$aVersion		JCAT_Version	PropertyDescription
	 * @return	void
	 */
	public function SetVersion(JCAT_Version $aVersion)
	{
		$this->aVersion = $aVersion ;
	}
	
	/**
	 * 取得对象属性 self::$n32IntVersion
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetVersion($b32Int=true)
	{
		return $b32Int? $this->aVersion->Get32Integer(): $this->aVersion ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddUpgrader(W3B_ExtensionRCUpgradeLink $aUpgrader)
	{
		if($aUpgrader->GetFromVersion()!=$this->GetVersion())
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'升级程序(%s-%s)无法用于此版本(%s)'
				, 'W3B_Extensions', null
				, $aUpgrader->GetFromVersion(false), $aUpgrader->GetToVersion(false), $this->GetVersion(false)
			)) ;
		}
		
		$this->arrUpgrader[] = $aUpgrader ;
	}
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aVersion ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrUpgrader = array() ;
	
}

/**
 * 描述升级路径上 两个版本节点之间的连接，
 * 即通过一个升级补丁来实现从一个版本升级到更高的版本
 *
 */
class W3B_ExtensionRCUpgradeLink
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function W3B_ExtensionRCUpgradeLink(JCAT_Version $aFrom,JCAT_Version $aTo,$sClassName,$sClassPath)
	{
		if($aFrom->Get32Integer()>=$aTo->Get32Integer())
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'遇到无效的升级程序：%s-%s'
				, 'W3B_Extensions', null, $aFrom, $aTo
			)) ;
		}
		
		$this->aFromVersion = $aFrom ;
		$this->aToVersion = $aTo ;
		$this->aClassName = $sClassName ;
		$this->sClassPath = $sClassPath ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetFromVersion($b32Int=true)
	{
		return $b32Int? $this->aFromVersion->Get32Integer(): $this->aFromVersion ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetToVersion($b32Int=true)
	{
		return $b32Int? $this->aToVersion->Get32Integer(): $this->aToVersion ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aVersionPoint	W3B_ExtensionRCUpgradePoint
	 * @return	void
	 */
	public function SetTargetPoint(W3B_ExtensionRCUpgradePoint $aVersionPoint)
	{
		if( $this->aToVersion->Compare($aVersionPoint->GetVersion(false))!=0 )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无效的目标版本：(%s for %s-%s)'
				, 'W3B_Extensions', null
				, $aVersionPoint, $this->GetFromVersion(false), $this->GetToVersion(false) 
			)) ;
		}
		
		$this->aTargetPoint = $aVersionPoint ;
	}
	
	/**
	 * 取得对象属性 self::$aTargetPoint
	 *
	 * @access	public
	 * @return	W3B_ExtensionRCUpgradePoint
	 */
	public function GetTargetPoint()
	{
		return $this->aTargetPoint ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassName()
	{
		return $this->aClassName ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetClassPath()
	{
		return $this->sClassPath ;
	}
	
	/**
	 * 对象属性 PropertyDescription
	 * 
	 * @access	private
	 * @var		W3B_ExtensionRCUpgradePoint
	 */
	private $aTargetPoint ;
}

/**
 * 描述一个可行的升级路径
 * 即 指定的两个版本 之间可以通过一组补丁实现升级
 *
 */
class W3B_ExtensionRCUpgradePath
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function W3B_ExtensionRCUpgradePath(JCAT_Version $aBegin,JCAT_Version $aEnd)
	{
		$this->aBegin = clone $aBegin ;
		$this->aEnd = clone $aEnd ;
		$this->aCurrent = $this->aBegin ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aLink	W3B_ExtensionRCUpgradeLink
	 * @return	bool
	 */
	public function AddLink(W3B_ExtensionRCUpgradeLink $aLink,$bTest=false)
	{
		if( $this->aCurrent->Get32Integer() != $aLink->GetFromVersion(true) )
		{
			return false ; 
		}
		
		if( $this->aEnd->Get32Integer() < $aLink->GetToVersion(true) )
		{
			return false ; 
		}
		
		if(!$bTest)
		{
			$this->arrLinks[] = $aLink ;
			$this->aCurrent = clone $aLink->GetToVersion(false) ;
		}
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetCurrentVersion($b32Int=true)
	{
		return $b32Int? $this->aCurrent->Get32Integer(): $this->aCurrent ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsComplete()
	{
		return $this->aEnd->Compare($this->aCurrent)==0 ;
	}
	
	/**
	 * 返回该路径所使用的 补丁数
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPatchCount()
	{
		return count($this->arrLinks) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreatePatchIterator()
	{
		return new JCAT_ArrayIterator($this->arrLinks) ;
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aBegin ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aCurrent ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aEnd ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrLinks ;
}

?>