<?
/*-- Project Introduce --*/


/**
 * 安装一个扩展包
 * 前置条件：安装包路径
 * 这个类不会积累状态，可以重复使用
 *
 * @author		alee
 * @access		public
 */
class W3B_SetupExtension extends W3B_Controller 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	bool
	 */
	static public function SetupExtension($sExtName,$sExtVersion)
	{
		$aRequest = new JCAT_Request(JCAT_Request::TYPE_CUS) ;
		$aRequest->SetParam('sExtName',$sExtName);
		$aRequest->SetParam('sExtVersion',$sExtVersion);
		
		$aSetupExtension = W3B_Controller::CreateController('W3B_SetupExtension',W3B_Service::GetCurrentService()) ;
		$aSetupExtension->SetRequest($aRequest) ;
		return $aSetupExtension->MainRun() ;
	}
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_SetupExtension(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function MainRun()
	{
		$aPlatform = $this->GetPlatform() ;
		$aRequest = $this->GetRequest() ;
		$sExtName = $aRequest->GetParam('sExtName') ;
		$sExtVersion = $aRequest->GetParam('sExtVersion') ;
		
		// 检查前置条件:扩展包是否存在，是否可以读取
		if(!$aExtInfo=$this->CheckPrecondition_LoadExtensionInfo($sExtName,$sExtVersion))
		{
			return false ;
		}
		
		// 检查是否已经安装和依赖项
		if( !$this->CheckInstallable($aExtInfo,$aPlatform) )
		{
			return false ;
		}
		
		// 触发事件: 安装扩展之前
		$aEventDispatcher = $aPlatform->GetEventDispatcher() ;
		$aEventDispatcher->Emit(W3B_Platform::EVENT_BEFORE_SETUP_EXT,array($aExtInfo,$aPlatform),W3B_Platform::EVENT_NAMESPACE) ;
		
		// 安装扩展程序
		if( !$this->Setup($aExtInfo) )
		{
			return false ;
		}
		
		// 注册到平台
		$this->RegisterToPlatform($aExtInfo) ;
		
		// 触发事件: 安装扩展之后
		$aEventDispatcher->Emit(W3B_Platform::EVENT_AFTER_SETUP_EXT,array($aExtInfo,$aPlatform),W3B_Platform::EVENT_NAMESPACE) ;
		
		// 消息
		new JCAT_Message(JCAT_Language::SentenceEx('扩展 %s 已经安装','W3B_Extensions',null,$aExtInfo->GetName()),W3B_IExtensionSetup::MSG_SUCCEED) ;
		
		return true ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	W3B_IExtensionInfo
	 */
	private function CheckPrecondition_LoadExtensionInfo($sExtName,$sExtVersion)
	{
		if(!$sExtName)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sExtName','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
			return null ;
		}
		if(!$sExtVersion)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sExtVersion','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
			return null ;
		}
		
		try {
			$aExtInfo = W3B_ExtensionInfo::GetInstance($sExtName,$sExtVersion) ;
		} 
		catch (Exception $e)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法读取指定安装扩展(%s:%s)的 ExtInfo.xml 文件; %s','W3B_Extensions',null,$sExtName,$sExtVersion,$e->getMessage()),W3B_IExtensionSetup::MSG_FAILED) ;
			return null ;
		}
		
		return $aExtInfo ;
	}
	

	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aExtInfo	W3B_ExtensionInfo
	 * @param	$aPlatform	W3B_Platform
	 * @return	bool
	 */
	private function CheckInstallable(W3B_ExtensionInfo $aExtInfo,W3B_Platform $aPlatform)
	{
		$aExtMgr = $aPlatform->GetExtensionManager() ;
		
		// 检查是否安装
		$aExtTree = $aExtMgr->GetExtensionDependenceTree() ;
		$aExtDependItem = $aExtTree->GetDependenceItem($aExtInfo->GetName()) ;
		if( $aExtDependItem and $aExtDependItem->GetItemVersion()->Compare($aExtInfo->GetVersion())==0 )
		{
			new JCAT_Message(
					JCAT_Language::SentenceEx('扩展：%s(%s) 已经安装，无法重复安装同一个扩展的相同版本。','W3B_Extensions'
					, null, $aExtInfo->GetName(), $aExtInfo->GetVersion()), MSGMVC_OK ) ;
			return false ;
		}
		
		// 检查依赖
		try{
			$aExtMgr->CheckExtensionDependencies($aExtInfo) ;
		}
		catch (W3B_DependenceException $e)
		{
			new JCAT_Message($e->GetMsg(),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		return true ;
	}

	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aExtInfo	W3B_IExtensionInfo
	 * @return	void
	 */
	private function Setup(W3B_IExtensionInfo $aExtInfo)
	{
		$aPlatform = $this->GetPlatform() ;
		$aInstaller = $aExtInfo->CreateInstaller() ;		
		if( !JCAT_Global::HasImplementedTo($aInstaller,'W3B_IExtensionSetup') )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('安装扩展时遇到错误，扩展(%s) 必须提供一个符合接口 W3B_IExtensionSetup 的对象。','W3B_Extensions',null,$aExtInfo->GetName())
						, W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		//  平台中已经存在扩展资源，升级资源
		$sOldRCVersion = $aPlatform->GetExtensionRCVersion($aExtInfo->GetName()) ;
		if( $sOldRCVersion )
		{
			if( !JCAT_Version::VerifyFormat($sOldRCVersion) )
			{
				new JCAT_Message( JCAT_Language::SentenceEx('无法安装扩展：%s， 平台中存在该扩展无法识别的资源版本号：%s'
						,'W3B_Extensions',null,$aExtInfo->GetName(),$sOldRCVersion), W3B_IExtensionSetup::MSG_FAILED ) ;
				return false ;
			}
			
			$aRequireRCVersion = $aExtInfo->GetRCVersion() ;
			$aOldRCVersion = JCAT_Version::FromString($sOldRCVersion) ;
			
			$nCompareResult = $aRequireRCVersion->Compare($aOldRCVersion) ;
			if($nCompareResult>0)
			{
				$aIterator = $aExtInfo->CreateRCUpgraderIterator($aOldRCVersion) ;
				if(!$aIterator)
				{
					new JCAT_Message( JCAT_Language::SentenceEx('系统中保留的扩展资源版本为：%s，正要安装的扩展资源版本为：%s;找不到合适的 资源升级程序，无法将系统中保留的扩展资源升级到当前版本。'
							,'W3B_Extensions',null,$aOldRCVersion,$aRequireRCVersion), W3B_IExtensionSetup::MSG_FAILED ) ;
					return false ;
				}
				
				else 
				{
					// 依次执行所有资源升级补丁
					for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
					{
						$aUpgrade = $aIterator->Current() ;
						if( !JCAT_Global::IsKindOf($aUpgrade,'W3B_ExtensionRCUpgrade') )
						{
							new JCAT_Message( JCAT_Language::SentenceEx('扩展的资源升级程序必须为类型： W3B_ExtensionRCUpgrade 。'
									,'W3B_Extensions',null), W3B_IExtensionSetup::MSG_FAILED ) ;
							return false ;
						}
						
						// 执行
						$aUpgrade->MainRun() ;
					}
				}
			}
		
			else if( $nCompareResult<0 )
			{
				new JCAT_Message( JCAT_Language::SentenceEx('升级扩展时遇到了意外。正在安装的扩展所要求的版本号为：%s，平台上已有的资源版本号为：%s，无法提供反向升级程序'
						,'W3B_Extensions',null,$aRequireRCVersion,$aOldRCVersion), W3B_IExtensionSetup::MSG_FAILED ) ;
				return false ;
			}
		}
		
		//  平台中不存在扩展资源，初始化资源
		else 
		{
			$aInstaller->InitializeResource($aPlatform) ;
		}
		
		
		// 执行扩展的安装程序
		$aInstaller->Setup($aPlatform) ;
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aExtInfo	W3B_IExtensionInfo
	 * @return	void
	 */
	private function RegisterToPlatform(W3B_IExtensionInfo $aExtInfo)
	{
		$aPlatform = $this->GetPlatform() ;
		
		// 将 扩展添加到平台中
		// ---------------------------------------------------
		$aPreference = $aPlatform->GetPreference() ;
		$aExtensionKey = $aPreference->GetKey('/Extensions') ;
		
		// 取得清单
		$arrInstalledExt =& $aExtensionKey->GetItem(W3B_Platform::ITEM_INSTALLED_EXTS) ;
		
		// 添加到清单
		$sName = $aExtInfo->GetName() ;
		$sVersion = $aExtInfo->GetVersion()->toString() ;
		$arrInstalledExt[$sName] = array(
			'sName' => $sName ,
			'sVersion' => $sVersion ,
			'sRCVersion' => $aExtInfo->GetRCVersion()->toString() ,
		) ;
		
		// 保存清单
		$aExtensionKey->SetItem(W3B_Platform::ITEM_INSTALLED_EXTS,$arrInstalledExt) ;
		$aExtensionKey->Save() ;
		
		// 添加到平台的 扩展管理器
		$aExtMgr = $aPlatform->GetExtensionManager() ;
		$aExtMgr->AppendExtensionByName($sName,$sVersion) ;
	}
	

}

?>