<?
/*-- Project Introduce --*/


/**
 * 安装一个扩展包
 * 前置条件：安装包路径
 * 这个类不会积累状态，可以重复使用
 *
 * @author		alee
 * @access		public
 */
class W3B_SetupExtensionPackage extends W3B_SetupExtension 
{
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_SetupExtensionPackage(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->W3B_SetupExtension($aParent) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function MainRun()
	{
		$aPlatform = $this->GetPlatform() ;
		$aRequest = $this->GetRequest() ;
		$sExtPackage = $aRequest->GetParam('sExtPackage') ;
		
		// 检查前置条件:扩展包是否存在，是否可以读取
		if(!$this->CheckPrecondition_ExtPackage($sExtPackage))
		{
			return false ;
		}
		
		// 读取 Ext Info
		$aExtInfo = $this->ReadPackage($sExtPackage) ;
		if(!$aExtInfo)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('上传的扩展包无效。','W3B_Extensions',null), W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		// 检查是否存在
		$sExtName = $aExtInfo->GetName() ;
		$aExtVersion = $aExtInfo->GetVersion() ;
		if( $aPlatform->IsExtensionExists($sExtName,$aExtVersion) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('扩展已经存在，无法重复安装(%s:%s)','W3B_Extensions',null,$sExtName,$aExtVersion)
					, W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
				
		// 解压文件
		if( !$this->UnpackExtension($sExtPackage,$aExtInfo,$aPlatform) )
		{
			return false ;
		}
		
		// 设置参数
		$aRequest->SetParam( 'sExtName', $aExtInfo->GetName() ) ;
		$aRequest->SetParam( 'sExtVersion', $aExtInfo->GetVersion()->toString() ) ;
	
		// 安装失败，回滚操作
		if( !parent::MainRun() )
		{
			$this->RollBack($aPlatform,$aExtInfo) ;
			
			return false ;
		}
		
		else
		{
			return true ;
		}
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	bool
	 */
	private function CheckPrecondition_ExtPackage($sExtPackage)
	{
		if(!$sExtPackage)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sExtPackage','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}

		if(!is_readable($sExtPackage))
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法读取扩展包，路径无效：%s','W3B_Extensions',null,$sExtPackage),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$sPackagePath
	 * @return	W3B_ExtensionInfo
	 */
	private function ReadPackage($sPackagePath)
	{
		$sExtInfo = @file_get_contents("zip://{$sPackagePath}#ExtInfo.xml") ;
		if( !$sExtInfo )
		{
			return null ;
		}
		return W3B_ExtensionInfo::CreateFromXml(&$sExtInfo) ;
	}

	/**
	 * 解压扩展包
	 *
	 * @access	private
	 * @param	$aExtPkg	W3B_ExtensionPackage
	 * @param	$aExtInfo	W3B_ExtensionInfo
	 * @param	$aPlatform	W3B_Platform
	 * @return	bool
	 */
	private function UnpackExtension($sExtPackage,W3B_ExtensionInfo $aExtInfo,W3B_Platform $aPlatform)
	{
		$sExtDir = $aPlatform->GetExtensionPath($aExtInfo->GetName(),$aExtInfo->GetVersion()) ;
		if(!file_exists($sExtDir))
		{
			mkdir($sExtDir,0777,true) ;
			chmod($sExtDir,0777) ;
		}
		
		$aZip = new ZipArchive;
		if ($aZip->open($sExtPackage)===TRUE)
		{
			if( !$aZip->extractTo($sExtDir) )
			{
				
				new JCAT_Message(JCAT_Language::SentenceEx('从压缩包里面提取文件时遇到错误，扩展包可能已经损坏。','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
				
				// 清除已经解压的文件
				if( JCAT_FSO::DeleteDir($sExtDir,true) )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('回滚操作：部分已经提取的文件已经清除。','W3B_Extensions',null),W3B_IExtensionSetup::MSG_EXECUTED) ;
				}
				
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('回滚操作也遇到错误：部分已经提取的文件没有完全清除。','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
				}
				
				$aZip->close();
				return false ;
			}
			
			else 
			{
				$aZip->close();
				return true ;
			}
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法读取扩展包：%s','W3B_Extensions',null,$sExtPackage),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function RollBack(W3B_Platform $aPlatform,W3B_ExtensionInfo $aExtInfo)
	{
		$sExtDir = $aPlatform->GetExtensionPath($aExtInfo->GetName(),$aExtInfo->GetVersion()) ;
		JCAT_FSO::DeleteDir($sExtDir,true) ;
	}
	
}

?>