<?
/*-- Project Introduce --*/


/**
 * 安装一个扩展包
 * 前置条件：安装包路径
 * 这个类不会积累状态，可以重复使用
 *
 * @author		alee
 * @access		public
 */
class W3B_UnsetupExtension extends W3B_Controller 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sExtName			string
	 * @param	$bComplete=false	bool
	 * @param	$aPlatform=false	W3B_Platform
	 * @static
	 * @return	bool
	 */
	static public function UnsetupExtension($sExtName,$bComplete=false,W3B_Platform $aPlatform=null)
	{
		if(!$aPlatform)
		{
			$aPlatform = W3B_Platform::GetGlobalInstance() ;
		}
		
		$aUnsetup = new W3B_UnsetupExtension() ;
		$aUnsetup->SetPlatform($aPlatform) ;
		
		$aRequest = new JCAT_Request(JCAT_Request::TYPE_CUS) ;
		$aRequest->SetParam('sExtName',$sExtName) ;
		$aRequest->SetParam('bComplete',$bComplete) ;
		$aUnsetup->SetRequest($aRequest) ;
		
		return $aUnsetup->MainRun() ;
	}
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_UnsetupExtension(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function MainRun()
	{
		$aPlatform = $this->GetPlatform() ;
		$aRequest = $this->GetRequest() ;
		$sExtName = $aRequest->GetParam('sExtName') ;
		
		// 检查前置条件
		if(!$this->CheckPrecondition($sExtName,$aPlatform))
		{
			return false ;
		}
		
		// 读取 Ext Info
		if( !$aExtInfo = $this->ReadExtensionInfo($sExtName,$aPlatform) )
		{
			return false ;
		}
		
		// 触发事件: 安装扩展之前
		$aEventDispatcher = $aPlatform->GetEventDispatcher() ;
		$aEventDispatcher->Emit(W3B_Platform::EVENT_BEFORE_UNSETUP_EXT,array($aExtInfo,$aPlatform),W3B_Platform::EVENT_NAMESPACE) ;
		
		
		// 创建 扩展卸载对象
		$aSetup = $aExtInfo->CreateInstaller() ;
		$aPlatformPreference = $aPlatform->GetPreference() ;
		$arrInstalledLst =& $aPlatformPreference->GetItem('/Extensions',W3B_Platform::ITEM_INSTALLED_EXTS) ;
		
		// 完全卸载（扩展资源）
		// ---------------------------------------------------------
		$bComplete = (bool)$aRequest->GetParam('bComplete') ;
		if( $bComplete )
		{
			// 清除平台资源（调用扩展过程）
			$aSetup->ClearPlatformResource($aPlatform) ;
			
			// 在 平台注册表 中设置状态
			unset($arrInstalledLst[$sExtName]) ;
		}
		
		
		// 保留资源
		// ---------------------------------------------------------
		else 
		{
			// 仅保留平台注册表该扩展的 资源版本
			$arrInstalledLst[$sExtName] = array(
				'sRCVersion' => $arrInstalledLst[$sExtName]['sRCVersion']
			) ;
		}

		// 调用扩展的卸载程序
		$aSetup->Unsetup($aPlatform,$bComplete) ;
		
		// 删除扩展文件
		$sExtFolder = $aPlatform->GetExtensionPath($sExtName,$aExtInfo->GetVersion()) ;
		JCAT_FSO::DeleteDir($sExtFolder,true) ;	
		
		// 保存注册表
		$aPlatformPreference->SetItem('/Extensions',W3B_Platform::ITEM_INSTALLED_EXTS,$arrInstalledLst) ;
		$aPlatformPreference->GetKey('/Extensions')->Save() ;
		
		// 从平台的 扩展管理器中移出
		$aExtDependTree = $aPlatform->GetExtensionManager()->GetExtensionDependenceTree() ;
		$aExtDependTree->RemoveItem($sExtName) ;
		
		// 触发事件
		$aEventDispatcher->Emit(W3B_Platform::EVENT_AFTER_UNSETUP_EXT,array($aExtInfo,$aPlatform),W3B_Platform::EVENT_NAMESPACE) ;
		
		// 消息
		new JCAT_Message(JCAT_Language::SentenceEx('扩展 %s 已经卸载','W3B_Extensions',null,$sExtName),W3B_IExtensionSetup::MSG_SUCCEED) ;
		
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	bool
	 */
	private function CheckPrecondition($sExtName,W3B_Platform $aPlatform)
	{		
		// 检查参数
		if(!$sExtName)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('没有指定要卸载的扩展(缺少参数：sExtName)','W3B_Extensions',null),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		$aExtensionMgr = $aPlatform->GetExtensionManager() ;
		$aExtensionTree = $aExtensionMgr->GetExtensionDependenceTree() ;
		
		// 是否存在扩展
		$aExtensionDependItem = $aExtensionTree->GetDependenceItem($sExtName) ;
		if(!$aExtensionDependItem)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('系统中没有安装指定卸载的扩展：%s','W3B_Extensions',null,$sExtName),W3B_IExtensionSetup::MSG_FAILED) ;
			return false ;
		}
		
		// 是否有其他扩展依赖此扩展
		$aIterator = $aExtensionDependItem->CreateDependenceIterator(true) ;
		if( $aIterator ) 
		{
			$arrExtNames = array() ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$aItem = $aIterator->Current() ;
				$arrExtNames[] = $aItem->GetItemName() ;
			}
			
			if(count($arrExtNames))
			{
				$sExtLst = implode(', ',$arrExtNames) ;
				new JCAT_Message( JCAT_Language::SentenceEx(
						'无法卸载扩展：%s，该扩展被以下扩展依赖：%s'
						,'W3B_Extensions',null
						, $sExtName, $sExtLst), W3B_IExtensionSetup::MSG_FAILED ) ;
				return false ;
			}
		}
		
		return true ;
	}
	


	/**
	 * Description
	 *
	 * @access	private
	 * @param	$sExtName
	 * @param	$aPlatform		W3B_Platform
	 * @return	W3B_IExtensionInfo
	 */
	private function ReadExtensionInfo($sExtName,W3B_Platform $aPlatform)
	{
		$sExtVersion = $aPlatform->GetExtensionVersion($sExtName) ;
		try {
			$aExtInfo = W3B_ExtensionInfo::GetInstance($sExtName,$sExtVersion) ;
		} catch (Exception $e){
			new JCAT_Message(JCAT_Language::SentenceEx('扩展包无效，可能已经损坏。%s','W3B_Extensions',null,$e->getMessage()),MSGMVC_BAD) ;
			return null ;
		}
		
		return $aExtInfo ;
	}

}

?>