<?php

interface W3B_IExtensionSetup
{
	const MSG_EXECUTED = 'MSG_EXECUTED' ;
	const MSG_SUCCEED = 'MSG_SUCCEED' ;
	const MSG_FAILED = 'MSG_FAILED' ;
	
	
	// 平台  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 安装扩展
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Setup(W3B_Platform $aPlatform) ;
	
	/**
	 * 卸载扩展
	 *
	 * @access	public
	 * @return	bool
	 */
	public function Unsetup(W3B_Platform $aPlatform,$bCompletely=false) ;
	
	
	
	
	
	// 服务 //////////////////////////////////////////////////////////////////////
	
	/**
	 * 在一个服务中启用扩展
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function Enable(W3B_Service $aService) ;
	
	/**
	 * 在一个服务中禁用扩展
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function Disable(W3B_Service $aService) ;
	
	/**
	 * 终止服务，回收扩展为服务提供的资源
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @return	bool
	 */
	public function TerminateService(W3B_Service $aService) ;
	
	
	
	
	// 资源  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 初始化平台资源（全新安装时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Platform
	 * @return	void
	 */
	public function InitializeResource(W3B_Platform $aPlatform) ;
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Platform
	 * @return	void
	 */
	public function ClearPlatformResource(W3B_Platform $aPlatform) ;
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Service
	 * @return	void
	 */
	public function ClearServiceResource(W3B_Service $aService) ;
	
	
	
	
	
	
	// 交互  /////////////////////////////////////////////////////////////////////
	
	/**
	 * 返回是否需要交互式安装
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsInteractiveSetup() ;
	
	/**
	 * 返回是否需要交互式卸载
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsInteractiveUnsetup() ;
	
}


JCAT_MessageHTMLPrinter::RegisterMessageStyle(W3B_IExtensionSetup::MSG_EXECUTED
		, JCAT_MessageHTMLPrinter::QueryMessageStyle(MSGMVC)) ;
JCAT_MessageHTMLPrinter::RegisterMessageStyle(W3B_IExtensionSetup::MSG_FAILED
		, JCAT_MessageHTMLPrinter::QueryMessageStyle(MSGMVC_BAD)) ;
JCAT_MessageHTMLPrinter::RegisterMessageStyle(W3B_IExtensionSetup::MSG_SUCCEED
		, JCAT_MessageHTMLPrinter::QueryMessageStyle(MSGMVC_OK)) ;


?>
