<?php


abstract class W3B_Extension implements W3B_IExtension
{
	/**
	 * 构造函数：根据扩展名称 为扩展创建一个享员对象 
	 *
	 * @access	public
	 * @param	$sExtensionName			string
	 * @param	$sExtensionVersion=null		string			扩展版本，null 表示当前安装版本
	 * @param	$aService=null				W3B_Service	载入该扩展的服务，null表示当前服务
	 * @static
	 * @return	W3B_IExtension
	 */	
	static public function GetExtensionInstance($sExtensionName,$sExtensionVersion=null,W3B_Service $aService=null)
	{
		//  缺省服务
		if( $aService===null )
		{
			$aService = W3B_Service::GetCurrentService() ;
		}
		
		// 缺省版本
		if($sExtensionVersion===null)
		{
			JCAT_ASSERT::ASSERT_( isset(self::$arrLoadedExtensions[$sExtensionName])
					, JCAT_Language::SentenceEx('扩展尚未安装，$sExtensionVersion 缺省值 null 表示当前安装的版本，仅在安装此扩展的前提下可用。','W3B_Extensions',null,$sExtensionName) )  ;
			
			return self::$arrLoadedExtensions[$sExtensionName] ;
		}
		
		else 
		{
			if( !isset(self::$arrLoadedExtensions[$sExtensionName]) )
			{	
				// 载入扩展的类文件
				$sExtensionNamePath = W3B_Extension_ROOT."{$sExtensionName}/{$sExtensionVersion}/Classes/class.{$sExtensionName}.php" ;
				JCAT_ASSERT::ASSERT_FILE($sExtensionNamePath,JCAT_Language::SentenceEx('扩展 %s 缺少类文件: %s','W3B_Extensions',null,$sExtensionName,$sExtensionNamePath))  ;
				
				include_once $sExtensionNamePath ;
				JCAT_ASSERT::ASSERT_( JCAT_Package::ClassExists($sExtensionName),  JCAT_Language::SentenceEx('扩展 %s 缺少类','W3B_Extensions',null,$sExtensionName) ) ;
	
				// 创建扩展对象
				self::$arrLoadedExtensions[$sExtensionName] = new $sExtensionName($aService) ;
				
				// 载入扩展信息
				$aExtInfo = W3B_ExtensionInfo::GetInstance($sExtensionName,$sExtensionVersion) ;			
				self::$arrLoadedExtensions[$sExtensionName]->SetExtensionInfo($aExtInfo) ;
			}
	
			// 返回扩展对象
			return self::$arrLoadedExtensions[$sExtensionName] ;
		}
	}
	
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$aService					W3B_Service			当前服务
	 * @return	void
	 */
	public function __construct(W3B_Service $aService)
	{
		$this->aService = $aService ;
	}

	/**
	 * 设置扩展信息
	 *
	 * @access	public
	 * @param	$aExtInfo		W3B_IExtensionInfo
	 * @return	void
	 */
	public function SetExtensionInfo(W3B_IExtensionInfo $aExtInfo)
	{
		$this->aExtInfo = $aExtInfo ;
	}
	
	/**
	 * 取得扩展信息
	 *
	 * @access	public
	 * @return	W3B_IExtensionInfo
	 */
	public function GetExtensionInfo()
	{
		return $this->aExtInfo ;
	}
	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		W3B_EventDispatcher	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{}

	/**
	 * 设置首选数据库
	 *
	 * @access	public
	 * @param 	$aDB	JCAT_DB
	 * @return	void
	 */
	public function SetPrimaryDB(JCAT_DB $aDB)
	{
		$this->aPrimaryDB = $aDB ;
	}
	
	/**
	 * 设置首选数据库
	 *
	 * @access	public
	 * @return	JCAT_DB
	 */
	public function GetPrimaryDB()
	{
		return $this->aPrimaryDB ;
	}

	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @param 	$aService		W3B_Service
	 * @return	bool
	 */
	public function Load(W3B_Service $aService)
	{
		$this->bLoaded = true ;
	}
	
	/**
	 * 返回 改模板是否已加载
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsLoaded()
	{
		return $this->bLoaded ;
	}		
	
	/**
	 * 取得配置对象
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPreference()
	{
		// 延迟到访问时载入 preference
		if(!$this->aPreference)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($this->aService,'W3B_Service') ;
			$aPlatform = $this->aService->GetPlatform() ;
			
			$aPlatformPreference = $aPlatform->GetPreference() ;
			 
			$aInfo = $this->GetExtensionInfo() ;
			$sExtensionName = $aInfo->GetName() ;
			$nServiceId = $this->aService->GetServiceId() ;
			$sKeyPath = "/Extensions/{$sExtensionName}/{$nServiceId}" ;
			
			if( !$aPlatformPreference->HasKey($sKeyPath) )
			{
				if( !$aPlatformPreference->CreateKey($sKeyPath) )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'无法为扩展: %s 创建 Preference Key'
						, 'W3B_Extensions', null
						, $sExtensionName
					)) ;
				}
			}

			$this->aPreference = $aPlatformPreference->CreateSubPreference($sKeyPath) ;
		}
		
		return $this->aPreference ;
	}

	
	/**
	 * 取得各服务的公共配置对象
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPublicPreference()
	{
		// 延迟到访问时载入 preference
		if(!$this->aPublicPreference)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($this->aService,'W3B_Service') ;
			$aPlatform = $this->aService->GetPlatform() ;
			$aPlatformPreference = $aPlatform->GetPreference() ;
			 
			$aInfo = $this->GetExtensionInfo() ;
			$sExtensionName = $aInfo->GetName() ;
			$sKeyPath = "/Extensions/{$sExtensionName}" ;
			
			if( !$aPlatformPreference->HasKey($sKeyPath) )
			{
				if( !$aPlatformPreference->CreateKey($sKeyPath) )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'无法为扩展: %s 创建 Public Preference Key'
						, 'W3B_Extensions', null
						, $sExtensionName
					)) ;
				}
			}

			$this->aPublicPreference = $aPlatformPreference->CreateSubPreference($sKeyPath) ;
		}
		
		return $this->aPublicPreference ;
	}
	
	/**
	 * 设置扩展缺省的 缓存对象
	 *
	 * @access	public
	 * @param	$aDefaultCache		JCAT_ICache	缓存对象
	 * @return	old_value
	 */
	public function SetDefaultCache(JCAT_ICache $aDefaultCache,$bPublic=false)
	{
		if($bPublic)
		{
			$aProperty =& $this->aDefaultPublicCache ;
		}
		
		else 
		{
			$aProperty =& $this->aDefaultCache ;
		}
		
		$old_value = $aProperty ;
		$aProperty = $aDefaultCache ;
		return $old_value ;
	}
	
	/**
	 * 取得扩展缺省的 缓存对象
	 *
	 * @access	public
	 * @return	JCAT_ICache
	 */
	public function GetDefaultCache($bPublic=false)
	{
		if($bPublic)
		{
			$aProperty =& $this->aDefaultPublicCache ;
		}
		
		else 
		{
			$aProperty =& $this->aDefaultCache ;
		}
		
		if(!$aProperty)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($this->aService,'W3B_Service') ;
			$aPlatform = $this->aService->GetPlatform() ;
			$aExtInfo = $this->GetExtensionInfo() ;
			$aProperty = $aPlatform->GetExtensionCache($aExtInfo->GetName(),$bPublic?null:$this->aService) ;
		}
		return $aProperty ;
	}
	
	/**
	 * 设置扩展缺省的 临时文件目录
	 *
	 * @access	public
	 * @param	$sTempDirectory		string	临时文件目录
	 * @return	old_value
	 */
	public function SetDefaultTempDirectory($sTempDirectory,$bPublic=false)
	{
		if($bPublic)
		{
			$sProperty =& $this->sTempDirectory ;
		}
		
		else 
		{
			$sProperty =& $this->sPublicTempDirectory ;
		}
		
		$old_value = $sProperty ;
		$sProperty = $sTempDirectory ;
		return $old_value ;
	}
	
	/**
	 * 取得扩展缺省的 临时文件目录
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDefaultTempDirectory($bPublic=false)
	{
		if($bPublic)
		{
			$sProperty =& $this->sTempDirectory ;
		}
		
		else 
		{
			$sProperty =& $this->sPublicTempDirectory ;
		}
		
		if(!$sProperty)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($this->aService,'W3B_Service') ;
			$aPlatform = $this->aService->GetPlatform() ;
			$aExtInfo = $this->GetExtensionInfo() ;
			
			$sProperty = $aPlatform->GetExtensionRCFolder($aExtInfo->GetName(),W3B_Platform::RC_TEMP,$bPublic?null:$this->aService) ;
		}
		
		return $sProperty ;
	}
	
	/**
	 * 设置扩展缺省的 用户资源目录
	 *
	 * @access	public
	 * @param	$sUserRCDirectory		string	用户资源目录
	 * @return	old_value
	 */
	public function SetDefaultUserRCDirectory($sUserRCDirectory,$bPublic=false)
	{
		if($bPublic)
		{
			$sProperty =& $this->sUserRCDirectory ;
		}
		
		else 
		{
			$sProperty =& $this->sPublicUserRCDirectory ;
		}
		
		$old_value = $sProperty ;
		$sProperty = $sUserRCDirectory ;
		return $old_value ;
	}
	
	/**
	 * 取得扩展缺省的 用户资源目录
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDefaultUserRCDirectory($bPublic=false)
	{
		if($bPublic)
		{
			$sProperty =& $this->sUserRCDirectory ;
		}
		
		else 
		{
			$sProperty =& $this->sPublicUserRCDirectory ;
		}
		
		if(!$sProperty)
		{
			JCAT_ASSERT::ASSERT_INSTANCE($this->aService,'W3B_Service') ;
			$aPlatform = $this->aService->GetPlatform() ;
			$aExtInfo = $this->GetExtensionInfo() ;
			
			$sProperty = $aPlatform->GetExtensionRCFolder($aExtInfo->GetName(),W3B_Platform::RC_USER,$bPublic?null:$this->aService) ;
		}
		
		return $sProperty ;
	}
	
	/**
	 * 
	 *
	 * @access	public
	 * @param	$sDataName		string
	 * @param	$Value			mixed
	 * @param	$sKey=null		string
	 * @return	void
	 */
	public function RegisterData($sDataName,$Value,$sKey=null)
	{
	    if($sKey===null)
	    {
		    $this->arrDatas[$sDataName] = $Value ;
	    }
	    
	    else
	    {
		    $this->arrDatas[$sDataName][$sKey] = $Value ;
	    }
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName		string
	 * @param	$sKey=null		string
	 * @return	mixed
	 */
	public function GetData($sDataName,$sKey=null)
	{
	    if($sKey===NULL)
	    {
    		return isset($this->arrDatas[$sDataName])?
    		            $this->arrDatas[$sDataName]: null ;
	    }
	    
	    else
	    {
    		return isset($this->arrDatas[$sDataName][$sKey])?
    		            $this->arrDatas[$sDataName][$sKey]: null ;
	    }
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function UnregisterData($sDataName,$sKey=null)
	{
	    if($sKey===NULL)
	    {
    		unset($this->arrDatas[$sDataName]) ;
	    }
	    
	    else
	    {
    		unset($this->arrDatas[$sDataName][$sKey]) ;
	    }
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName=null
	 * @return	void
	 */
	public function ClearData($sDataName=null)
	{
		if($sDataName===ull)
		{
		    $this->arrDatas = array() ;
		}
		
		else
		{
		    $this->UnregisterData($sDataName) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName=null
	 * @return	JCAT_IHashTableIterator
	 */
	public function CreateDataIterator($sDataName=null)
	{
		if($sDataName===ull)
		{
		    return JCAT_ArrayIterator($this->arrDatas) ;
		}
		
		else
		{
		    if( !isset($this->arrDatas[$sDataName]) )
		    {
		        return new JCAT_NullIterator() ;
		    }
		    
		    else 
		    {
		        if( is_array($this->arrDatas[$sDataName]) )
		        {
		            return new JCAT_ArrayIterator($this->arrDatas[$sDataName]) ;
		        }
		        
		        else
		        {
		            return new JCAT_ArrayIterator( array($this->arrDatas[$sDataName]) ) ;
		        }
		    }
		}
	}
	
	// 属性 ////////////////////////////////////////
	
	/**
	 * 首选数据库
	 * 
	 * @access	private
	 * @var		JCAT_DB
	 */
	private $aPrimaryDB ;
	
	/**
	 * 当前服务
	 * 
	 * @access	private
	 * @var		W3B_Service
	 */
	private $aService ;
	
	/**
	 * 配置
	 * 
	 * @access	private
	 * @var		JCAT_IPreference
	 */
	private $aPreference ;
	
	/**
	 * 公共配置
	 * 
	 * @access	private
	 * @var		JCAT_IPreference
	 */
	private $aPublicPreference ;
	
	/**
	 * 记录扩展是否已加载
	 * 
	 * @access	private
	 * @var		bool
	 */
	private $bLoaded = false ;

	
	/**
	 * 扩展缺省的 用户资源目录
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sUserRCDirectory = '' ;
	private $sPublicUserRCDirectory = '' ;
	
	/**
	 * 扩展缺省的 临时文件目录
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sTempDirectory = '' ;
	private $sPublicTempDirectory = '' ;
	
	
	/**
	 * 扩展缺省的 缓存对象
	 * 
	 * @access	private
	 * @var		JCAT_ICache
	 */
	private $aDefaultCache = null ;
	private $aDefaultPublicCache = null ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrDatas = array() ;
	
	/**
	 * 已载入的 扩展 享员对象
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_IExtension
	 */
	static private $arrLoadedExtensions = array() ;
	
	
	
	const EVENT_ExtensionLoaded = 'ExtensionLoaded' ;
}


?>
