<?php 

class W3B_ExtensionInfo implements W3B_IExtensionInfo
{	
	protected function W3B_ExtensionInfo()
	{}

	/**
	 * Description
	 *
	 * @access	private
	 * @static
	 * @return	W3B_ExtensionInfo
	 */
	static public function GetInstance($sExtName,$sExtVersion)
	{
		$sFlyweightKey = "{$sExtName}:{$sExtVersion}" ;
		
		if( !isset(self::$arrGlobalInstances[$sFlyweightKey]) )
		{
			$sInfoFile = W3B_Extension_ROOT."{$sExtName}/{$sExtVersion}/ExtInfo.xml" ;
			$nInfoMTime = filemtime($sInfoFile) ;
		
			if( $aExtInfo=self::LoadFromCache($sExtName,$sExtVersion,$nInfoMTime) )
			{
				self::$arrGlobalInstances[$sFlyweightKey] = $aExtInfo ;
			}
			
			// 从 ExtInfo.xml 文件载入
			else
			{
				$aExtInfo = self::CreateFromName($sExtName,$sExtVersion) ;
				self::SaveToCache($aExtInfo) ;
				self::$arrGlobalInstances[$sFlyweightKey] = $aExtInfo ;
			}
		}
		
		return self::$arrGlobalInstances[$sFlyweightKey] ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrGlobalInstances = array() ;
	
	/**
	 * Description
	 *
	 * @access	private
	 * @static
	 * @return	W3B_ExtensionInfo, null
	 */
	static private function LoadFromCache($sExtName,$sExtVersion,$nExtInfoMTime=0)
	{
		// 使用缓存
		$aCache = new JCAT_HDCache(W3B_DATA_ROOT.'Platform/Cache/ExtInfos') ;
		$sCacheKey = "{$sExtName}[{$sExtVersion}]" ;
		$nCache = $aCache->GetCacheTime($sCacheKey) ;
		if( $nCache>0 and $nCache>=$nExtInfoMTime )
		{
			$sCacheContent = $aCache->Get($sCacheKey) ;
			return @unserialize($sCacheContent) ;
		}
		
		else
		{
			return null ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @static
	 * @return	void
	 */
	static private function SaveToCache(W3B_ExtensionInfo $aExtInfo)
	{
		$sExtName = $aExtInfo->GetName() ;
		$sExtVersion = $aExtInfo->GetVersion() ;
		
		$aCache = new JCAT_HDCache(W3B_DATA_ROOT.'Platform/Cache/ExtInfos') ;
		$sCacheKey = "{$sExtName}[{$sExtVersion}]" ;
		
		$aCache->Set($sCacheKey,serialize($aExtInfo)) ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @static
	 * @return	W3B_ExtensionInfo
	 */
	static public function CreateFromName($sExtName,$sExtVersion)
	{
		$sInfoFile = W3B_Extension_ROOT."{$sExtName}/{$sExtVersion}/ExtInfo.xml" ;
		if( !file_exists($sInfoFile) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展 %s(版本:%s) 不存在，无法载入扩展信息。'
				, 'W3B_Extensions', null
				, $sExtName
				, $sExtVersion
			)) ;
		}
		
		$aInfo = new W3B_ExtensionInfo() ;
		
		$aInfo->sInfoFile = $sInfoFile ;
		$aInfo->sExtName = $sExtName ;
		$aInfo->sExtVersion = $sExtVersion ;
		
		$aXmlDoc = null ;
		try
		{
			$aXmlDoc = simplexml_load_file($sInfoFile) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx('无法读取扩展(%s)的声明文件：%s。遇到错误：%s','W3B_Extensions',null,$this->sExtName,$sInfoFile,$e->getMessage())) ;
		}
		
		$aInfo->LoadExtInfo($aXmlDoc) ;
		
		return $aInfo ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @static
	 * @return	W3B_ExtensionInfo
	 */
	static public function CreateFromXml($sExtInfoXml)
	{
		$aXmlDoc = null ;
		try
		{
			$aXmlDoc = simplexml_load_string($sExtInfoXml) ;
		}
		catch (Exception $e)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx('无法读取扩展的声明;遇到错误：%s','W3B_Extensions',null,$e->getMessage())) ;
		}
		
		$aInfo = new W3B_ExtensionInfo() ;
		$aInfo->LoadExtInfo($aXmlDoc) ;
		
		return $aInfo ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aExtInfo		W3B_IExtensionInfo
	 * @static
	 * @return	W3B_IExtensionInfo
	 */
	static public function CreateDependenceItem(W3B_IExtensionInfo $aExtInfo)
	{
		$aExtensionCompatibleVersions = $aExtInfo->GetCompatibleVersions() ;
		$aExtensionDependenceItem = new W3B_DependenceItem(
						$aExtInfo->GetName()
						, $aExtensionCompatibleVersions
						, $aExtInfo->GetVersion() ) ;
		$aExtensionDependenceItem->Attach($aExtInfo) ;
		
		return $aExtensionDependenceItem ;
	}

	private function LoadExtInfo(SimpleXMLElement $aExtInfoRoot)
	{
		foreach ($this->arrExtInfo as $sInfoName=>$sXPathInfo)
		{
			list($sType,$sXPath) = explode(':',$sXPathInfo) ;
			$bSingleInfo = ($sType=='s') ;
			
			// query
			$arrNodes = $aExtInfoRoot->xpath($sXPath) ;
			
			// check null
			if( count($arrNodes)==0 )
			{
				if(in_array($sInfoName,self::$arrMustInfo))
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx('扩展(%s)的声明文件：%s 中缺少必须的信息：%s','W3B_Extensions',null,$this->sExtName,$this->sInfoFile,$sInfoName)) ;
				}
				
				$this->arrExtInfo[$sInfoName] = $bSingleInfo? null: array() ;
			}
			
			else 
			{
				// single node
				if($bSingleInfo)
				{
					$this->arrExtInfo[$sInfoName] = strval($arrNodes[0]) ;
				}
				
				// multi node
				else
				{
					$this->arrExtInfo[$sInfoName] = array() ;
					foreach($arrNodes as $aNode)
					{
						$this->arrExtInfo[$sInfoName][] = strval($aNode) ;
					}
				}
			}
		}		
		
		// 是否抽象扩展
		if( $this->arrExtInfo['bAbstract']===null )
		{
			$this->arrExtInfo['bAbstract'] = false ;
		}
		
		else 
		{
			$this->arrExtInfo['bAbstract'] = in_array($this->arrExtInfo['bAbstract'],array('false','0','off'))? false: true ;
		}
		
		// 版本
		if( !JCAT_Version::VerifyFormat($this->arrExtInfo['sVersion']) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx('扩展(%s)的声明文件：%s 中使用了无效的版本信息：%s','W3B_Extensions',null,$this->sExtName,$this->sInfoFile,$this->arrExtInfo['sVersion'])) ;
		}
		$this->arrExtInfo['aVersion'] = JCAT_Version::FromString($this->arrExtInfo['sVersion']) ;
		
		// 资源版本号
		if( !empty($this->arrExtInfo['sRCVersion']) )
		{
			if( !JCAT_Version::VerifyFormat($this->arrExtInfo['sRCVersion']) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx('扩展(%s)的声明文件：%s 中使用了无效的资源版本信息：%s','W3B_Extensions',null,$this->sExtName,$this->sInfoFile,$this->arrExtInfo['sVersion'])) ;
			}
			$this->arrExtInfo['aRCVersion'] = JCAT_Version::FromString($this->arrExtInfo['sRCVersion']) ;
		}
		
		
		// 提供
		if(!is_numeric($this->arrExtInfo['sProvide']))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'扩展(%s)的声明文件：%s 中使用了无效的Provide信息：%s'
								, 'W3B_Extensions', null
						, $this->sExtName
						, $this->sInfoFile
						, $this->arrExtInfo['sProvide']
			)) ;
		}
		$this->arrExtInfo['nProvide'] = intval($this->arrExtInfo['sProvide']) ;
		
		// 优先级
		if (array_key_exists('sPriorityLevel',$this->arrExtInfo))
		{
			$this->arrExtInfo['nPriorityLevel'] = intval($this->arrExtInfo['sPriorityLevel']) ;
			if( $this->arrExtInfo['nPriorityLevel']<W3B_IExtensionInfo::PRIORITYLEVEL_HIGHEST
						 or $this->arrExtInfo['nPriorityLevel']>W3B_IExtensionInfo::PRIORITYLEVEL_LOWEST )
			{
				throw new JCAT_Exception( JCAT_Language::SentenceEx(
						'扩展(%s)的声明文件：%s 中使用了无效的PriorityLevel信息：%s。PriorityLevel 必须是一个介于%d和%d之间的整数。'
								, 'W3B_Extensions', null
						, $this->sExtName
						, $this->sInfoFile
						, $this->arrExtInfo['sPriorityLevel']
						, W3B_IExtensionInfo::PRIORITYLEVEL_HIGHEST
						, W3B_IExtensionInfo::PRIORITYLEVEL_LOWEST
				) ) ;
			}
		}
		
		else
		{
			$this->arrExtInfo['nPriorityLevel'] = W3B_IExtensionInfo::PRIORITYLEVEL_GENERAL ;
		}
		
		// 取得兼容版本
		$this->arrExtInfo['aCompatibleVersions'] = new JCAT_VersionCompat() ;
		$this->arrExtInfo['aCompatibleVersions']->AddCompatibleVersion($this->arrExtInfo['aVersion']) ;			// <<-- compat itself
		foreach($this->arrExtInfo['arrCompatibleVersions'] as $sCompatibleVersions)
		{
			$this->arrExtInfo['aCompatibleVersions']->AddFromString($sCompatibleVersions) ;
		}
		
		// 取得安装对象信息
		if(count($aExtInfoRoot->Installer))
		{
			$aInstaller = $aExtInfoRoot->Installer[0] ;
			$this->sInstallerClassName = (string)$aInstaller['class'] ;
			$this->sInstallerClassPath = (string)$aInstaller['path'] ;
		}
		else 
		{
			$this->sInstallerClassName = '' ;
			$this->sInstallerClassPath = '' ;
		}
		
		// 取得资源升级对象信息
		$this->aRCUpgradePathWeb = new W3B_ExtensionRCUpgradePathWeb() ;
		if(count($aExtInfoRoot->RCUpgraders->Item))
		{
			foreach ($aExtInfoRoot->RCUpgraders->Item as $aItem)
			{
				$aFrom = JCAT_Version::FromString((string)$aItem['from']) ;
				$aTo = JCAT_Version::FromString((string)$aItem['to']) ;
				
				$this->aRCUpgradePathWeb->AddUpgrader($aFrom,$aTo,(string)$aItem['class'],(string)$aItem['path']);
			}
		}
		
	}
	
	private function GetInfoLanguagePackageName()
	{
		return $this->arrExtInfo['sLanguagePackage'] ;
	}
	
	/**
	 * 取得扩展的名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetName()
	{
		return $this->arrExtInfo['sName'] ;
	}
	
	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @return	string
	 */
	public function GetTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		if($sLanguage==JCAT_Language::CURRENT_LANGUAGE)
		{
			$sLanguage = JCAT_Language::GetCurrentLanguage()->GetLanguageName() ;
		}
		$sPackageName = $this->GetInfoLanguagePackageName() ;
		
		if(JCAT_LanguagePackage::HasLoaded($sLanguage,$sPackageName))
		{
			return JCAT_Language::SentenceEx($this->arrExtInfo['sTitle'],$sPackageName, $sLanguage) ;
		}
		
		else
		{
			return $this->arrExtInfo['sTitle'] ;
		}
	}
	
	/**
	 * 是否是一个抽象扩展，没有提供面向用户的实际功能，而是仅仅为其他扩展提供特性
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsAbstract()
	{
		return $this->arrExtInfo['bAbstract'] ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @return	string
	 */
	public function GetDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		if($sLanguage==JCAT_Language::CURRENT_LANGUAGE)
		{
			$sLanguage = JCAT_Language::GetCurrentLanguage()->GetLanguageName() ;
		}
		$sPackageName = $this->GetInfoLanguagePackageName() ;
		
		if(JCAT_LanguagePackage::HasLoaded($sLanguage,$sPackageName))
		{
			return JCAT_Language::SentenceEx($this->arrExtInfo['sDescription'],$sPackageName, $sLanguage) ;
		}
		
		else
		{
			return $this->arrExtInfo['sDescription'] ;
		}
	}
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetVersion()
	{
		return isset($this->arrExtInfo['aVersion'])? $this->arrExtInfo['aVersion']: null ;
	}
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetRCVersion()
	{
		return isset($this->arrExtInfo['aRCVersion'])? 
				$this->arrExtInfo['aRCVersion'] :
				$this->GetVersion() ;
	}

	/**
	 * 取得扩展提供的功用
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetProvide()
	{
		return isset($this->arrExtInfo['nProvide'])? $this->arrExtInfo['nProvide']: 0 ;
	}

	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPriorityLevel()
	{
		return $this->arrExtInfo['nPriorityLevel'] ;
	}
	
	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateDependenceIterator()
	{
		return new JCAT_ArrayIterator($this->arrExtInfo['arrDependencies']) ;
	}
	
	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @param 	$nRcType		int
	 * @return	JCAT_IIterator
	 */
	public function CreateResourceIterator($nRcType)
	{
		$nRcType = "arrType.{$nRcType}" ;
		return isset($this->arrExtInfo[$nRcType])?
					new JCAT_ArrayIterator($this->arrExtInfo[$nRcType]) :
					new JCAT_NullIterator() ;
	}
	
	/**
	 * 取得兼容版本
	 *
	 * @access	public
	 * @param 	$nRcType		int
	 * @return	JCAT_VersionCompat
	 */
	public function GetCompatibleVersions()
	{
		return $this->arrExtInfo['aCompatibleVersions'] ;
	}

	
	/**
	 * 创建一个扩展安装对象
	 *
	 * @access	public
	 * @param 	$aPlatform=null		W3B_Platform
	 * @return	W3B_ExtensionDefaultSetup
	 */
	public function CreateInstaller(W3B_Platform $aPlatform=null)
	{
		if(!$aPlatform)
		{
			$aPlatform = W3B_Platform::GetGlobalInstance() ;
		}
		
		if( empty($this->sInstallerClassName) or empty($this->sInstallerClassPath) )
		{
			return new W3B_ExtensionDefaultSetup($this->GetName(),$this->GetVersion()) ;
		}

		else 
		{
			$arrParams = array($this->GetName(),$this->GetVersion()) ;
			$this->LoadClassForSetup($this->sInstallerClassName,$this->sInstallerClassPath,$aPlatform) ;
			return JCAT_Global::CreateObject($this->sInstallerClassName,$arrParams) ;
		}
		
	}
	
	/**
	 * 创建升级扩展资源所需的 全部升级对象的迭代器
	 *
	 * @access	public
	 * @param	$aFromVersion		JCAT_Version
	 * @param	$aToVersion=null	JCAT_Version
	 * @param	$aPlatform=null		W3B_Platform
	 * @return	JCAT_IIterator
	 */
	public function CreateRCUpgraderIterator(JCAT_Version $aFromVersion,JCAT_Version $aToVersion=null,W3B_Platform $aPlatform=null)
	{
		if(!$aToVersion)
		{
			$aToVersion = $this->GetVersion() ;
		}
		if(!$aPlatform)
		{
			$aPlatform = W3B_Platform::GetGlobalInstance() ;
		}
		
		$aUpgradePath = $this->aRCUpgradePathWeb->FindUpgradePath($aFromVersion,$aToVersion) ;
		if(!$aUpgradePath)
		{
			return null ;
		}
		
		else
		{
			$arrPatchs = array() ;
			$aIterator = $aUpgradePath->CreatePatchIterator() ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$aPatch = $aIterator->Current() ;		
				$aPatch->GetClassName() ;
				
				// 载入 Patch 类
				$this->LoadClassForSetup(
							$aPatch->GetClassName()
							, $aPatch->GetClassPath()
							, $aPlatform
				) ;
				
				// 创建 Patch 对象
				$aPatch = JCAT_Global::CreateObject($aPatch->GetClassName()) ;
				$aPatch->SetPlatform($aPlatform) ;
				$arrPatchs[] = $aPatch  ;
			}
			
			return new JCAT_ArrayIterator($arrPatchs) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	void
	 */
	private function LoadClassForSetup($sClassName,$sClassPath,W3B_Platform $aPlatform)
	{
		$sExtPath = $aPlatform->GetExtensionPath($this->GetName(),$this->GetVersion()) ;
		$sFullClassPath = $sExtPath.$sClassPath ;
		
		if(!is_file($sFullClassPath))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展 %s:%s 内的路径无效：%s'
				, 'W3B_Extensions', null
				, $this->GetName(), $this->GetVersion(), $sClassPath
			)) ;
		}
		
		include_once $sFullClassPath ;
		
		if( !JCAT_Package::ClassExists($sClassName) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展 %s:%s 内的文件：%s 中没有定义类：%s'
				, 'W3B_Extensions', null
				, $this->GetName(), $this->GetVersion(), $sClassPath, $sClassName
			)) ;
		}
	}
	
	/**
	 * 设置对象属性
	 *
	 * @access	public
	 * @param	$sInfoName		string
	 * @param	$sInfo			string
	 * @return	void
	 */
	public function SetInfo($sInfoName,$sInfo)
	{
		$this->arrExtInfo[$sInfoName] = $sInfo ;
	}
	
	/**
	 * 取得对象属性
	 *
	 * @access	public
	 * @param	$sInfoName		string
	 * @return	string
	 */
	public function GetInfo($sInfoName)
	{
		return isset($this->arrExtInfo[$sInfoName])? $this->arrExtInfo[$sInfoName]: null ;
	}
	
	//////////////////////////////////////////////////////////////////////
	
	private $sInfoFile = '' ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $arrExtInfo = array(

			// string
			'sLanguagePackage' => 's:/W3B_Ext/LanguagePackage'
			, 'sName' => 's:/W3B_Ext/Name'
			, 'sVersion' => 's:/W3B_Ext/Version'
			, 'sRCVersion' => 's:/W3B_Ext/RCVersion'
			, 'bAbstract' => 's:/W3B_Ext/Abstract'
			, 'sTitle' => 's:/W3B_Ext/Title'
			, 'sDescription' => 's:/W3B_Ext/Description'
			, 'sVersion' => 's:/W3B_Ext/Version'
			, 'sProvide' => 's:/W3B_Ext/Provide'
			, 'sPriorityLevel' => 's:/W3B_Ext/PriorityLevel'

			// array
			, 'arrType.1' => 'm:/W3B_Ext/Resources/Type.1/Directory'
			, 'arrType.2' => 'm:/W3B_Ext/Resources/Type.2/Directory'
			, 'arrType.4' => 'm:/W3B_Ext/Resources/Type.4/Directory'
			, 'arrType.8' => 'm:/W3B_Ext/Resources/Type.8/Directory'
			, 'arrCompatibleVersions' => 'm:/W3B_Ext/CompatibleVersions/Scope'
			, 'arrDependencies' => 'm:/W3B_Ext/Dependencies/Item'
	) ;
	
	static private $arrMustInfo = array('sName','sVersion','Provide','sTitle') ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_ExtensionRCUpgradePathWeb
	 */
	private $aRCUpgradePathWeb ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sInstallerClassName ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		string
	 */
	private $sInstallerClassPath ;


}

?>