<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class W3B_ExtensionManager
{
	const PLATFORM_DEPENDNAME = 'Platform' ;
	
	const EXTENSION_SETUP_FOLDERNAME = 'Installer' ;
	
	/**
	 * 检查传入参数是否符合 扩展名称规法
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @static 	
	 * @return	void
	 */
	static public function VerifyExtensionName($sExtName)
	{
		return preg_match('/^Ext_\w{2,}$/',$sExtName) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function W3B_ExtensionManager(W3B_Platform $aPlatform)
	{
		$aPlatformDependenceItem = new W3B_DependenceItem('Platform',$aPlatform->GetCompatibleVersions(),$aPlatform->GetVersion()) ;
		// $aPlatformDependenceItem->Attach() ;
		$this->aDependenceTree = new W3B_DependenceTree() ;
		$this->aDependenceTree->AppendItem($aPlatformDependenceItem,new JCAT_NullIterator()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_DependenceTree
	 */
	public function GetExtensionDependenceTree()
	{
		return $this->aDependenceTree ;
	}
	
	public function CreateExtensionDependenceIterator($sExtensionName,$bReverse=false,$nLevel=1,$bFlag=W3B_DependenceAdvIterator::FLAG_DEFAULT)
	{
		$aExtensionDependenceItem = $this->aDependenceTree->GetDependenceItem($sExtensionName) ;
		return $aExtensionDependenceItem?
			 new W3B_DependenceAdvIterator($aExtensionDependenceItem,$bReverse,$nLevel,$bFlag): null ;
	}
	
	/**
	 * 打开优先级
	 *
	 * @access	public
	 * @param	$nPrioryLevel=-1
	 * @return	void
	 */
	public function OpenPrioryLevel($nPrioryLevel=-1)
	{
		JCAT_ASSERT::ASSERT_INT($nPrioryLevel)  ;
		JCAT_ASSERT::ASSERT_( $nPrioryLevel<=W3B_IExtensionInfo::PRIORITYLEVEL_LOWEST,JCAT_Language::SentenceEx(
								'正在输入一个无效的扩展优先级:%d, 必须在 %d 至 %d 之间。'
								, 'W3B_Extensions', null
								, $nPrioryLevel
								, W3B_IExtensionInfo::PRIORITYLEVEL_LOWEST
								, W3B_IExtensionInfo::PRIORITYLEVEL_HIGHEST
		)) ; 
		
		// 递增
		if($nPrioryLevel===-1)
		{
			if( $this->nCurrentOpenPrioryLevel<W3B_IExtensionInfo::PRIORITYLEVEL_LOWEST )
			{
				$this->nCurrentOpenPrioryLevel++ ;
			}
		}
		
		// 指定
		else
		{
			JCAT_ASSERT::ASSERT_($this->nCurrentOpenPrioryLevel<=$nPrioryLevel,JCAT_Language::SentenceEx(
									'当前扩展优先级已经开启至：%d, 无法开启更低的优先级: %d'
									, 'W3B_Extensions', null
									, $this->nCurrentOpenPrioryLevel
									, $nPrioryLevel
			)) ; 
			
			$this->nCurrentOpenPrioryLevel = $nPrioryLevel ;			
		}
	}
	
	/**
	 * 返回当前优先级
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetCurrentPrioryLevel()
	{
		return $this->nCurrentOpenPrioryLevel ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function ClearLoadedExtensionContainer()
	{
		$this->arrLoadedExtensions = array() ;
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function AppendExtension(W3B_Extension $aExtension)
	{
		$sExtensionName = get_class($aExtension) ;
		$this->arrLoadedExtensions[$this->GetCurrentPrioryLevel()][$sExtensionName] = $aExtension ;
		$this->arrExtensionPriory[$sExtensionName] = $this->GetCurrentPrioryLevel() ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param 	$sExtensionName		string
	 * @return	string
	 */
	public function GetExtensionPriory($sExtensionName)
	{
		return isset($this->arrExtensionPriory[$sExtensionName])? 
							$this->arrExtensionPriory[$sExtensionName]: null ;
	}

	/**
	 * 根据指定的名称返回扩展实例
	 *
	 * @access	public
	 * @param 	$sExtensionName		string	指定扩展名称
	 * @return	W3B_IExtension
	 */
	public function GetLoadedExtension($sExtensionName)
	{
		$nPriory = $this->GetExtensionPriory($sExtensionName) ;
		return isset($this->arrLoadedExtensions[$nPriory][$sExtensionName])?
						$this->arrLoadedExtensions[$nPriory][$sExtensionName]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param 	$sExtensionName		string
	 * @return	void
	 */
	private function RemoveExtension($sExtensionName)
	{
		$nPriory = $this->GetExtensionPriory($sExtensionName) ;
		unset($this->arrLoadedExtensions[$nPriory][$sExtensionName]) ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sExtName
	 * @return	void
	 */
	public function AppendExtensionByName($sExtensionName,$sExtensionVersion)
	{
		// 取得扩展信息
		$aExtensionInfo = W3B_ExtensionInfo::GetInstance($sExtensionName,$sExtensionVersion) ;
		
		// 加入扩展依赖树
		// --------------------------------------------------------
		$aExtensionDependenceItem = W3B_ExtensionInfo::CreateDependenceItem($aExtensionInfo) ;
		$this->aDependenceTree->AppendItem($aExtensionDependenceItem,$aExtensionInfo->CreateDependenceIterator()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function HasExtensionAppended($sExtName,JCAT_Version $aExtVersion=null)
	{
		$aItem = $this->aDependenceTree->GetDependenceItem($sExtName) ;
		if(!$aItem)
		{
			return false ;
		}
		
		if($aExtVersion)
		{
			$aExtInfo = $aItem->GetAttachment() ;
			if( JCAT_Global::IsKindOf($aExtInfo,'W3B_IExtensionInfo') )
			{
				return $aExtVersion->Compare($aExtInfo->GetVersion())==0 ;
			}
			
			return false ;
		}
		
		else
		{
			return true ;
		}
	}

	/**
	 * 加载一个已安装的扩展
	 *
	 * @access	public
	 * @param	$sExtensionName			string
	 * @param	$sExtensionVersion		string
	 * @param	$aService	W3B_Service
	 * @static
	 * @return	W3B_IExtension
	 */
	static public function LoadExtension($sExtensionName,$sExtensionVersion,W3B_Service $aService)
	{
		$aExtensionManager = $aService->GetExtensionManager() ;
		JCAT_ASSERT::ASSERT_NULL($aExtensionManager->GetLoadedExtension($sExtensionName)
				,JCAT_Language::SentenceEx('正在重复加载扩展:%s。','W3B_Extensions',null,$sExtensionName)) ;

		// 取得扩展对象
		$aExtension = W3B_Extension::GetExtensionInstance($sExtensionName,$sExtensionVersion,$aService) ;
		
		// 扩展提供的资源
		// --------------------------------------------------------
		$sExtensionPath = W3B_Extension_ROOT . "{$sExtensionName}/{$sExtensionVersion}/" ;
		$aExtensionManager->LoadExtensionResource($aExtension,$sExtensionPath) ;
		
		// 为扩展设置资源:设置主要数据库
		// --------------------------------------------------------
		$aPlatform = $aService->GetPlatform() ;
		$aDB = $aPlatform->GetDefaultDB() ;
		$aExtension->SetPrimaryDB($aDB);
		
		// 注册扩展的托管类
		// --------------------------------------------------------
		$aExtension->RegisterInTrustClass($aService->GetClassTrustee()) ;
		
		// 注册扩展的事件
		$aExtension->RegisterEvent($aService->GetEventDispatcher()) ;
		
		// 最后调用扩展 Load 方法
		// --------------------------------------------------------
		$aExtension->Load($aService) ;

		// 记录已加载的扩展
		// --------------------------------------------------------
		$aExtensionManager->AppendExtension($aExtension) ;
		
		return $aExtension ;
	}
	
	/**
	 * 加载扩展提供的资源
	 *
	 * @access	protected
	 * @param 	W3B_IExtension		$aExtension		扩展
	 * @return	void
	 */
	protected function LoadExtensionResource(W3B_IExtension $aExtension,$sExtRootPath)
	{
		$aExtInfo = $aExtension->GetExtensionInfo() ;
		JCAT_ASSERT::ASSERT_($aExtInfo) ;

		$nExtProvide = $aExtInfo->GetProvide() ;
		
		// 加载 扩展提供的类
		if($nExtProvide&W3B_IExtensionInfo::RC_CLASS)
		{
			$aClassLoader = JCAT_ClassLoader::GetGlobalInstance() ;
			$aIterator = $aExtInfo->CreateResourceIterator(W3B_IExtensionInfo::RC_CLASS) ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$sFolderPath = $sExtRootPath.$aIterator->Current() ;
				$aClassLoader->Import($sFolderPath,JCAT_ProjectState::Get(W3B_Platform::PROSTATE_UPDATE_CLASSESPATH));
			}
		}
		
		// 加载 扩展提供的 UITemplate 和 Style
		if($nExtProvide&W3B_IExtensionInfo::RC_UI)
		{
			// 模板文件
			$aIterator = $aExtInfo->CreateResourceIterator(W3B_IExtensionInfo::RC_UI_TEMPLATE) ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$sFolderPath = $sExtRootPath.$aIterator->Current() ;
				JCAT_UIHtml::AddTemplateDir( $sFolderPath ) ;
			}
			
			// CSS Style 
			$aIterator = $aExtInfo->CreateResourceIterator(W3B_IExtensionInfo::RC_UI_STYLE) ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$sFolderPath = $sExtRootPath.$aIterator->Current() ;
				JCAT_CSS::AddResourceDirectory($sFolderPath) ;
			}
		}
	
		// 加载 扩展提供的语言包目录
		if($nExtProvide&W3B_IExtensionInfo::RC_LANGUAGE)
		{
			$aIterator = $aExtInfo->CreateResourceIterator(W3B_IExtensionInfo::RC_LANGUAGE) ;
			for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
			{
				$sFolderPath = $sExtRootPath.$aIterator->Current() ;
				JCAT_LanguagePackage::AddPackageDir($sFolderPath) ;
			}
		}
	}
	
	
	
	
	
	/**
	 * 检查扩展的依赖项
	 *
	 * @access	public
	 * @param	$aExtInfo		W3B_IExtensionInfo
	 * @return	void
	 */
	public function CheckExtensionDependencies(W3B_IExtensionInfo $aExtInfo)
	{
		$aDependenceItem = W3B_ExtensionInfo::CreateDependenceItem($aExtInfo) ;
		$this->aDependenceTree->AppendItem($aDependenceItem,$aExtInfo->CreateDependenceIterator(),true);
		return ;
	}
	
	/**
	 * 创建一个已加载扩展的优先级的迭代起
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateExtensionPrioryIterator()
	{
		return new JCAT_ArrayIterator(array_keys($this->arrLoadedExtensions)) ;
	}
	
	/**
	 * 根据指定的优先级返回该优先级内已加载的扩展
	 *
	 * @access	public
	 * @param	$nPrioryLevel
	 * @return	JCAT_IIterator
	 */
	public function CreateLoadedExtensionIterator($nPrioryLevel=-1)
	{
		// all extension
		if($nPrioryLevel<0)
		{
			if(count($this->arrLoadedExtensions)<1)
			{
				return new JCAT_NullIterator() ;
			}
			
			else if(count($this->arrLoadedExtensions)==1)
			{
				return new JCAT_ArrayIterator( current($this->arrLoadedExtensions) ) ;
			}
			
			else 
			{
				return new JCAT_ArrayIterator( call_user_func_array('array_merge',$this->arrLoadedExtensions) ) ;
			}
		}
		
		// special priory level
		else
		{
			return isset($this->arrLoadedExtensions[$nPrioryLevel])?
							new JCAT_ArrayIterator($this->arrLoadedExtensions[$nPrioryLevel]):
							new JCAT_NullIterator() ;
		}
	}


	
	// 属性 //////////////////////////////////////////

	
	/**
	 * 服务已加载的扩展
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrLoadedExtensions = array() ;
	
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		int
	 */
	private $nCurrentOpenPrioryLevel = W3B_IExtensionInfo::PRIORITYLEVEL_HIGHEST ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_DependenceTree
	 */
	private $aDependenceTree ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrExtensionPriory = array() ;
	
	//  VVVVVVV  old code  vvvvvvvvvv
	
	
	
	
	
	
	
	/**
	 * 下载扩展包
	 *
	 * @access	private
	 * @param	$sExtName			string
	 * @param	$aExtVersion		JCAT_Version
	 * @static
	 * @return	void
	 */
	static private function DownloadExtensionPackage($sExtName,JCAT_Version $aExtVersion)
	{
		// TODO
	}

	/**
	 * 释放扩展包
	 *
	 * @access	private
	 * @param	$sExtPackagePath	string
	 * @static
	 * @return	void
	 */
	static private function ReleaseExtensionPackage( $sExtPackagePath )
	{
		// TODO
	}
	
	
	/**
	 * 安装扩展
	 *
	 * @access	private
	 * @param	$aService				W3B_Service
	 * @param	$sExtName				string
	 * @param	$aExtVersion=null		JCAT_Version
	 * @return	void
	 */
	static private function SetupExtension_old(W3B_Service $aService,$sExtName,JCAT_Version $aExtVersion=null)
	{
		// 判断 是否需要安装
		// -----------------------------------------
		$aSetupedExtVersion= $aService->GetSetupedExtensionVersion($sExtName) ;
		
		// 已安装 同名扩展
		if( $aSetupedExtVersion )
		{
			$nRes = $aSetupedExtVersion->Compare($aExtVersion) ;
			
			// 已经安装
			if( $nRes===0 )
			{
				return ;
			}
			
			// 需要升级
			else if( $nRes<0 )
			{
				// TODO 
			}
			
			else 
			{
				throw new JCAT_Exception( 
						JCAT_Language::SentenceEx("正在安装的扩展 %s(%s)，已经安装了更高级的版本:%s",'W3B_Extensions',null
						  , $sExtName
						  , $aExtVersion
						  , $aSetupedExtVersion
				) ) ;
			}
		}
		
		// 尚未安装同名扩展
		else 
		{
			// 下载扩展包
			self::DownloadExtensionPackage($sExtName,$aExtVersion) ;

			// 解压扩展包
			self::ReleaseExtensionPackage($sExtName,$aExtVersion) ;

			// 安装扩展包
			self::SetupReleasedExtension($aService,$sExtName,$aExtVersion) ;
		}
	}

	static public function UnsetupExtensions($sExtName,$bCompletely=true,W3B_Service $aService=null)
	{
		if($aService===null)
		{
			$aService = W3B_Service::GetCurrentService() ;
		}
		
		// unsetup all be depended
		$arrTotalExtensions = self::GetBeDependedExtension($sExtName) ;
		foreach ($arrTotalExtensions as $sBeDepedExtName)
		{
			self::UnsetupOneExtension($sBeDepedExtName,$bCompletely,$aService) ;
			new JCAT_Message(JCAT_Language::SentenceEx('扩展已卸载：%s','W3B_Extensions',null,$sBeDepedExtName),MSGMVC_OK) ;
		}
		
		// unsetup this extension
		self::UnsetupOneExtension($sExtName,$bCompletely,$aService) ;
		new JCAT_Message(JCAT_Language::SentenceEx('扩展已卸载：%s','W3B_Extensions',null,$sExtName),MSGMVC_OK) ;
	}
	

	/**
	 * 返回扩展的所有依赖项
	 *
	 * @access	public
	 * @param	$sExtName			string
	 * @static
	 * @return	array
	 */
	static public function GetBeDependedExtensions($sExtName,$aService)
	{
		// 递归的方式查询依赖项
		$arrBeDepended = array() ;
		$arrTotalExts = $aService->GetAllLoadedExtensions(false,false) ;
		foreach ($arrTotalExts as $sLoadedExtName)
		{
			$aExtension = $aService->GetLoadedExtension($sLoadedExtName) ;
			if(!$aExtension)
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'当前系统没有安装名为：%s 的扩展'
					, 'Ext_JCExtensionManager', null
					, $sExtName
				)) ;
			}
			
			// 
			$aExtensionInfo = $aExtension->GetExtensionInfo() ;
			$aExtDependIterator = $aExtensionInfo->CreateDependenceIterator() ;
			for ( $aExtDependIterator->First(); !$aExtDependIterator->IsDone(); $aExtDependIterator->Next() )
			{
				$sDependItem=$aExtDependIterator->Current();
				list($sDependExtName,) = explode(':',$sDependItem) ;
			
				if($sDependExtName==$sExtName)
				{
					$arrBeDepended[] = $sLoadedExtName ; 
					break ;
				}
			}
		}
		
		return $arrBeDepended ;
	}
}

?>