<?php


class W3B_ExtensionPackage extends JCAT_FSPackage 
{
	const Version = '0.2.0' ;
	const Version32Int = 8388608 ;
	
	
	const PACKINFO_NAME_Version = 'W3B.Extension.PackageVersion' ;
	const PACKINFO_NAME_Version32Int = 'W3B.Extension.PackageVersion32Int' ;
	const PACKINFO_NAME_ExtInfo = 'W3B.Extension.ExtInfo' ;
	
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$sPackagePath		string
	 * @return	void
	 */
	public function W3B_ExtensionPackage($sPackagePath)
	{
		$this->JCAT_FSPackage($sPackagePath) ;
		
		// 检查 文件包的格式，是否是一个 W3B扩展包
		$this->CheckPackageFormat() ;

		// 读取 ExtInfo
		$this->aExtInfo = W3B_ExtensionInfo::CreateFromXml(
			$this->GetExtensionalInfo(self::PACKINFO_NAME_ExtInfo)
		) ;
	}

	/**
	 * 检查给定的文件是否有效的 扩展包
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function CheckPackageFormat()
	{
		$sVer = $this->GetExtensionalInfo(self::PACKINFO_NAME_Version32Int) ;
		
		if(!$sVer or !$this->GetExtensionalInfo(self::PACKINFO_NAME_Version) or !$this->GetExtensionalInfo(self::PACKINFO_NAME_ExtInfo))
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'这不是一个 W3B 扩展包。'
				, 'W3B_Extensions', null
			)) ;
		}
		
		if($sVer!=self::Version32Int)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法支持 W3B 扩展包的版本：%s；期待版本为：%s'
				, 'W3B_Extensions', null, $sVer, self::Version32Int
			)) ;
		}
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_IExtensionInfo
	 */
	public function GetExtInfo()
	{
		return $this->aExtInfo ;
	}

	/**
	 * 将一个已安装的 扩展 打包
	 *
	 * @access	public
	 * @param	$sExtName			string
	 * @param	$sExtVersion		JCAT_Version
	 * @param	$sToPath				string
	 * @static
	 * @return	W3B_ExtensionPackage
	 */
	static public function PackageExtension( $sExtName, JCAT_Version $sExtVersion, $sToPath=null )
	{
		if($sToPath===null)
		{
			$sToPath = W3B_Platform::GetGlobalInstance()->GetExtensionPackageCachePath($sExtName,$sExtVersion) ;
		}

		$sToDir = dirname($sToPath) ; 
		if( !is_dir($sToDir) and !JCAT_FSO::CreateDir($sToDir,true,0777) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法自动创建放置扩展包的目录：%s'
				, 'W3B_Extensions', null
				, $sToDir
			)) ;
		}
		
		$sExtensionRootPath = W3B_Extension_ROOT."{$sExtName}/{$sExtVersion}/" ;
		if( !is_dir($sExtensionRootPath) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'指定的扩展不存在:%s(%s)'
				, 'W3B_Platform', null
				, $sExtName, $sExtVersion
			)) ;
		}
		
		$aPackagePacker = new JCAT_FilePacker() ;
		
		// 设置 filter
		foreach(self::$arrFileFilter as $sFilter)
		{
			$aPackagePacker->AddPathFilter($sFilter) ;
		}
		
		// 添加文件
		$aPackagePacker->AppendChildren($sExtensionRootPath) ;
		
		
		// 设置 扩展包版本
		$aPackagePacker->SetExtensionalInfo(self::PACKINFO_NAME_Version,self::Version) ;
		$aPackagePacker->SetExtensionalInfo(self::PACKINFO_NAME_Version32Int,self::Version32Int) ;
		
		// 设置  扩展 ExtInfo
	
		// 制作扩展包头部信息
		$sXML = @file_get_contents($sExtensionRootPath.'ExtInfo.xml') ;
		if( empty($sXML) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'打包扩展 :%s(%s) 遇到错误, 无法读取扩展的 ExtInfo.xml 文件'
				, 'W3B_Platform', null
				, $sExtName, $sExtVersion
			)) ;
		}
		$aPackagePacker->SetExtensionalInfo(self::PACKINFO_NAME_ExtInfo,$sXML) ;
		
		
		// 打包
		$aPackagePacker->Pack($sToPath,$sToDir) ;
	}


	/**
	 * 将 扩展包 释放到指定目录
	 *
	 * @access	public
	 * @param	$sToPath				string
	 * @return	bool
	 */
	public function UnpackageExtension( $sToPath )
	{
		$this->Release($sToPath) ;
		return true ;
	}

	
	// 属性 /////////////////////////////////////////////////////
	
	private $aExtInfo ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrFileFilter = array(
			'|/\.svn$|i' ,  						// .svn 目录
			'|/\.Compileds$|i' , 					// .Compileds 目录
			'|/inc\.TemplateFileIndex\.php$|i' , 	// inc.TemplateFileIndex.php 文件
			'|/ClassesPath\.serialize$|i' , 		// ClassesPath.serialize 文件
		) ;
}


?>