<?php

interface W3B_IExtension
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @param	$aService					W3B_Service			当前服务
	 * @return	void
	 */
	public function __construct(W3B_Service $aService) ;
	
	
	/**
	 * 设置扩展信息
	 *
	 * @access	public
	 * @param	$aExtInfo		W3B_IExtensionInfo
	 * @return	void
	 */
	public function SetExtensionInfo(W3B_IExtensionInfo $aExtInfo) ;
	
	/**
	 * 取得扩展信息对象
	 * 
	 * @access	public
	 * @return	W3B_IExtensionInfo
	 */
	public function GetExtensionInfo() ;
	
	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee) ;
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		W3B_EventDispatcher	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher) ;
	
	/**
	 * 设置首选数据库
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetPrimaryDB(JCAT_DB $aDB) ;
	
	/**
	 * 取得扩展的配置对象
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPreference() ;
	
	/**
	 * 取得各服务的公共配置对象
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPublicPreference() ;
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @param 	$aService		W3B_Service
	 * @return	bool
	 */
	public function Load(W3B_Service $aService) ;
		
	/**
	 * 返回 改模板是否已加载
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsLoaded() ;
	

	/**
	 * 设置扩展缺省的 缓存对象
	 *
	 * @access	public
	 * @param	$aDefaultCache		JCAT_ICache	缓存对象
	 * @return	old_value
	 */
	public function SetDefaultCache(JCAT_ICache $aDefaultCache,$bPublic=false) ;
	
	/**
	 * 取得扩展缺省的 缓存对象
	 *
	 * @access	public
	 * @return	JCAT_ICache
	 */
	public function GetDefaultCache($bPublic=false) ;
	
	/**
	 * 设置扩展缺省的 临时文件目录
	 *
	 * @access	public
	 * @param	$sTempDirectory		string	临时文件目录
	 * @return	old_value
	 */
	public function SetDefaultTempDirectory($sTempDirectory,$bPublic=false) ;
	
	/**
	 * 取得扩展缺省的 临时文件目录
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDefaultTempDirectory($bPublic=false) ;
	
	/**
	 * 设置扩展缺省的 用户资源目录
	 *
	 * @access	public
	 * @param	$sUserRCDirectory		string	用户资源目录
	 * @return	old_value
	 */
	public function SetDefaultUserRCDirectory($sUserRCDirectory,$bPublic=false) ;
	
	/**
	 * 取得扩展缺省的 用户资源目录
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDefaultUserRCDirectory($bPublic=false) ;
	

	/**
	 * 
	 *
	 * @access	public
	 * @param	$sDataName		string
	 * @param	$Value			mixed
	 * @param	$sKey=null		string
	 * @return	void
	 */
	public function RegisterData($sDataName,$Value,$sKey=null) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName		string
	 * @param	$sKey=null		string
	 * @return	mixed
	 */
	public function GetData($sDataName,$sKey=null) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function UnregisterData($sDataName,$sKey=null) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName=null
	 * @return	void
	 */
	public function ClearData($sDataName=null) ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDataName=null
	 * @return	JCAT_IHashTableIterator
	 */
	public function CreateDataIterator($sDataName=null) ;
}

?>
