<?php

interface W3B_IExtensionInfo
{
	const RC_CLASS = 1 ;
	const RC_UI = 6 ;
	const RC_UI_TEMPLATE = 2 ;
	const RC_UI_STYLE = 4 ;
	const RC_LANGUAGE = 8 ;
	
	const PRIORITYLEVEL_HIGHEST = 1 ;
	const PRIORITYLEVEL_LOWEST = 9 ;
	const PRIORITYLEVEL_GENERAL = 3 ;
	
	/**
	 * 取得扩展的名称
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetName() ;
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @static 
	 * @return	JCAT_Version
	 */
	public function GetVersion() ;
	
	/**
	 * 取得扩展资源的版本号
	 *
	 * @access	public
	 * @static 
	 * @return	JCAT_Version
	 */
	public function GetRCVersion() ;
	
	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static 
	 * @return	string
	 */
	public function GetTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE) ;
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static 
	 * @return	string
	 */
	public function GetDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE) ;
	
	/**
	 * 取得扩展提供的功用
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetProvide() ;
	
	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetPriorityLevel() ;
	
	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateDependenceIterator() ;
	
	/**
	 * 取得扩展默认的优先级
	 *
	 * @access	public
	 * @param 	$nRcType		int
	 * @return	JCAT_IIterator
	 */
	public function CreateResourceIterator($nRcType) ;
	
	/**
	 * 取得兼容版本
	 *
	 * @access	public
	 * @param 	$nRcType		int
	 * @return	JCAT_VersionCompat
	 */
	public function GetCompatibleVersions() ;
	
	/**
	 * 是否是一个抽象扩展，没有提供面向用户的实际功能，而是仅仅为其他扩展提供特性
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsAbstract() ;
	
	/**
	 * 创建一个扩展安装对象
	 *
	 * @access	public
	 * @return	W3B_IExtensionSetup
	 */
	public function CreateInstaller() ;
	
	/**
	 * 创建升级扩展资源所需的 全部升级对象的迭代器
	 *
	 * @access	public
	 * @param	$aFromVersion		JCAT_Version
	 * @param	$aToVersion=null	JCAT_Version
	 * @param	$aPlatform=null		W3B_Platform
	 * @return	JCAT_IIterator
	 */
	public function CreateRCUpgraderIterator(JCAT_Version $aFromVersion,JCAT_Version $aToVersion=null,W3B_Platform $aPlatform=null) ;

	/**
	 * 设置对象属性
	 *
	 * @access	public
	 * @param	$sInfoName		string
	 * @param	$sInfo			string
	 * @return	void
	 */
	public function SetInfo($sInfoName,$sInfo) ;
	
	/**
	 * 取得对象属性
	 *
	 * @access	public
	 * @param	$sInfoName		string
	 * @return	string
	 */
	public function GetInfo($sInfoName) ;
}

?>
