<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
abstract class W3B_Controller extends JCAT_Controller implements W3B_IController, JCAT_IEmbeddedController
{
	/**
	 * create and initialize a controller
	 *
	 * @access	public
	 * @param	$sControllerClass		string
	 * @param	$aService				W3B_Service
	 * @param	$arrParams=array()		array
	 * @static
	 * @return	W3B_IController
	 */
	static public function CreateController($sInControllerClass,W3B_Service $aService,array $arrParams=array(),$bTrustee=true)
	{
		// 查询是否托管
		if($bTrustee)
		{
			$aClassTrustee = $aService->GetClassTrustee() ;
			$sControllerClass = $aClassTrustee->QueryClass($sInControllerClass) ;
		}
		
		if( !JCAT_Global::HasImplementedTo($sControllerClass,'JCAT_IController') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'参数 $sControllerClass(%s) 必须是一个 控制器类（实现JCAT_IController接口）的类名'
				, 'W3B_Platform', null
				, $sControllerClass
			)) ;
		}
		
		// create controller
		$aController = JCAT_Global::CreateObject($sControllerClass,$arrParams) ;

		// set data from user request
		$aRequest = $aService->GetRequestDispatcher()->GetRequest() ;
		$aController->SetRequest($aRequest) ;
		
		// initialize w3b controller
		if( JCAT_Global::HasImplementedTo($sControllerClass,'W3B_IController') )
		{
			$aController->SetPlatform($aService->GetPlatform()) ;
			$aController->SetService($aService) ;
			$aController->Initialize() ;
		}
		
		// return
		return $aController ;
	}
	
	/**
	 * set a service
	 *
	 * @access	public
	 * @param	$aService		W3B_Service
	 * @return	void
	 */
	public function SetService(W3B_Service $aService)
	{
		$this->aService = $aService ;
	}
	
	/**
	 * get the service 
	 *
	 * @access	public
	 * @return	W3B_Service
	 */
	public function GetService()
	{
		return $this->aService ;
	}
	
	
	/**
	 * 设置执行该控制器的平台
	 *
	 * @access	public
	 * @param	$aPlatform		W3B_Platform	所属平台
	 * @return	void
	 */
	public function SetPlatform(W3B_Platform $aPlatform)
	{
		$this->aPlatform = $aPlatform ;
	}
	
	/**
	 * 取得执行该控制器的平台
	 *
	 * @access	public
	 * @return	W3B_Platform
	 */
	public function GetPlatform()
	{
		return $this->aPlatform ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{}
	
	/**
	 * 设置一个视图容器，控制器的视图嵌入到该视图容器中
	 *
	 * @access	public
	 * @param	$aViewContainer		JCAT_IViewContainer
	 * @return	void
	 */
	public function SetViewContainer(JCAT_IViewContainer $aViewContainer)
	{
		$this->aViewContainer = $aViewContainer ;
	}
	
	
	/**
	 * 取得用于嵌入视图的 视图容器
	 *
	 * @access	public
	 * @return	JCAT_IViewContainer
	 */
	public function GetViewContainer()
	{
		return $this->aViewContainer ;
	}
	
	// 属性 ////////////////////////////////////////////////
	
	/**
	 * 执行改控制器的服务
	 * 
	 * @access	private
	 * @var		W3B_Service
	 */
	private $aService ;
	
	/**
	 * 执行改控制器的平台
	 * 
	 * @access	private
	 * @var		W3B_Platform
	 */
	private $aPlatform ;
	
	private $aViewContainer ;
	
}

?>