<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 W3B_CreateNewService 
 * param	sDoname=''
 * param	aPlatform=null
 *
 * @access public
 */
class W3B_CreateNewService 
	extends W3B_Controller 
{
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		$aModelService = new W3B_ModelService(true) ;
		$this->AddModel($aModelService,'theModelService') ;
	}

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_CreateNewService(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		$sDoname = $aRequest->GetParam('sDoname') ;
		$aPlatform = $aRequest->GetParam('aPlatform') ;
		JCAT_ASSERT::ASSERT_ISTHESE($aPlatform,array('null','W3B_Platform')) ;
		
		$aModelService = $this->GetModel('theModelService') ;
		
		// 检查域名
		$sDoname = W3B_ModelServiceDoname::TidyDoname($sDoname) ;
		if( $sDoname )
		{
			if( !W3B_ModelServiceDoname::VerifyDonameFormat($sDoname) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('域名格式无效: %s ','W3B_Platform',null,$sDoname),W3B_Service::MSG_SERVICE_BAD) ;
				return null ;
			}
			
			if( W3B_ModelServiceDoname::HasDonameExists($sDoname) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('域名: %s 已经存在。','W3B_Platform',null,$sDoname),W3B_Service::MSG_SERVICE_BAD) ;
				return null ;
			}
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('未指定域名。','W3B_Platform',null),W3B_Service::MSG_SERVICE_BAD) ;
			return null ;
		}
		
		// 开始时间
		$aModelService->Set('nCreateTime',time()) ;
		
		// 创建服务
		if( !$aModelService->Create() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建服务失败。','W3B_Platform',null),W3B_Service::MSG_SERVICE_BAD) ;
			return null ;
		}
		
		// 添加 域名
		if( $sDoname )
		{
			if( !$aModelService->AddDoname($sDoname) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('设置服务域名 %s 失败。','W3B_Platform',null,$sDoname),W3B_Service::MSG_SERVICE_BAD) ;
			}
		}
		
		// 创建 preference
		$nNewServiceId = $aModelService->GetId() ;
		$aPlatformPreference = W3B_Platform::GetPreference() ;
		$aPlatformPreference->CreateKey("/Services/{$nNewServiceId}") ;
		$aPlatformPreference->CreateKey("/Services/{$nNewServiceId}/Extensions") ;

		// 创建 Data 目录
		mkdir(W3B_DATA_ROOT."Services_{$nNewServiceId}") ;
		chmod(W3B_DATA_ROOT."Services_{$nNewServiceId}",0777) ;

		new JCAT_Message(JCAT_Language::SentenceEx('创建新服务：%s','W3B_Platform',null,$sDoname),W3B_Service::MSG_SERVICE_OK) ;
		
		
		$aNewService = new W3B_Service($aModelService,$aPlatform) ;
		
		// 触发事件
		$aService = $this->GetService() ;
		$aEventDispatcher = $aService->GetEventDispatcher() ;
		$aEventDispatcher->Emit(W3B_Service::EVENT_AFTER_CREATE_SERVICE,array($aNewService),W3B_Service::EVENT_NAMESPACE) ;
		
		return $aNewService ;
	}
	
}

?>