<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 W3B_CreateNewService 
 * param	sDoname=''
 * param	aPlatform=null
 *
 * @access public
 */
class W3B_DeleteService 
	extends W3B_Controller 
{
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		$aModelService = new W3B_ModelService(true) ;
		$this->AddModel($aModelService,'theModelService') ;
	}

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function W3B_CreateNewService(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		$nServiceId = $aRequest->GetParam('nForServiceId') ;
		if( !is_numeric($nServiceId) or $nServiceId<=0 )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nForServiceId，或参数无效。','JCAT',null),MSGMVC_BAD) ;
			return false ;
		}
		
		$aModelService = $this->GetModel('theModelService') ;
		$aModelService->FindById($nServiceId) ;
		if( !$aModelService->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('没有找到id为 %s 的服务。','JCAT',null,$nServiceId),MSGMVC_BAD) ;
			return false ;
		}

		if( $aModelService->Delete() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('服务(id:%s)已经删除。','JCAT',null,$nServiceId),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除服务失败(服务id:%s)。','JCAT',null,$nServiceId),MSGMVC_BAD) ;
			return false ;
		}
		
		// 触发事件
		$aService = $this->GetService() ;
		$aEventDispatcher = $aService->GetEventDispatcher() ;
		$aEventDispatcher->Emit(W3B_Service::EVENT_BEFORE_DELETE_SERVICE,array($nServiceId),W3B_Service::EVENT_NAMESPACE) ;
		
		return true ;
	}
	
}

?>