<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 W3B_Service 
 *
 * @access public
 */
class W3B_ModelService 
	extends JCAT_DBModel
{
	const PROP_DONAMES = 'aAggModelDonames' ;
	
	static private $arrORMConf_Base = array(
		'hub' => array(
			'table' => 'W3B_Services'
			, 'primaryKey' => 'nServiceId'
			, 'fieldsToProperties'
		)
	) ;
	
	static private $arrORMConf_Full = array(
		
		'hasMany' => array(
			
			'W3B_ServiceDonames' => array(
				'hubtable' => 'W3B_Services'
				, 'table' => 'W3B_ServiceDonames'
				, 'fkTo' => 'nServiceId'
				, 'property' => self::PROP_DONAMES
				, 'prototype' => 'W3B_AggModelServiceDonames'
			)
			
		)	
	) ;
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function W3B_ModelService($bFull=false,JCAT_DB $aDB=null)
	{
		$this->JCAT_DBModel( self::CreateShareORM($bFull,$aDB) ) ;	
		$this->AddModel(new W3B_AggModelServiceDonames(),self::PROP_DONAMES) ;	
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function LoadDonames($bReload=false)
	{
		$aAggDonames = $this->GetModel(self::PROP_DONAMES) ;
		
		if( $aAggDonames->GetModelCount() and !$bReload )
		{
			return ;
		}
		
		$aAggDonames->FindBy('nServiceId',$this->GetId()) ;
		return $aAggDonames->Load() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function CreateShareORM($bFull=false,JCAT_DB $aDB=null)
	{
		$sORMConfName = $bFull? 'full': 'base' ;
		$arrORMConf = self::$arrORMConf_Base ;
		if($bFull)
		{
			$arrORMConf = array_merge($arrORMConf,self::$arrORMConf_Full) ;
		}

		if( !isset(self::$arrShareORM[$sORMConfName]) )
		{
			self::$arrShareORM[$sORMConfName] = new JCAT_ORM($aDB) ;
			self::$arrShareORM[$sORMConfName]->InitFromConfig($arrORMConf) ;
		}

		return self::$arrShareORM[$sORMConfName] ;
	}
	
	/**
	 * 设置主键值
	 *
	 * @access	public
	 * @param	$sValue	string		What's this Parameter ?
	 * @return	void
	 */
	public function SetPrimaryKeyValue( $sValue )
	{
		exit('已取消的函数 SetPrimaryKeyValue()') ;
		parent::SetPrimaryKeyValue($sValue) ;
		
		$aChildDocument = $this->GetDocument('Donames') ;
		$aChildDocument->SetServiceId($sValue) ;
	}
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Create()
	{
		if( !parent::Create() )
		{
			return false ;
		}
		
		$nServiceId = $this->Get('nServiceId') ;
		JCAT_ASSERT::ASSERT_NOTNULL($nServiceId)  ;
		
		// 创建 配置键
		$aW3BPreference = W3B_Platform::GetPreference() ;
		$aW3BPreference->CreateKey("/Platform/{$nServiceId}") ;
		$aW3BPreference->CreateKey("/Platform/{$nServiceId}/Extensions") ;
		$aW3BPreference->SetItem("/Platform/{$nServiceId}/Extensions",'Installed',array()) ;
		
		return true ;
	}


	/**
	 * 添加一个 服务域名
	 *
	 * @access	public
	 * @param	$sDoname
	 * @throw		W3B_ServiceException
	 * @return	bool
	 */
	public function AddDoname($sDoname)
	{
		JCAT_ASSERT::ASSERT_($this->Get('nServiceId'),JCAT_Language::SentenceEx('尚未初始化服务。','W3B_Platform',null))  ;

		$sTidiedDoname = W3B_ModelServiceDoname::TidyDoname($sDoname) ;
		if($sTidiedDoname===null)
		{
			throw new W3B_ServiceException(JCAT_Language::SentenceEx('输入的域名格式不合法："%s"。','W3B_Platform',null,$sDoname)) ;
		}
		if(W3B_ModelServiceDoname::HasDonameExists($sTidiedDoname))
		{
			throw new W3B_ServiceException(JCAT_Language::SentenceEx('域名："%s"已经被占用。','W3B_Platform',null,$sTidiedDoname)) ;
		}
		
		// 增加记录
		$aServiceDoname = new W3B_ModelServiceDoname() ;
		$aServiceDoname->Set('nServiceId',$this->Get('nServiceId')) ;
		$aServiceDoname->Set('sServiceDoname',$sTidiedDoname) ;

		// 重新载入 
		$aDonames = $this->GetModel(self::PROP_DONAMES) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aDonames,''
				, JCAT_Language::SentenceEx('缺少名为：%s的文档，可能是这个 W3B_ModelService 对象没有以 $bFull=true 方式创建。','W3B_Platform',null,self::PROP_DONAMES));
		$aDonames->AddModel($aServiceDoname) ;
		return $aDonames->Serialize() ;
	}
	
	/**
	 * 移除一个 服务域名
	 *
	 * @access	public
	 * @param	$sDoname
	 * @throw		W3B_ServiceException
	 * @return	void
	 */
	public function RemoveDoname($sDoname)
	{
		JCAT_ASSERT::ASSERT_($this->Get('nServiceId'),JCAT_Language::SentenceEx('尚未初始化服务。','W3B_Platform',null))  ;
		
		$sTidiedDoname = self::TidyDoname($sDoname) ;
		if($sTidiedDoname===null)
		{
			throw new W3B_ServiceException(JCAT_Language::SentenceEx('输入的域名格式不合法："%s"。','W3B_Platform',null,$sDoname)) ;
		}
		
		$aAggDonames = $this->Get(self::PROP_DONAMES) ;
		$aIterator = $aAggDonames->CreateModelIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aDoname = $aIterator->Current() ;
			
			// 找到记录 并删除
			if( $aDoname->Get('sServiceDoname')===$sTidiedDoname )
			{
				if( !$aDoname->Delete() )
				{
					return false ;
				}
				
				else 
				{
					$aAggDonames->RemoveModel($aDoname) ;
					return true ;
				}
			}
			
			$aIterator->Next() ;
		}
		
		return true ;
	}
	
	/**
	 * 更改一个 服务域名
	 *
	 * @access	public
	 * @param	$sDoname
	 * @param	$sNewName
	 * @throw		W3B_ServiceException		
	 * @return	bool
	 */
	public function RenameDoname($sDoname,$sNewName)
	{
		JCAT_ASSERT::ASSERT_($this->Get('nServiceId'),JCAT_Language::SentenceEx('尚未初始化服务。','W3B_Platform',null))  ;
		
		$sTidiedDoname = self::TidyDoname($sDoname) ;
		$sTidiedNewDoname = self::TidyDoname($sNewName) ;
		if($sTidiedNewDoname===null)
		{
			throw new W3B_ServiceException(JCAT_Language::SentenceEx('输入的域名格式不合法："%s"。','W3B_Platform',null,$sNewDoname)) ;
		}
		if(self::HasDonameExists($sTidiedNewDoname))
		{
			throw new W3B_ServiceException(JCAT_Language::SentenceEx('域名："%s"已经被占用。','W3B_Platform',null,$sTidiedNewDoname)) ;
		}
		
		$aAggDonames = $this->Get(self::PROP_DONAMES) ;
		$aIterator = $aAggDonames->CreateModelIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aDoname = $aIterator->Current() ;
			
			// 找到记录 并删除
			if( $aDoname->Get('sServiceDoname')===$sTidiedDoname )
			{
				$aDoname->Set('sServiceDoname',$sNewName) ;
				return $aDoname->Save() ;
			}
			
			$aIterator->Next() ;
		}
		
		throw new JCAT_Exception(JCAT_Language::SentenceEx(
			'域名:%s 不存在'
			, 'W3B_Platform', null
			, $sDoname
		)) ;
	}
	
	
	
	/**
	 * 取得 Doname 的数量
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetDonameCount()
	{
		$aChildDocument = $this->GetModel('Donames') ;
		return $aChildDocument->GetDocumentCount() ;
	}
	
	/**
	 * 创建 Doname 迭代器
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateDonameIterator()
	{
		$aChildDocument = $this->GetModel(self::PROP_DONAMES) ;
		return $aChildDocument->CreateModelIterator() ;
	}
	
	// 属性 ///////////////////////////////////
	
	/**
	 * 服务配置对象
	 * 
	 * @access	private
	 * @var		JCAT_FSPreference
	 */
	private $aServicePreference = null ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array:JCAT_ORM
	 */
	static private $arrShareORM=array() ;
}


?>