<?php 



/**
 * 数据库文档类 W3B_ModelServiceDoname 
 *
 * @access public
 */
class W3B_ModelServiceDoname
	extends JCAT_DBModel
{
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function W3B_ModelServiceDoname(JCAT_DB $aDB=null)
	{
		$this->JCAT_DBModel( self::CreateShareORM($aDB) ) ;
	}
	

	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function CreateShareORM(JCAT_DB $aDB=null)
	{
		if( !self::$aShareORM )
		{
			self::$aShareORM = new JCAT_ORM($aDB) ;
			self::$aShareORM->InitFromConfig(array(

				'hub' => array(
					'table' => 'W3B_ServiceDonames'
					, 'primaryKey' => 'sServiceDoname'
				)
					
			)) ;
		}
		
		return self::$aShareORM ;
	}

	/**
	 * 取得 域名
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetDoname()
	{
		return $this->Get('sServiceDoname') ;
	}

	/**
	 * 检查服务域名是否合法
	 * 
	 * @access	public
	 * @param	$sDoname				string		What's this Parameter ?
	 * @static
	 * @return	bool
	 */
	static public function VerifyDonameFormat($sDoname)
	{
		return preg_match('/^([\x80-\xff\w\-_\.]+)(:\d+)?$/',$sDoname) ;		
	}
	
	
	
	/**
	 * 整理用户输入的服务域名
	 * 
	 * @access	public
	 * @param	$sDoname		string		What's this Parameter ?
	 * @static
	 * @return	string
	 */
	static public function TidyDoname($sDoname)
	{
		$sDoname = trim($sDoname) ;
		$sTidiedDoname = preg_replace('|^http://|i','',$sDoname) ;
		
		if( !self::VerifyDonameFormat($sTidiedDoname) )
		{
			return null ;
		}
		
		else
		{
			return $sTidiedDoname ;
		}
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sDoname
	 * @static
	 * @return	bool
	 */
	static public function HasDonameExists($sInDoname)
	{
		$sDoname = self::TidyDoname($sInDoname) ;
		
		$aDoname = new self() ;
		$aDoname->FindBy('sServiceDoname',$sDoname) ;
		return $aDoname->Load() ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		JCAT_ORM
	 */
	static private $aShareORM ;
}

?>