<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 W3B_Service 
 *
 * @access public
 */
class W3B_Service 
{
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function W3B_Service(W3B_ModelService $aServiceModel,W3B_Platform $aPlatform=null)
	{
		JCAT_ASSERT::ASSERT_($aServiceModel->GetId()
			, JCAT_Language::SentenceEx('参数 $aServiceModel 尚未初始化。','W3B_Platform',null))  ;
		$this->aServiceModel = $aServiceModel ;
		
		// 平台
		$this->aPlatform = $aPlatform? $aPlatform: W3B_Platform::GetGlobalInstance() ;
		
		// 初始化扩展管理器
		$this->aExtensionManager = new W3B_ExtensionManager($this->aPlatform) ;
		
		// 类托管 和 事件注册
		$this->aClassTrustee = new W3B_ClassTrustee() ;
		$this->aEventDispatcher = new JCAT_EventManager() ;
		
		// 载入扩展清单
		// --------------------------------------------------
		$aServicePreference = $this->GetPreference() ;
		$arrExtensionList = $aServicePreference->GetItem("/Extensions",W3B_Platform::ITEM_ENABLE_EXTS) ;
		if( $arrExtensionList )
		{
			ksort($arrExtensionList) ;
		}
		
		$aPlatformPreference = $this->aPlatform->GetPreference() ;
		$arrPlatfromInstalled =& $aPlatformPreference->GetItem("/Extensions",W3B_Platform::ITEM_INSTALLED_EXTS) ;

		if(is_array($arrExtensionList))
		{			
			// $aExtensionManager->ClearLoadedExtensionContainer() ;
			foreach ($arrExtensionList as $nPriority=>$arrExtensions)
			{
				if( !count($arrExtensions) )
				{
					continue ;
				}
				
				// 开启优先级
				$this->aExtensionManager->OpenPrioryLevel($nPriority) ;
				
				foreach ($arrExtensions as $sExtensionName)
				{					
					if( isset($arrPlatfromInstalled[$sExtensionName]['sVersion']) )
					{
						$this->aExtensionManager->AppendExtensionByName($sExtensionName,$arrPlatfromInstalled[$sExtensionName]['sVersion']) ;
					}
				}
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_Platform
	 */
	public function GetPlatform()
	{
		return $this->aPlatform ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetPreference()
	{
		if(!$this->aServicePreference)
		{
			$nServiceId = $this->aServiceModel->GetId() ;
			JCAT_ASSERT::ASSERT_NOTNULL($nServiceId,JCAT_Language::SentenceEx('服务无效。','W3B_Platform',null))  ;
		
			$aPlatformPreference = W3B_Platform::GetPreference() ;
			$this->aServicePreference = $aPlatformPreference->CreateSubPreference("/Services/{$nServiceId}") ;
		}
		
		return $this->aServicePreference ;		
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_ClassTrustee
	 */
	public function GetClassTrustee()
	{
		return $this->aClassTrustee ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_EventManager
	 */
	public function GetEventDispatcher()
	{
		return $this->aEventDispatcher ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIdentityManager
	 */
	public function GetIdManager()
	{
		if( !$this->aIdManager )
		{
			$this->aIdManager = JCAT_IdentityManager::CreateInstance('W3BService:'.$this->GetServiceId()) ;
		}
		
		return $this->aIdManager ;
	}
	
	/**
	 * set a user request dispatcher
	 *
	 * @access	public
	 * @param 	$aRequestDispatcher		JCAT_RequestDispatcher
	 * @return	void
	 */
	public function SetRequestDispatcher(JCAT_RequestDispatcher $aRequestDispatcher)
	{
		$this->aRequestDispatcher = $aRequestDispatcher ;
	}
	
	/**
	 * get the user request dispatcher
	 *
	 * @access	public
	 * @return	JCAT_RequestDispatcher
	 */
	public function GetRequestDispatcher()
	{
		if( !$this->aRequestDispatcher )
		{
			$aUserRequest = new JCAT_Request() ;
			$this->aRequestDispatcher = new JCAT_RequestDispatcher($aUserRequest) ;
		}
		
		return $this->aRequestDispatcher ;
	}
	
	/**
	 * 设置对象属性 self::$aAccessRouter
	 *
	 * @access	public
	 * @param	$aAccessRouter		JCAT_AccessRouter	访问路由
	 * @return	void
	 */
	public function SetAccessRouter(JCAT_AccessRouter $aAccessRouter)
	{
		$this->aAccessRouter = $aAccessRouter ;
	}
	
	/**
	 * 取得对象属性 self::$aAccessRouter
	 *
	 * @access	public
	 * @return	JCAT_AccessRouter
	 */
	public function GetAccessRouter()
	{
		if(!$this->aAccessRouter)
		{
			$this->aAccessRouter = new W3B_AccessRouter() ;

			// set same default paths
			// ------------------------------------------
			//   控制名称
			$sRoutePath = new W3B_AccessRoutePath() ;
			$sRoutePath->AddParameter('','controller','','([^\/\?&]+)?') ;
			$this->aAccessRouter->AddPathRule($sRoutePath) ;
		}
		
		return $this->aAccessRouter ;
	}
	
	/**
	 * 向服务注册一个全局实例
	 *
	 * @access	public
	 * @param	$Object		object
	 * @param	$sObName	string
	 * @return	void
	 */
	public function RegisterGlobalInstance($Object,$sGlobalName=null)
	{
		if(!$sGlobalName)
		{
			$sGlobalName = get_class($Object) ;
		}
		$this->arrGlobalObjects[$sGlobalName] = $Object ;
	}
	
	/**
	 * 取回一个全局注册到服务的实例
	 *
	 * @access	public
	 * @param	$sObName	string
	 * @return	object
	 */
	public function GetGlobalInstance($sGlobalName)
	{
		return isset($this->arrGlobalObjects[$sGlobalName])?
					$this->arrGlobalObjects[$sGlobalName]:
					null ;
	}
	
	/**
	 * 构造函数：通过域名创建一个服务对象
	 * 
	 * @access	public
	 * @param	$sDoname				string		What's this Parameter ?
	 * @static
	 * @return	W3B_Service
	 */
	static public function QueryServiceByDoname($sDoname,$bJustEnable=false)
	{
		$nServiceId = self::GetServiceIdByDoname($sDoname) ;
		if($nServiceId===null)
		{
			return null ;
		}
		return self::GetService(intval($nServiceId),$bJustEnable) ;
	}

	/**
	 * 构造函数：通过服务ID，取得服务对象
	 * 
	 * @access	public
	 * @param	$nServiceId				int		What's this Parameter ?
	 * @static
	 * @return	W3B_Service
	 */
	static public function GetService($nServiceId,$bJustEnable=false)
	{
		JCAT_ASSERT::ASSERT_INT($nServiceId) ;
		
		$aServiceModel = new W3B_ModelService() ;
		$aServiceModel->FindById($nServiceId) ;
		
		// 查询 是否可用
		if( $bJustEnable )
		{
			$aServiceModel->FindBy('bEnable','1') ;
		}
		
		if( !$aServiceModel->Load() )
		{
			return null ;
		}
		
		// 返回
		return new W3B_Service($aServiceModel) ;
	}
	
	static public function GetServiceIdByDoname($sDoname)
	{
		$aDB = W3B_Platform::GetDefaultDB() ;
		$nServiceId = $aDB->SelectOneField('W3B_ServiceDonames','nServiceId',"`sServiceDoname`='{$sDoname}'") ;

		if( $nServiceId===null )
		{
			return null ;
		}
		
		else
		{
			return intval($nServiceId) ;
		}
	}
	
	/**
	 * 查询指定服务的第一个可用域名
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function QueryFirstDoname($nServiceId)
	{
		if( !isset(self::$arrServicesFirstDonameCache[$nServiceId]) )
		{
			$aDB = W3B_Platform::GetDefaultDB() ;
			$sDoname = $aDB->SelectOneField('W3B_ServiceDonames','sServiceDoname',"nServiceId={$nServiceId}") ;
			if( $sDoname )
			{
				self::$arrServicesFirstDonameCache[$nServiceId] = $sDoname ; 
			}

			else
			{
				return null ;
			}
		}
		
		return self::$arrServicesFirstDonameCache[$nServiceId] ;		
	}
	
	/**
	 * 缓存服务的可用域名
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrServicesFirstDonameCache ;
	
	/**
	 * 返回服务ID
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetServiceId()
	{
		return intval($this->aServiceModel->GetId()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 注册服务事件
		$aEventDispatcher = $this->GetEventDispatcher() ;
		$aEventDispatcher->DefineEvent(self::EVENT_AFTER_CREATE_SERVICE,self::EVENT_NAMESPACE
				, array('在创建一个新的服务后触发此事件。','W3B_Platform'), array(__CLASS__) ) ;
		$aEventDispatcher->DefineEvent(self::EVENT_BEFORE_DELETE_SERVICE,self::EVENT_NAMESPACE
				, array('在删除一个服务前触发此事件，扩展响应此事件以回收、清楚服务的资源。','W3B_Platform'), array(__CLASS__) ) ;
		
		// 根据扩展清单，载入扩展
		$aExtensionManager = $this->GetExtensionManager() ;
		$aIterator = $aExtensionManager->GetExtensionDependenceTree()->CreateDependItemIter() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aExtItem = $aIterator->Current() ;
			if( $aExtItem->GetItemName()=='Platform' )
			{
				continue ;
			}
			
			W3B_ExtensionManager::LoadExtension(
					$aExtItem->GetItemName()
					, $aExtItem->GetItemVersion()
					, $this) ;
		}
	}
	
	/**
	 * run this service
	 *
	 * @access	public
	 * @return	void
	 */
	public function Start()
	{
		// rewrite path
		if(isset($_REQUEST['__ACCESS_PATH']))
		{
			$aAccessRouter = $this->GetAccessRouter() ;
			
			// found a match path
			$aPath = $aAccessRouter->FindPath($_REQUEST['__ACCESS_PATH']) ;
			if($aPath)
			{
				$aUserRequest = $this->GetRequestDispatcher()->GetRequest() ;
				$aPath->ParsePath($_REQUEST['__ACCESS_PATH'],$aUserRequest) ;
			}
		}

		$aRequestDispatcher = $this->GetRequestDispatcher() ;
		$sControllerName = $aRequestDispatcher->GetRequestController() ;
		
		$aController = W3B_Controller::CreateController($sControllerName,$this) ;
		$aController->MainRun() ;
	}
	
	/**
	 * 返回扩展管理器
	 *
	 * @access	public
	 * @return	W3B_ExtensionManager
	 */
	public function GetExtensionManager()
	{
		return $this->aExtensionManager ;		
	}
	
	public function GetRCRoot()
	{
		$nServiceId = $this->GetServiceId() ;
		return W3B_DATA_ROOT."Services_{$nServiceId}/" ;
	}

	/**
	 * 设置当前服务
	 *
	 * @access	public
	 * @return	W3B_Service
	 */
	static public function SetCurrentService(W3B_Service $aCurrentService)
	{
		$old_value =  self::$aCurrentService ;
		self::$aCurrentService = $aCurrentService ;
		return $old_value ;	
	}
	
	/**
	 * 取得当前服务
	 *
	 * @access	public
	 * @return	W3B_Service
	 */
	static public function GetCurrentService()
	{
		return self::$aCurrentService ;		
	}
	
	/**
	 * 取得当前服务的 ID
	 *
	 * @access	public
	 * @return	int
	 */
	static public function GetCurrentServiceId()
	{
		$aService = self::GetCurrentService() ;
		return $aService->GetServiceId() ;
	}

	/**
	 * 开启/关闭 一项服务
	 *
	 * @access	public
	 * @param	$bEnable=true		bool
	 * @return	bool
	 */
	public function Enable($bEnable=true)
	{
		$this->aServiceModel->Set('bEnable',$bEnable? '1': '0') ;
		return $this->aServiceModel->Save() ;
	}
	
	
	/**
	 * 取得 文档
	 *
	 * @access	public
	 * @return	W3B_ModelService
	 */
	public function GetServiceModel()
	{
		return $this->aServiceModel ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function __call($sMethod,$arrArgs=array())
	{
		// for extension data operations 
		// ------------------------------------------------------
		$arrExtDataOperations = array(
				'registerextensiondata' => ''
				, 'getextensiondata' => 'GetData'
				, 'unregisterextensiondata' => 'UnregisterData'
				, 'clearextensiondata' => 'ClearData'
				, 'createextensiondataiterator' => 'CreateDataIterator'
		) ;
		if( array_key_exists(strtolower($sMethod),$arrExtDataOperations) )
		{
		    $sRealMethodName = str_ireplace('extension','',$sMethod) ;
		    $sExtensionName = reset($arrArgs) ;
		    
		    // get extension 
		    $aExtMgr = $this->GetExtensionManager() ;
		    $aExtension = $aExtMgr->GetLoadedExtension($sExtensionName) ;
		    if(!$aExtension)
		    {
		    	throw new JCAT_Exception(JCAT_Language::SentenceEx(
		    		'尚未加载指定的扩展：%s'
		    		, 'W3B_Platform', null
		    		, $sExtensionName
		    	)) ;
		    }
		    
		    array_shift($arrArgs) ;
		    return call_user_func_array( array($aExtension,$sRealMethodName), $arrArgs ) ;
		}
		
		
		// ------------------------------------------------------
		throw new JCAT_Exception(JCAT_Language::SentenceEx(
			'正在访问未知的方法：%s::%s()'
			, 'W3B_Platform', null
			, get_class($this), $sMethod
		)) ;
	}
	
	// 属性 ///////////////////////////////////
	
	/**
	 * 服务配置对象
	 * 
	 * @access	private
	 * @var		JCAT_FSPreference
	 */
	private $aServicePreference = null ;

	/**
	 * 服务文档
	 * 
	 * @access	private
	 * @var		W3B_ModelService
	 */
	private $aServiceModel ;
	
	/**
	 * 扩展管理器
	 * 
	 * @access	private
	 * @var		W3B_ExtensionManager
	 */
	private $aExtensionManager ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_ClassTrustee
	 */
	private $aClassTrustee ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_EventManager
	 */
	private $aEventDispatcher ;

	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IIdentityManager
	 */
	private $aIdManager ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_RequestDispatcher
	 */
	private $aRequestDispatcher ;
	
	/**
	 * 对象属性 访问路由
	 * 
	 * @access	private
	 * @var		JCAT_AccessRouter
	 */
	private $aAccessRouter ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrGlobalObjects = array() ;
	
	/**
	 * 当前服务 单件
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_Service
	 */
	static private $aCurrentService ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_Platform
	 */
	private $aPlatform ;
	
	/**
	 * 消息类型：服务操作成功
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_Service
	 */
	const MSG_SERVICE_OK = 'MSG_SERVICE_OK' ;
	
	/**
	 * 消息类型：服务操作失败
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_Service
	 */
	const MSG_SERVICE_BAD = 'MSG_SERVICE_BAD' ;
	
	/**
	 * 事件：创建新服务
	 * 
	 * @access	const
	 * @var		string
	 */
	const EVENT_NAMESPACE = "\\W3B_Service" ;
	
	/**
	 * 事件：创建新服务
	 * 
	 * @access	const
	 * @var		string
	 */
	const EVENT_AFTER_CREATE_SERVICE = 'EVENT_AFTER_CREATE_SERVICE' ;
	
	/**
	 * 事件：删除服务
	 * 
	 * @access	const
	 * @var		string
	 */
	const EVENT_BEFORE_DELETE_SERVICE = 'EVENT_BEFORE_DELETE_SERVICE' ;
}

?>