<?php

/*
应该改名为：delegate 更准确
*/
class W3B_ClassTrustee
{	
	/**
	 * 创建对象
	 * 
	 * @access	public
	 * @param 	$sClassName			string		被托管类名称
	 * @param 	$arrParams=array()	array		构造函数参数
	 * @static
	 * @return	object
	 */
	public function CreateObject ( $sClassName, array $arrParams=array() )
	{
		$sActiveClassName = $this->QueryClass($sClassName) ;
		return JCAT_Global::CreateObject($sActiveClassName,$arrParams) ;
	}
	
	/**
	 * 声明一个 可托管类
	 * 
	 * @access	public
	 * @param	$sClassName				string		类名
	 * @param	$arrClassTypes=array()	array		类必须符合的类型：父类及接口
	 * @return	void
	 */
	public function DeclareClass($sClassName,array $arrClassTypes)
	{
		/*$aCaller = JCAT_Backtrace::GetCaller() ;
		$sCallerClass = $aCaller->GetClass() ;
		$sCallerFunction = $aCaller->GetFunction() ;
		
		JCAT_ASSERT::ASSERT_(
			JCAT_Global::HasImplementedTo($sCallerClass,'W3B_IExtension') and $sCallerFunction=='RegisterInTrustClass'
			, JCAT_Language::SentenceEx('只能在 W3B_IExtension 类的 RegisterInTrustClass 方法中声明可托管类。正在试图声明可托管类的栈为：%s::%s','W3B_Platform',null,$sCallerClass,$sCallerFunction) ) ;
			*/
			
		JCAT_ASSERT::ASSERT_( class_exists($sClassName)
			, JCAT_Language::SentenceEx('正在将一个不存在的类（%s）声明为可托管类。','W3B_Platform',null,$sClassName) ) ;
		
		JCAT_ASSERT::ASSERT_ISCLASS($sClassName,$arrClassTypes
			, JCAT_Language::SentenceEx('正在声明的可托管类（%s）与随后给入的类型不符（ %s ）。','W3B_Platform',null,$sClassName,implode(', ',$arrClassTypes)) ) ;
		
		JCAT_ASSERT::ASSERT_( !isset($this->arrInTrustClasses[$sClassName])
			, JCAT_Language::SentenceEx('类已经被声明为可托管类（%s）。','W3B_Platform',null,$sClassName) ) ;
		
		$this->arrInTrustClasses[$sClassName] = array(
			'types' => $arrClassTypes,
			'active' => $sClassName
		) ;
	}
	
	
	
	/**
	 * 为一个可托管类注册当前类
	 * 
	 * @access	public
	 * @param	$sClassName			string		托管类类名
	 * @param	$sActiveClassName		string		当前类
	 * @return	void
	 */
	public function RegisterClass($sClassName,$sActiveClassName)
	{
		JCAT_ASSERT::ASSERT_( isset($this->arrInTrustClasses[$sClassName])
			, JCAT_Language::SentenceEx('类（%s）尚未被声明为可托管类，无法为其注册当前类。','W3B_Platform',null,$sClassName) ) ;
			
		JCAT_ASSERT::ASSERT_( class_exists($sActiveClassName)
			, JCAT_Language::SentenceEx('正在将一个不存在的类（%s）注册为可托管类“%s”的当前类。','W3B_Platform',null,$sActiveClassName,$sClassName) ) ;
		
		JCAT_ASSERT::ASSERT_ISCLASS( $sActiveClassName, $this->arrInTrustClasses[$sClassName]['types']
			, JCAT_Language::SentenceEx('类%s 必须符合一下类型，才能注册成为 托管类“%s”：%s。','W3B_Platform',null
					, $sActiveClassName
					, $sClassName
					, implode(', ',$this->arrInTrustClasses[$sClassName]['types'])) ) ;

		$this->arrInTrustClasses[$sClassName]['active'] = $sActiveClassName ;
	}
	
	
	/**
	 * 查询一个可托管类的当前类
	 * 
	 * @access	public
	 * @param	$sClassName			string		托管类类名
	 * @return	string
	 */
	public function QueryClass($sClassName)
	{
		return isset($this->arrInTrustClasses[$sClassName])?
					$this->arrInTrustClasses[$sClassName]['active']: $sClassName ;
	}
	
	// 属性 /////////////////////////////////////////
	
	/**
	 * 单件实例
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_ClassTrustee
	 */
	static private $aGlobalInstance ;
	
	
	/**
	 * 
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrInTrustClasses = array() ;
	
}


?>
