<?php

class W3B_EventDispatcher
{	
	/**
	 * 定义事件
	 * 
	 * @access	public
	 * @param	$sEnventName			string		事件名称
	 * @param	$arrParamList=array()	array		参数表
	 * @param	$sDescription=''		string		事件表述
	 * @return	void
	 */
	public function DefineEvent($sEnventName,$arrParamList=array(),$sDescription='')
	{return ;
		$aCaller = JCAT_Backtrace::GetCaller() ;
		$sCallerClass = $aCaller->GetClass() ;
		$sCallerFunction = $aCaller->GetFunction() ;
		// $sCaller = W3B_Platform::MakeSureCaller() ;
		$sScope = W3B_Platform::MakeSureCaller( array('w3b_eventdispatcher::defineevent') ) ;
		
		if( $sScope!=='W3BPlatform' )
		{
			JCAT_ASSERT::ASSERT_(
				JCAT_Global::HasImplementedTo($sCallerClass,'W3B_IExtension') and $sCallerFunction=='RegisterEvent'
				, JCAT_Language::SentenceEx('只能在 W3B_IExtension 类的 RegisterEvent 方法中定义事件。正在视图定义事件的栈为：%s::%s','W3B_Platform',null,$sCallerClass,$sCallerFunction) ) ;
		}
				
		// 开辟作用域
		if(!isset($this->arrEvents[$sScope]))
		{
			$this->arrEvents[$sScope] = array() ;
		}
		
		if( isset($this->arrEvents[$sScope][$sEnventName]) )
		{
			$aExePoint = $this->arrEvents[$sScope][$sEnventName]['define']->GetCallPoint() ;
			JCAT_ASSERT::ASSERT_( 0	, JCAT_Language::SentenceEx('事件(%s::%s)已经定义，无法重复定义事件。事件定义于：%s, 行：%s','W3B_Platform',null
						, $sScope, $sEnventName, $aExePoint->GetFile(), $aExePoint->GetLine()) ) ;
		}
		
		// 创建事件
		$this->arrEvents[$sScope][$sEnventName] = array(
				'param_list' => $arrParamList ,
				'functions' => array() ,
				'define' => $aCaller
		) ;
	}
	
	
	
	/**
	 * 注册事件处理函数
	 * 
	 * @access	public
	 * @param	$sScope				string		作用域，通常为扩展名
	 * @param	$sEvent				string		事件名称
	 * @param	$Callback			callback	事件处理函数
	 * @return	void
	 */
	public function RegisterEventFunction($sScope,$sEvent,$Callback)
	{
		JCAT_ASSERT::ASSERT_STRING($sScope) ;
		JCAT_ASSERT::ASSERT_STRING($sEvent) ;
		JCAT_ASSERT::ASSERT_ISTHESE($Callback,array('callback')) ;

		JCAT_ASSERT::ASSERT_( !isset($this->arrEvents[$sScope][$sEvent])
				, JCAT_Language::SentenceEx('事件(%s::%s)尚未定义，无法注册事件处理函数。','W3Brick',null,$sScope,$sEvent) ) ;

		if( !in_array( $Callback,$this->arrEvents[$sScope][$sEvent]['functions']) )
		{
			$this->arrEvents[$sScope][$sEvent]['functions'][] = $Callback ;
		}
	}
	
	
	/**
	 * 触发事件
	 * 
	 * @access	public
	 * @param	$sScope					string		作用域，通常为扩展名
	 * @param	$sEvent					string		事件名称
	 * @param	$arrParams=array()		array		参数
	 * @return	void
	 */
	public function EmitEvent($sScope,$sEvent,array $arrParams=array())
	{
		JCAT_ASSERT::ASSERT_STRING($sScope) ;
		JCAT_ASSERT::ASSERT_STRING($sEvent) ;
		
		JCAT_ASSERT::ASSERT_( !isset($this->arrEvents[$sScope][$sEvent])
				, JCAT_Language::SentenceEx('事件(%s::%s)尚未定义，无法触发此事件。','W3Brick',null,$sScope,$sEvent) ) ;
		
		// 依次调用事件处理函数
		foreach ($this->arrEvents[$sScope][$sEvent]['functions'] as $Callback)
		{
			call_user_func_array($Callback,$arrParams) ;
		}
	}
	
	// 属性 /////////////////////////////////////////
	
	const GLOBAL_EVENT = 'global' ;
	
	/**
	 * 单件实例
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_ClassTrustee
	 */
	static private $aGlobalInstance ;

	
	private $arrEvents ;
	
}

?>
