<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class W3B_Patch
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function MakePatch(W3B_Platform $aPlatform,JCAT_Version $aFromVersion,$sSavePath,JCAT_String $aPlatformDiff=null,JCAT_String $aJCATDiff=null)
	{
		// 检查保存路径
		if( is_file($sSavePath) )
		{
			unlink($sSavePath) ;
		}
		if( file_exists($sSavePath) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'路径已经存在，无法创建文件:%s'
				, 'W3B_Platform', null, $sSavePath
			)) ;
		}
		
		// 创建 zip 文件
		$aZip = new ZipArchive() ;
		if ($aZip->open($sSavePath, ZIPARCHIVE::CREATE)!==TRUE)
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法在以下路径创建补丁包文件:%s'
				, 'W3B_Platform', null, $sSavePath
			)) ;
		}
		
		// 创建 patch xml
		$aPatch = simplexml_load_string("<W3BPatch></W3BPatch>") ;
		$aPatch->addAttribute('from',$aFromVersion->Get32Integer()) ;
		$aPatch->addAttribute('to',$aPlatform->GetVersion()->Get32Integer()) ;
		
		// 创建 change list 
		// ---------------------------------------------------------------
		$aChangeList = $aPatch->addChild('ChangeList') ;
		
		// 写入 platform 修改
		if( $aPlatformDiff )
		{
			$aSVNDiffPlatform = simplexml_load_string($aPlatformDiff) ;
			if(!$aSVNDiffPlatform)
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'输入的 Diff 文件格式无效；必须是一个由命令 "svn diff -r n:m --summarize --xml"输出的内容'
					, 'W3B_Platform', null
				)) ;
			}
			
			$this->MakeChangeList($aPlatform->GetRootPath(),'',$aSVNDiffPlatform,$aChangeList,$aZip) ;
		}
		
		// 写入 JCAT 修改
		if( $aJCATDiff )
		{
			$aSVNDiffJCAT = simplexml_load_string($aJCATDiff) ;
			if(!$aSVNDiffJCAT)
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'输入的 JCAT Diff 文件格式无效；必须是一个由命令 "svn diff -r n:m --summarize --xml"输出的内容'
					, 'W3B_Platform', null
				)) ;
			}
			
			$this->MakeChangeList($aPlatform->GetRootPath().'JCAT.Framework/','JCAT.Framework/',$aSVNDiffJCAT,$aChangeList,$aZip) ;
		}
		
		
		// 写入 patch xml
		$aZip->addFromString('PatchInfo.xml',$aPatch->asXML()) ; 
		$aZip->Close() ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$aSVNDiffXml		JCAT_String
	 * @return	void
	 */
	private function MakeChangeList($sSrcPath,$sPkgSubPath,SimpleXMLElement $aSVNDiffXml,SimpleXMLElement $aChangeList,ZipArchive $aPackage)
	{
		$aPaths = $aSVNDiffXml->xpath('/diff/paths/path') ;
		foreach($aPaths as $aOnePath)
		{
			// 忽略 svn属性 修改
			if( $aOnePath['props']!='none' )
			{
				continue ;
			}
			
			$sItemPath = strval($aOnePath) ;
			
			// 忽略 各个扩展 和 Tools 目录下 的变动
			if( preg_match('`^(Extension|Tools)/`i',$sItemPath) )
			{
				continue ;
			}
			
			$sItemPkgPath = "/files/{$sPkgSubPath}{$sItemPath}" ;

			$aNewNode = $aChangeList->addChild($aOnePath['kind'],$sPkgSubPath.$sItemPath) ;
			$aNewNode->addAttribute('change',$aOnePath['item']) ;
			
			// 新增、修改 文件
			if( $aOnePath['kind']=='file' and in_array($aOnePath['item'],array('added','modified')) )
			{
				$sItemSrcPath = "{$sSrcPath}{$sItemPath}" ;
				if( !is_file($sItemSrcPath) )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'将修改/新增的文件打包到补丁包时，无法取得源文件:%s'
						, 'W3B_Platform', null, $sItemSrcPath
					)) ;
				}
				
				$aPackage->addFile($sItemSrcPath,$sItemPkgPath) ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sPatchPath
	 * @return	void
	 */
	public function ApplyPatch($sPatchPath,W3B_Platform $aPlatform)
	{
		$docPatchInfo = $this->CheckPatchPackage($sPatchPath,$aPlatform) ;
		$sRootPath = $aPlatform->GetRootPath() ;
		
		// 将变动应用到 系统中
		$arrChangeList = array() ;
		$arrChangings = array_merge(
				$docPatchInfo->xpath('ChangeList/dir')
				, $docPatchInfo->xpath('ChangeList/file')
		) ;
		
		foreach ($arrChangings as $aChanging)
		{
			$sSubPath = strval($aChanging) ;
			$sExistsPath = $sRootPath.$sSubPath ;
			$sType = $aChanging->getName() ;
			$sKind = strval($aChanging['change']) ;
			
			// 删除
			if($sKind=='deleted')
			{
				// 删除 目录
				if($sType=='dir')
				{
					if( !JCAT_FSO::DeleteDir($sExistsPath,true) )
					{
						throw new JCAT_Exception(JCAT_Language::SentenceEx(
							'无法删除目录:%s', 'W3B_Platform', null, $sSubPath
						)) ;
					}
				}
				
				// 删除 文件
				else  if($sType=='file')
				{
					@unlink($sExistsPath) ;
					if( file_exists($sExistsPath) )
					{
						throw new JCAT_Exception(JCAT_Language::SentenceEx(
							'无法删除文件:%s', 'W3B_Platform', null, $sSubPath
						)) ;
					}
				}
			}
			
			// 新增,修改
			else if( in_array($sKind,array('modified','added')) )
			{
				// 目录
				if( $sType=='dir' )
				{
					// 增加 目录
					if($sKind=='added')
					{
						@mkdir($sExistsPath,0777,true) ;
						if( !is_dir($sExistsPath) )
						{
							throw new JCAT_Exception(JCAT_Language::SentenceEx(
								'新建目录失败:%s', 'W3B_Platform', null, $sSubPath
							)) ;
						}
					}
				}
				
				else if($sType=='file')
				{
					// 创建目录
					$sReleaseFolder = dirname($sExistsPath) ;
					if( !file_exists($sReleaseFolder) )
					{
						mkdir($sReleaseFolder,0777,true) ;
						chmod($sReleaseFolder,0777) ;
					}
					
					// 释放文件
					$sFileContents = file_get_contents("zip://{$sPatchPath}#/files/{$sSubPath}") ;
					if( !file_put_contents($sExistsPath,$sFileContents) )
					{
						throw new JCAT_Exception(JCAT_Language::SentenceEx(
							'从W3B扩展包中释放文件失败:%s', 'W3B_Platform', null, $sSubPath
						)) ;
					}
				}
			}
			
			$arrChangeList[] = JCAT_Language::SentenceEx(self::$arrMarkForChanging[$sKind],'W3B_Platform',null) . ' ' . $sSubPath ;
		}
		
		return $arrChangeList ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		int
	 */
	static private $arrMarkForChanging = array(
		'deleted' => '[删除]' ,
		'added' => '[新增]' ,
		'modified' => '[修改]' ,
	) ;
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	SimpleXMLElement
	 */
	private function CheckPatchPackage($sPatchPath,W3B_Platform $aPlatform)
	{
		$sPatchInfo = file_get_contents("zip://{$sPatchPath}#PatchInfo.xml") ;
		if( !$sPatchInfo or !$docPatchInfo=simplexml_load_string($sPatchInfo) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'提供的不是一个有效的W3B补丁包', 'W3B_Platform', null
			)) ;
		}
		
		$aVersion = $aPlatform->GetVersion() ;
		if( !isset($docPatchInfo['from']) or !JCAT_Version::VerifyFormat($docPatchInfo['from']) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'提供的W3B补丁包内缺少有效的版本信息(from version)', 'W3B_Platform', null
			)) ;
		}
		
		$aFromVersion = JCAT_Version::From32Integer(intval($docPatchInfo['from'])) ;
		if( $aVersion->Compare($aFromVersion)!=0 )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'提供的W3B补丁包要求当前的平台版本为：%s', 'W3B_Platform', null, $aFromVersion
			)) ;
		}
		
		return $docPatchInfo ;
	}

}


?>