<?php


class W3B_Platform
{
	
	const ITEM_ENABLE_EXTS = 'EnableExtensions' ;
	const ITEM_INSTALLED_EXTS = 'arrInstalledExtensions' ;
	
	// 事件
	const EVENT_NAMESPACE = '\\W3B_Platform' ;
	const EVENT_BEFORE_SETUP_EXT = 'EVENT_BEFORE_SETUP_EXT' ;
	const EVENT_AFTER_SETUP_EXT = 'EVENT_AFTER_SETUP_EXT' ;
	const EVENT_BEFORE_UNSETUP_EXT = 'EVENT_BEFORE_UNSETUP_EXT' ;
	const EVENT_AFTER_UNSETUP_EXT = 'EVENT_AFTER_UNSETUP_EXT' ;
	
	// 资源类型
	const RC_CACHE = 'Cache' ;
	const RC_TEMP = 'Temporary' ;
	const RC_USER = 'UserRC' ;
	const RC_DB = 'RC_DB' ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	W3B_Platform
	 */
	static public function GetGlobalInstance()
	{
		if( !self::$aGlobalInstance )
		{
			self::$aGlobalInstance = new W3B_Platform() ;
		}

		return self::$aGlobalInstance ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function W3B_Platform()
	{
		$this->aEventDispatcher = new JCAT_EventManager() ;
		
		// 声明事件
		$this->aEventDispatcher->DefineEvent(
				self::EVENT_BEFORE_SETUP_EXT ,
				self::EVENT_NAMESPACE ,
				array('即将安装一个扩展','W3B_Platform') ,
				array('W3B_IExtensionInfo','W3B_Platform') ) ;
		$this->aEventDispatcher->DefineEvent(
				self::EVENT_AFTER_SETUP_EXT ,
				self::EVENT_NAMESPACE ,
				array('已经安装一个扩展','W3B_Platform') ,
				array('W3B_IExtensionInfo','W3B_Platform') ) ;
				
		$this->aEventDispatcher->DefineEvent(
				self::EVENT_BEFORE_UNSETUP_EXT ,
				self::EVENT_NAMESPACE ,
				array('即将卸载一个扩展','W3B_Platform') ,
				array('W3B_IExtensionInfo','W3B_Platform') ) ;
		$this->aEventDispatcher->DefineEvent(
				self::EVENT_AFTER_UNSETUP_EXT ,
				self::EVENT_NAMESPACE ,
				array('已经卸载一个扩展','W3B_Platform') ,
				array('W3B_IExtensionInfo','W3B_Platform') ) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_EventManager
	 */
	public function GetEventDispatcher()
	{
		return $this->aEventDispatcher ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetRootPath()
	{
		return ROOTPATH ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPlatformPath()
	{
		return W3BPATH ;
	}

	/**
	 * 取得平台版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	public function GetVersion()
	{
		if(!$this->aVersion)
		{
			$arrRes = array() ;
			$sSVNRevision = preg_match('/ (\d+) /','$LastChangedRevision: 648 $',$arrRes) ?
								$arrRes[1]: '0' ;
			$nSVNRevision = intval($sSVNRevision) ;
			
			$this->aVersion = new JCAT_Version(0,1,3,$nSVNRevision,'alpha') ;
		}
		
		return $this->aVersion ;
	}
	
	/**
	 * 取得平台的兼容版本
	 *
	 * @access	public
	 * @return	JCAT_VersionCompat
	 */
	public function GetCompatibleVersions()
	{
		if( !$this->aCompatibleVersions )
		{
			$this->aCompatibleVersions = new JCAT_VersionCompat() ;
			
			// compat itself
			$this->aCompatibleVersions->AddCompatibleVersion($this->GetVersion());
			
			// compat history version
			$this->aCompatibleVersions->AddCompatibleVersion(new JCAT_Version(0,1,0));
			$this->aCompatibleVersions->AddCompatibleVersion(new JCAT_Version(0,1,1));
			$this->aCompatibleVersions->AddCompatibleVersion(new JCAT_Version(0,1,2));
		}
		
		return $this->aCompatibleVersions ;
	}

	/**
	 * 取得此版本的发行时间
	 *
	 * @access	public
	 * @static
	 * @return	int
	 */
	public function GetReleaseTime()
	{
		/* release time[2009.10.19 18:48] */
		return /* release time<*/1255949332/*> */ ;
	}
	
	// 扩展 API /////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	W3B_DependenceItem
	 */
	public function CreateDependenceItem()
	{
		return new W3B_DependenceItem(
				'Platform'
				, $this->GetCompatibleVersions()
				, $this->GetVersion() ) ;
	}
	
	/**
	 * 返回当前平台安装的扩展版本
	 *
	 * @access	public
	 * @param	$sExtName
	 * @return	string
	 */
	public function GetExtensionVersion($sExtName)
	{
		$aPreference = $this->GetPreference() ;
		$arrInstalledExts =& $aPreference->GetItem('/Extensions',W3B_Platform::ITEM_INSTALLED_EXTS) ;
		
		return isset($arrInstalledExts[$sExtName]['sVersion'])? $arrInstalledExts[$sExtName]['sVersion']: null ;
	}
	
	/**
	 * 返回当前平台安装的扩展版本
	 *
	 * @access	public
	 * @param	$sExtName
	 * @return	string
	 */
	public function GetExtensionRCVersion($sExtName)
	{
		$aPreference = $this->GetPreference() ;
		$arrInstalledExts =& $aPreference->GetItem('/Extensions',W3B_Platform::ITEM_INSTALLED_EXTS) ;
		
		return isset($arrInstalledExts[$sExtName]['sRCVersion'])? $arrInstalledExts[$sExtName]['sRCVersion']: null ;
	}

	/**
	 * 返回一个指定的扩展是否存在
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @param	$sExtVersion	JCAT_Version
	 * @return	bool
	 */
	public function IsExtensionExists($sExtName,JCAT_Version $aExtVersion)
	{
		return is_dir($this->GetExtensionPath($sExtName,$aExtVersion)) ;
	}

	/**
	 * 取得扩展存放位置
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @param	$sExtVersion	JCAT_Version
	 * @return	string
	 */
	public function GetExtensionPath($sExtName,JCAT_Version $aExtVersion)
	{
		return W3B_Extension_ROOT.$sExtName.'/'.$aExtVersion.'/' ;
	}
	
	/**
	 * 返回一个指定扩展的缓存是否存在
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @param	$sExtVersion	JCAT_Version
	 * @return	bool
	 */
	public function IsExtensionCacheExists($sExtName,JCAT_Version $aExtVersion)
	{
		return is_file( $this->GetExtensionPackageCachePath($sExtName,$aExtVersion) ) ;
	}
	
	/**
	 * 取得扩展缓存的存放位置
	 *
	 * @access	public
	 * @param	$sExtName		string
	 * @param	$sExtVersion	JCAT_Version
	 * @return	string
	 */
	public function GetExtensionPackageCachePath($sExtName,JCAT_Version $aExtVersion)
	{
		return W3B_Extension_ROOT."Cache/{$sExtName}/{$sExtName}_{$aExtVersion}.ext" ;
	}
	
	
	/**
	 * 返回平台上所有已安装的扩展
	 *
	 * @access	public
	 * @return	W3B_ExtensionManager
	 */
	public function GetExtensionManager()
	{
		if( !$this->aInstalledExtsMgr )
		{
			$this->aInstalledExtsMgr = new W3B_ExtensionManager($this) ;
			
			// 载入已安装扩展的信息
			$aPreference = $this->GetPreference() ;
			$arrInstalledExts =& $aPreference->GetItem('/Extensions',W3B_Platform::ITEM_INSTALLED_EXTS) ;
			
			foreach ($arrInstalledExts as $arrExt)
			{
				if(isset($arrExt['sName']))
				{
					$this->aInstalledExtsMgr->AppendExtensionByName($arrExt['sName'],$arrExt['sVersion']) ;
				}
			}
		}

		return $this->aInstalledExtsMgr ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sExtName
	 * @param	$sType
	 * @param	$aService=null	W3B_Service
	 * @return	string
	 */
	public function GetExtensionRCFolder($sExtName,$sType,W3B_Service $aService=null)
	{
		if( !in_array($sType,array(self::RC_CACHE,self::RC_TEMP,self::RC_USER)) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'正在获取无效的扩展资源类型：%s'
				, 'W3B_Extensions', null
				, $sType
			)) ;
		}
		
		if( !$this->GetExtensionRCVersion($sExtName) )
		{
			return null ;
		}
		
		$sFolder = W3B_DATA_ROOT."Extensions/{$sExtName}/" ;
		$sFolder.= $aService?($aService->GetServiceId().'/'): 'Public/' ;
		$sFolder.= $sType.'/' ;
		
		$this->MakeSureRCFolder($sFolder) ;
		
		return $sFolder ;
	}

	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$sPath
	 * @return	void
	 */
	private function MakeSureRCFolder($sPath)
	{
		if( !is_dir($sPath) )
		{
			if( is_file($sPath) )
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'资源目录的路径被一个文件占用：%s'
					, 'W2B_Platform', null, $sPath
				)) ;
			}
	
			else 
			{
				if( !mkdir($sPath,0777,true) )
				{
					throw new JCAT_Exception(JCAT_Language::SentenceEx(
						'无法创建资源目录：%s'
						, 'W2B_Platform', null, $sPath
					)) ;
				}
				
				chmod($sPath,0777) ;
			}
		}
		
		else if(!is_writable($sPath)) 
		{
			chmod($sPath,0777) ;
			
			if(!is_writable($sPath))
			{
				throw new JCAT_Exception(JCAT_Language::SentenceEx(
					'无法向资源目录写入文件，也无法变更目录属性：%s'
					, 'W2B_Platform', null, $sPath
				)) ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sExtName
	 * @param	$aService=null	W3B_Service
	 * @return	JCAT_ICache
	 */
	public function GetExtensionCache($sExtName,W3B_Service $aService=null)
	{
		$sCacheFolder = $this->GetExtensionRCFolder($sExtName,self::RC_CACHE,$aService) ;
		return new JCAT_HDCache($sCacheFolder) ;
	}
	
	// 以下方法都应该改为动态方法，以避免全局数据 --------------------------------------

	/**
	 * 取得全局的 配置对象
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IPreference
	 */
	static public function GetPreference()
	{
		return new JCAT_FSPreference(PLATFORM_PREFERENCE_DIR) ;
	}
	
	/**
	 * 取得缺省的全局数据库对象
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_DB
	 */
	static public function GetDefaultDB()
	{
		return JCAT_DB::CreateDefaultInstance() ;
	}
	
	/**
	 * 取得缺省的 JCAT_ICache 对象
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ICache
	 */
	static public function GetDefaultCache()
	{
		$sCaller = self::MakeSureCaller() ;
		if( $sCaller=='W3BPlatform' )
		{
			return new JCAT_HDCache(W3B_DATA_ROOT.'Platform/Cache/') ;
		}
		
		else
		{
			$aService = W3B_Service::GetCurrentService() ;
			$aExtension = $aService->GetLoadedExtension($sCaller) ;
			JCAT_ASSERT::ASSERT_INSTANCE($aExtension,'W3B_IExtension',JCAT_Language::SentenceEx('未知的 扩展“%s”','W3B_Platform',null,$sCaller));
			
			return $aExtension->GetDefaultCache() ;
		}
	}
	
	/**
	 * 从 回调 路径中查明 调用者，扩展平台 或 某个扩展
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function MakeSureCaller(array $arrTransparenceCaller=array())
	{
		$arrTransparenceCaller[] = 'W3B_Platform::makesurecaller' ;
		$arrTransparenceCaller[] = 'W3B_Platform::getdefaultdb' ;
		$arrTransparenceCaller[] = 'W3B_Platform::getdefaultcache' ;
		$arrTransparenceCaller[] = 'jcat_cache::getdefaultcache' ;
		
		$aW3BExtRoot = JCAT_Global::TidyPath(W3B_Extension_ROOT) ;
		
		$aCaller = JCAT_Backtrace::GetCaller() ;
		while($aCaller)
		{
			$aCalledStack = $aCaller->GetCalledStack() ;
			$aCaller = $aCaller->GetCaller() ;
			
			$sCaller = $aCalledStack->GetFunction() ;
			if( $aCalledStack->GetClass() )
			{
				$sCaller = $aCalledStack->GetClass().'::'.$sCaller ;
				$sCaller = strtolower($sCaller) ;
			}
			if( in_array($sCaller,$arrTransparenceCaller) )
			{
				continue ;
			}
			
			// 通过调用文件 检查是否 在 扩展目录中
			$sCallFile = JCAT_Global::TidyPath($aCalledStack->GetFile()) ;
			$arrRes = array() ;
			if( preg_match("|^{$aW3BExtRoot}([^/]+)/\d+\.\d+\.\d+\.\d+( [\w_\-]+)?/|",$sCallFile,$arrRes) )
			{
				return $arrRes[1] ;
			}
		}
		
		return 'W3BPlatform' ;
	}

	/**
	 * 注册控制器
	 *
	 * @access	public
	 * @param 	$sControllerClassName		string
	 * @static
	 * @return	void
	 */
	static public function RegisterHTTPPublicController($sControllerClassName,array $arrParameters=array())
	{
		//JCAT_ASSERT::ASSERT_ISCLASS($sControllerClassName,array('JCAT_IController')
		//			, JCAT_Language::SentenceEx('传入的参数不是有效的控制器类名称(“%s”)。','W3B_Platform',null,$sControllerClassName))  ;

		self::$arrHTTPPublicControllers[$sControllerClassName] = $arrParameters ;
	}
	
	/**
	 * 注销控制器
	 *
	 * @access	public
	 * @param 	$sControllerClassName		string
	 * @static
	 * @return	void
	 */
	static public function UnregisterHTTPPublicController($sControllerClassName)
	{
		unset(self::$arrHTTPPublicControllers[$sControllerClassName]) ;
	}
	
	/**
	 * 检查是否可公开控制器
	 *
	 * @access	public
	 * @param 	$sControllerClassName		string
	 * @static
	 * @return	bool
	 */
	static public function IsHTTPPublicController($sControllerClassName)
	{
		return isset(self::$arrHTTPPublicControllers[$sControllerClassName]) ;		
	}
	
	
	
	/**
	 * 注册缺省控制器
	 *
	 * @access	public
	 * @param	$sControllerName
	 * @static
	 * @return	old_value
	 */
	static public function RegisterDefaultController($sControllerName,$arrConstructArgs=array())
	{
		JCAT_ASSERT::ASSERT_ISTHESE($sControllerName,array('string','null')) ;
		
		if( $sControllerName!==null )
		{
			self::RegisterHTTPPublicController($sControllerName) ;
		}
		
		self::$arrDefaultControllerConstructArgs = $arrConstructArgs ;
		
		$old_value = self::$sDefaultControllerClasssName ;
		self::$sDefaultControllerClasssName = $sControllerName ;
		return $old_value ;
	}
	
	/**
	 * 注册一个回调函数，用于返回缺省控制器
	 *
	 * @access	public
	 * @param	$Callback
	 * @static
	 * @return	void
	 */
	static public function RegisterGetDefaultControllerHandle($Callback)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Callback,array('callback','null'));
		
		self::$arrDefaultControllerClasssHanders[] = $Callback ;
	}
	
	/**
	 * 注销一个回调函数，用于返回缺省控制器
	 *
	 * @access	public
	 * @param	$Callback
	 * @static
	 * @return	void
	 */
	static public function UnregisterGetDefaultControllerHandle($Callback)
	{
		foreach ( self::$arrDefaultControllerClasssHanders as $nIdx=>$DefaultControllerClasssHander )
		{
			if($DefaultControllerClasssHander==$Callback)
			{
				unset(self::$arrDefaultControllerClasssHanders[$nIdx]) ;
			}
		}
	}
	
	/**
	 * 清空所有的 回调函数
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function ClearGetDefaultControllerHandle()
	{
		self::$arrDefaultControllerClasssHanders = array() ;
	}
	
	/**
	 * 返回缺省控制器
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IController
	 */
	static public function GetDefaultController()
	{
		foreach ( self::$arrDefaultControllerClasssHanders as $DefaultControllerClasssHander )
		{
			call_user_func($DefaultControllerClasssHander) ;
		}

		if(self::$sDefaultControllerClasssName)
		{
			return JCAT_Global::CreateObject(self::$sDefaultControllerClasssName,self::$arrDefaultControllerConstructArgs) ;
		}
		else
		{
			return null ;
		}
	}
		
	// 属性 ////////////////////////////////////////////////////////////////////////////////////////////
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_VersionCompat
	 */
	private $aCompatibleVersions = null ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Version
	 */
	private $aVersion = null ;
	
	/**
	 * 缺省控制器名称
	 * 
	 * @access	private
	 * @var		string
	 */
	static private $sDefaultControllerClasssName ;
	
	/**
	 * 缺省控制器 构造参数
	 * 
	 * @access	private
	 * @var		array
	 */
	static private $arrDefaultControllerConstructArgs = array() ;
	
	/**
	 * 用于返回 缺省控制器 的回掉函数
	 * 
	 * @access	private
	 * @var		array:callback
	 */
	static private $arrDefaultControllerClasssHanders = array() ;
	
	/**
	 * 可访问 控制器
	 * 
	 * @access	private
	 * @var		array
	 */
	static private $arrHTTPPublicControllers = array(
		
		// JCAT 控制器
		'JCAT_SSMI' => array()
		, 'JCAT_DownloadFile' => array()
		
		// 扩展平台 控制器
		, 'W3B_PlatformAdminRegEdit' => array()
		, 'W3B_PlatformAdminRegEditItem' => array()
	) ;
	
	const PROSTATE_UPDATE_CLASSESPATH = 128 ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_Platform
	 */
	static private $aGlobalInstance ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		W3B_ExtensionManager
	 */
	private $aInstalledExtsMgr = null ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_EventManager
	 */
	private $aEventDispatcher ;
}


?>
