<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/////////////////////////////////////////////////////////////////////////////////////////
// 这个文件是 JCAT项目的初始化文件，对JCAT框架的主要配置集中在此文件完成 
// --------------------------------------------------------------------------------------

// 是否启用 assert
define('JCAT_ASSERT_ENABLE',1) ;

// 项目根目录
define('ROOTPATH',dirname(__FILE__).'/') ;
define('W3BPATH',dirname(__FILE__).'/Platform/') ;
define('PROJECT_NAME','JeCat 城市黄页(基于W3B)') ;


// JCAT 框架的访问入口文件 
define('JCATPATH',ROOTPATH.'JCAT.Framework/') ;
include_once(JCATPATH.'inc.JCAT_Entrance.php') ;
									

// 项目状态
JCAT_ProjectState::Set(JCAT_ProjectState::DEBUG) ;
JCAT_ProjectState::Set(JCAT_ProjectState::NO_CACHE,false) ;


// 项目类型 
JCAT::$TYPE = JCAT::TYPE_HTML ;																					// JCAT HTML类型  


// 为一些常用的JCAT类静态方法，创建全局函数别名 (如果JCAT的全局函数与你的函数名冲突，请取消冲突的内容) 
JCAT_Package::ImportStaticMethod('*','JCAT_Global',JCAT::PACKAGE_APP) ;											// JCAT 全局函数 
MakeFunctionAlias('S',array('JCAT_Language','Sentence')) ;
MakeFunctionAlias('SEx',array('JCAT_Language','SentenceEx')) ;




// 设置入口
JCAT_HTTPEntrance::SetEntrance(JCAT_HTTPEntrance::GetCurrentEntrance(),ROOTPATH) ;




/////////////////////////////////////////////////////////////////////////////////////////
// 设置 W3B Platform
// --------------------------------------------------------------------------------------

// 载入模版引擎 
JCAT_UIHtml::AddTemplateDir( ROOTPATH.'Platform/Resource/UITemplate/' ) ;

// 使用模板索引缓存
JCAT_UITemplateFileManager::$bUseTemplateIndexFile = true ;

// 设置 语句包目录 
JCAT_LanguagePackage::AddPackageDir( ROOTPATH.'Platform/Resource/Language/' ) ;


// 载入平台类 
$aClassLoader = JCAT_ClassLoader::GetGlobalInstance() ;
$aClassLoader->Import(ROOTPATH.'Platform/Classes/');

// 设置语言环境 
$aLanguage = JCAT_Language::GetLanguage('cn') ;																	// 指定当前语言 
$aLanguage->SetCurrentPackage('W3B_Platform') ;																	// 创建当前语言包

// 定义项目常量 
define('APP_NAME',JCAT_Language::Sentence('W3B Web原型')) ;														// 项目名称 
define('PLATFORM_PREFERENCE_DIR',ROOTPATH.'Setting/') ;
define('W3B_Extension_ROOT',ROOTPATH.'Extension/') ;
define('W3B_DATA_ROOT',ROOTPATH.'Data/') ;


// 注册 用于取得缺省 JCAT_ICache 对象的方法
JCAT_Cache::RegisterCallbackForDefaultCache(array('W3B_Platform','GetDefaultCache')) ;



/////////////////////////////////////////////////////////////////////////////////////////
// 平台配置（可修改）
// --------------------------------------------------------------------------------------

// 载入扩展时 更新ClassesPath
JCAT_ProjectState::Set(W3B_Platform::PROSTATE_UPDATE_CLASSESPATH,false) ;


// 数据库 首选参数  
JCAT_DB::$sPreferredFactory				= 'JCAT_DBFactoryMySQL41' ;												// 首选 数据库 工厂类 
JCAT_DB::$sPreferredDBServer			= 'localhost' ;																// 首选 数据库 服务器 
JCAT_DB::$sPreferredDBName				= 'w3b' ;																	// 首选 数据库 库名 
JCAT_DB::$sPreferredDBUser				= 'root' ;																	// 首选 数据库 用户名 
JCAT_DB::$sPreferredDBPassword			= '111111' ;																// 首选 数据库 用户密码 


// 调试选项：显示每个视图所引用的模板文件
JCAT_ViewHtml::$bShowTemplateFile = false ;
?>