<?php
require_once('shopObject.php');
class mdl_diy extends shopObject {

    var $idColumn = 'config_id';
    var $textColumn = 'config_name';
    var $adminCtl = 'member/diy';
    var $defaultCols = 'config_name,diycat_id,config_desc,member_id,is_recommend,date_create,date_update,sortnum';
    var $defaultOrder = array('sortnum','asc');
    var $tableName = 'sdb_diyconfig';
    var $hasTag = false;    

    function getColumns(){
        return array(
                'config_name'=>array('label'=>'配置名称','class'=>'span-3'),
                'diycat_id' => array('label'=>'配置类型','class'=>'span-3','type'=>'object:diycat'),
                'config_desc'=>array('label'=>'配置描述','class'=>'span-6'),    
                'member_id'=>array('label'=>'创建人','class'=>'span-2','type'=>'object:member','readonly'=>true),    
                'date_create'=>array('label'=>'创建时间','class'=>'span-3','type'=>'datetime'),    
                'date_update'=>array('label'=>'更新时间','class'=>'span-3','type'=>'datetime'),    
                'is_recommend'=>array('label'=>'是否推荐','class'=>'span-2','type'=>'bool'),
                'sortnum'=>array('label'=>'排序','class'=>'span-1','type'=>'int'),
                'preview'=>array('label'=>'查看','class'=>'span-3','sql'=>'config_id','type'=>'preview'), 
            );
    }
    function getFilter(){
        $filter = array();       
       return $filter;
    }
    
    function _filter($aFilter){
        $where = array(1);
        if (is_array($aFilter['config_id'])){
            $where[] = 'config_id in ('.implode(',',$aFilter['config_id']).')';
        }
        if (isset($aFilter['diycat_id'])){
            $where[] = 'diycat_id='.intval($aFilter['diycat_id']);
        }
        if (isset($aFilter['is_recommend'])){
            $where[] = 'is_recommend='.($aFilter['is_recommend']?'1':'0');
        }
        return parent::_filter($filter).' AND '.implode($where,' AND ');
    }

    function get($config_id) {
        $sql='SELECT * FROM sdb_diyconfig WHERE config_id='.intval($config_id);
        return $aTemp = $this->db->selectRow($sql);
    }

    function save($aData){
        $aRs=$this->db->query("SELECT * FROM sdb_diyconfig WHERE config_id=".$aData['config_id']);
        $sSql=$this->db->getUpdateSQL($aRs, $aData);
        return (!$sSql || $this->db->exec($sSql));
    }
    function add($data){
        $data['date_create'] = date('Y-m-d H:i:s',time());
        $data['date_update'] = date('Y-m-d H:i:s',time());
        $rs=$this->db->query('SELECT * FROM sdb_diyconfig WHERE 0=1');
        $sql= $this->db->GetInsertSQL($rs, $data);
        return $this->db->exec($sql);
    }
    function modifier_preview(&$rows){
        foreach($rows as $name=>$value){
            $rows[$name]='<a href="'.
                $this->system->realUrl('diy','view',array($value),null,$this->system->base_url()).'" target="_blank" title="">查看</a>';
        }
    }    
    
    function modifier_is_recommend(&$rows){
        foreach($rows as $name=>$value){
            $rows[$name]=$value?'是':'否';
        }
    }
}
?>
