<?php
class cct_diy extends shopPage{

	function index($catid = 0) {			    
		$this->title = 'DIY自选配置';		
		$diyObj = $this->system->loadModel('member/diy');
		$listfilter = array('is_recommend'=>1);
		if ($catid > 0) $listfilter['diycat_id'] = $catid;
		$list = $diyObj->getList('config_id', $listfilter);
		for ($i = 0; $i < count($list); $i++){
		    $list[$i]['diyconfig'] = $this->_get_diyconfig($list[$i]['config_id']);
		    
		    if (count($list[$i]['diyconfig']['goods_list']) > 0){
		        $list[$i]['diyconfig']['goods_list'] = array_slice($list[$i]['diyconfig']['goods_list'],0,1);
		    }
		    for ($k = 0; $k < 1-count($list[$i]['diyconfig']['goods_list']); $k++){
		        $list[$i]['diyconfig']['empty_list'][] = '';
		    }
		}		
		$this->pagedata['configlist'] = $list;				
		$ranklist = $diyObj->getList('*', null, 0, 1, $count, array('sortnum'));
		for ($i = 0; $i < count($ranklist); $i++){
		    $ranklist[$i]['diyconfig'] = $this->_get_diyconfig($ranklist[$i]['config_id']);
		}
		$this->pagedata['ranklist'] = $ranklist;
		
		$diyCatObj = $this->system->loadModel('member/diycat');
		$catlist = $diyCatObj->getList('*', null, 0, 1, $count, array('sortnum'));
		$this->pagedata['catlist'] = $catlist;
		
		$this->display('diy.html');
	}
	
	function _get_diyconfig($config_id)
	{
	    global $diy_cat;
	    $diyObj = $this->system->loadModel('member/diy');
	    $memObj = $this->system->loadModel('member/member');
	    $diycatObj = $this->system->loadModel('member/diycat');
	    $catObj = $this->system->loadModel('goods/productCat');
	    $config = $diyObj->get($config_id);
	    if ($config){
	        $mem = $memObj->getMemberInfo($config['member_id']);	        
	        $config['member_name'] = $mem['uname'];
	        
	        $data = unserialize($config['config_data']);
	        $filter = array('goods_id' => array_keys($data));
	        $goodsObj = $this->system->loadModel('goods/products');	        
	        $goods_list = $goodsObj->getList(null, $filter);	        	        

            $amount = 0;	        	        
	        for($i = 0; $i < count($goods_list); $i++){
	            $goods_list[$i]['diynum'] = $data[$goods_list[$i]['goods_id']];
	            $amount += $goods_list[$i]['price'] * $data[$goods_list[$i]['goods_id']];
	            
	            $cat_path = $catObj->getFieldById($goods_list[$i]['cat_id'],array('cat_path'));	                
                $cats_str = ($cat_path) ? $cat_path['cat_path'].$goods_list[$i]['cat_id'].',' :$goods_list[$i]['cat_id'].',';
                foreach ($diy_cat as $k => $item){	                
	                if (strpos($cats_str,$item['cat_id'].',') !== false){	            
	                    $goods_list[$i]['cat_name'] = $item['name'];
	                    break;
	                }
	            }
	        }
	        
	        $config['goods_list'] = $goods_list;
	        $config['count'] = count($goods_list);
	        $config['amount'] = $amount;
	        
	        $diycat = $diycatObj->get($config_id);
	        if ($diycat) $config['diycat_name'] = $diycat['diycat_name'];
	    }
	    return $config;
	}			
	
	function view($config_id){
	    $diyObj = $this->system->loadModel('member/diy');
	    $config = $this->_get_diyconfig($config_id);
	    if ($config){    
	        $this->pagedata['diycount']  = $config['count'];
	        $this->pagedata['diyamount'] = $config['amount'];	        
	        $this->pagedata['goodslist'] = $config['goods_list'];
	    }
	    $this->pagedata['diyconfig'] = $config;
	    
	    $this->pagedata['configlist'] = $list;		
		$ranklist = $diyObj->getList('*', null, 0, 1, $count, array('sortnum'));
		for ($i = 0; $i < count($ranklist); $i++){
		    $ranklist[$i]['diyconfig'] = $this->_get_diyconfig($ranklist[$i]['config_id']);
		}
		$this->pagedata['ranklist'] = $ranklist;
		
		$diyCatObj = $this->system->loadModel('member/diycat');
		$catlist = $diyCatObj->getList('*', null, 0, 1, $count, array('sortnum'));
		$this->pagedata['catlist'] = $catlist;
		
	    $this->display('diy-view.html');
	}
	
	function buy(){				
		if (isset($_POST['strwareid']) && isset($_POST['strwarenum']))
		{
			$garr = split(',', $_POST['strwareid']);
			$narr = split(',', $_POST['strwarenum']);
			$objCart = &$this->system->loadModel('trading/cart');
			$this->_verifyMember(false);
			$objCart->checkMember($this->member);
			$objGoods = $this->system->loadModel('trading/goods');
			$objCart->removeCart();
			for ($i = 0; $i < count($garr); $i++)
			{														
				$num = intval($narr[$i]);				
				if ($num > 0){
					$aP = $objGoods->getProducts($garr[$i]);			
					$aParams = array();
					$aParams['gid'] = $garr[$i];
					$aParams['pid'] = $aP[0]['product_id'];
					$aParams['adj'] = 'na';
					$aParams['pmtid'] = 0;					
					$status = $objCart->addToCart('g', $aParams, intval($num));					
				}
			}
		}			
		$this->redirect('cart');				
	}	
	
	function saveconfig(){				
		if (isset($_POST['strwareid']) && isset($_POST['strwarenum']))
		{
		    $config_id = isset($_POST['config_id']) ? intval($_POST['config_id']) : 0;
		    $diycat_id = isset($_POST['diycat_id']) ? intval($_POST['diycat_id']) : 0;
		    $config = $this->_get_diyconfig($config_id);
		    $this->_verifyMember(false);
		    if ($config && $this->member && $this->member['member_id'] == $config['member_id']){
		    }else{
		        $config_id = 0;
		    }
			$garr = split(',', $_POST['strwareid']);
			$narr = split(',', $_POST['strwarenum']);			
			$this->_verifyMember(true);
			
			$items = array();
			for ($i = 0; $i < count($garr); $i++)
			{							
				$num = intval($narr[$i]);				
				if ($num > 0){
					$gid = intval($garr[$i]);					
					$items[$gid] = $num;
				}
			}
			
			$data = array(
			    'config_name' => $_POST['config_name'],
			    'diycat_id' => $diycat_id,
			    'config_desc' => $_POST['config_desc'],
			    'member_id' => $this->member['member_id'],
			    'config_data' => serialize($items)
			);						
						
			$diy = $this->system->loadModel('member/diy');
			if ($config_id > 0){    	
			    $data['config_id'] = $config_id;
			    $diy->save($data);		    
			}else{
			    $diy->add($data);
			}
			
		}			
		$this->redirect('member','diyconfig');	
	}	
	
	function config($config_id){	    
	    global $diy_cat;
	    $diyObj = $this->system->loadModel('member/diy');
	    $memObj = $this->system->loadModel('member/member');
	    $config = $diyObj->get($config_id);
	    if ($config){
	        $mem = $memObj->getMemberInfo($config['member_id']);	        
	        $config['member_name'] = $mem['uname'];
	        
	        $data = unserialize($config['config_data']);
	        $filter = array('goods_id' => array_keys($data));
	        $goodsObj = $this->system->loadModel('goods/products');	        
	        $catObj = $this->system->loadModel('goods/productCat');	 
	        $goods_list = $goodsObj->getList(null, $filter);
	        	               

            $amount = 0;
            $cat_goods = array();        
	        for($i = 0; $i < count($goods_list); $i++){	            
	            $goods_list[$i]['diynum'] = $data[$goods_list[$i]['goods_id']];
	            $amount += $goods_list[$i]['price'] * $data[$goods_list[$i]['goods_id']];
	            $cat_path = $catObj->getFieldById($goods_list[$i]['cat_id'],array('cat_path'));	                
                $cats_str = ($cat_path) ? $cat_path['cat_path'].$goods_list[$i]['cat_id'].',' :$goods_list[$i]['cat_id'].',';
                foreach ($diy_cat as $k => $item){	                
	                if (strpos($cats_str,$item['cat_id'].',') !== false){
	                    $goods_list[$i]['cat_name'] = $item['name'];
	                    $goods_list[$i]['diynum'] = $data[$goods_list[$i]['goods_id']];	                    
	                    $cat_goods[$item['cat_id']] = $goods_list[$i];	                    
	                    break;
	                }
	            }
	        }
	        
	        	        	        	        
	        $this->pagedata['diycount'] = count($goods_list);
	        $this->pagedata['diyamount'] = $amount;
	        $this->pagedata['catgoods'] = $cat_goods;
	        $this->pagedata['goodslist'] = $goods_list;
	        	        	        
	        $numloop = array();
	        for ($i = 1; $i <= 1; $i++) $numloop[] = $i;
	        $this->pagedata['numlooop'] = $numloop;
	    }
	    $this->pagedata['diyconfig'] = $config;
	     
	    $this->pagedata['diycat'] = $diy_cat; 
	    $this->display('diy-config.html');
	}
	
	function printc($config_id){
	    $config = $this->_get_diyconfig($config_id);
	    if ($config){    
	        $this->pagedata['diycount']  = $config['count'];
	        $this->pagedata['diyamount'] = $config['amount'];	        
	        $this->pagedata['goodslist'] = $config['goods_list'];
	    }	    
	    $this->pagedata['diyconfig'] = $config;
	    
	    $this->display('diy-printc.html');
	}	
	
	function configinfo($config_id)
	{
	    header("Cache-Control: no-cache, must-revalidate");	    
	    $this->_verifyMember(false);
	    $this->pagedata['islogin'] = ($this->member && $this->member['member_id']);
	    
	    $diyObj = $this->system->loadModel('member/diy');	    
	    $config = $diyObj->get($config_id);
	    	    
		if ($config && $this->member && $this->member['member_id'] == $config['member_id']){
		        $this->pagedata['diyconfig'] = $config;
		}else{		    				
		}	    
		
		$diyCatObj = $this->system->loadModel('member/diycat');
		$catlist = $diyCatObj->getList('*', null, 0, 1, $count, array('sortnum'));
		$this->pagedata['catlist'] = $catlist;
		
	    $this->display('diy-configinfo.html');
	}		
	
	function zx($zxid, $page = 1, $brand_id = '', $keyword = '', $fid = '', $sortorder = ''){	    
       
		global $diy_cat;
		$db = $this->system->database();
		
		$brand_id = isset($_POST['brand_id'])?$_POST['brand_id']:$brand_id;
		$keyword = isset($_POST['keyword'])?$_POST['keyword']:urldecode($keyword);
		$sort = isset($_POST['sortorder'])?intval($_POST['sortorder']):intval($sortorder);
						
		$this->pagedata['brand_id'] = ($brand_id==='') ? -1 : intval($brand_id);
		$this->pagedata['keyword'] = $keyword;		
		$this->pagedata['sortorder'] = $sort;		
		
		foreach ($diy_cat as $ditem){
		    if ($ditem['cat_id'] == $zxid){
		        $diyconfig = $ditem;
		        break;
		    }
		}		
		
		$this->pagedata['zxid'] = $zxid;
		$this->pagedata['diycat'] = $diyconfig;
		
		$sql = 'select b.brand_id,b.brand_name from sdb_type_brand tb inner join sdb_brand b on tb.brand_id=b.brand_id inner join sdb_goods_cat c on c.type_id=tb.type_id where c.cat_id='.$db->quote($diyconfig['cat_id']);
		$brands = $db->select($sql);		
		$this->pagedata['brands'] = $brands;
				
		$pageLimit = 11;
		$filter = array('cat_id'=> $diyconfig['cat_id'], 'marketable'=>'true', '__store' => true);
		if ($brand_id !== '') $filter['brand_id'] = $brand_id;
		if ($keyword) $filter['name'] = $keyword;
				
		$objGoods = $this->system->loadModel('goods/products');
		$cols = $objGoods->defaultCols.$pcol;
		$orderType = array();
		if ($sort == 1){
		    $orderType[] = 'price asc';
		}else if ($sort == 1){
		    $orderType[] = 'price desc';
        }else if ($sort == 1){
		    $orderType[] = 'uptime asc';
        }else if ($sort == 1){
		    $orderType[] = 'uptime desc';		    
		}else{
		    $orderType[] = 'goods_id';
		}
		
				
		$aProducts = $objGoods->getList($cols,$filter,$pageLimit*($page-1),$pageLimit,$orderType);
		$count = $objGoods->count($filter);
		
		while (count($aProducts) < $pageLimit)
		{
			$aProducts[] = array();
		}
		$this->pagedata['products'] = $aProducts;
		
		$this->pagedata['pager'] = array(
			'current'=> $page,
			'total'=> ceil($count/$pageLimit),
			'link'=> $this->system->mkUrl('diy','zx',array($zxid, 'page',$brand_id,urlencode($keyword),$fid,$sort)),
			'token'=>'page');					
		$this->display('diy-zx.html');
		
	}

}
?>