<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  13/03/11, 09:19
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  * \file
  * \brief Fichier execution php compte client
  *
  * \section process
  *  	Prend en charge les modules de type \b account \b, leur affichage et execution \n\n
  *   Ce fichier assure la liaison avec les affichages principaux du compte utilisateur public, gestion des adresses, des information, mot de passe et inscription newsletter.\n\n
  *   Les fichier content/account_.. sont affichés par ce fichier
  *
*/
  require('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $page->is_registered();
  $page->new_class('customer',$customer_id);
  $account = $page->_call('customer','the_customer');
  $aca_account=$page->new_class('account',$customer_id);



  $get_action=(isset($_GET['action']) ? tep_sanitize_string($_GET['action']) : '');

  switch($get_action){
  	/**
  	 * \internal execution edition user
  	 * Assure l'enregsitrement des données user
  	 */
    case 'edit':
      $page->force_content('account_edit.php');
      if (isset($_POST['action']) && ($_POST['action'] == 'process'))
        if(!$page->_call('customer','userUpdate', $_POST)) tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    break;

    /**
     * \internal execution inscription newsletters
     */
    case 'newsletters':
      $page->_call('customer','detail_long_cust');
      $account = $page->_call('customer','the_customer');

      $page->force_content('account_newsletters.php');

      if (isset($_POST['action']) && ($_POST['action'] == 'process'))
        if(!$page->_call('customer','userNotifiUpdate', $_POST)) tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    break;
    /**
     * \section execution modification passport
     */
    case 'password':
      $page->force_content('account_password.php');

      if (isset($_POST['action']) && ($_POST['action'] == 'process'))
        if(!$page->_call('customer','userUpdatepassword', $_POST)) tep_redirect(tep_href_link(FILENAME_ACCOUNT, 'action=password', 'SSL'));
	else tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    break;
    /**
     * \internal password_forgottent
     */
    case 'password_forgottent':

      $account = $page->_call('customer','the_customer');
      $page->force_content('account_newsletters.php');

      if (isset($_GET['action']) && ($_GET['action'] == 'process')) {
	       $email_address = tep_db_prepare_input($_POST['email_address']);

	       $check_customer_query = $DB->query("select customers_firstname, customers_lastname, customers_password, customers_id from " . TABLE_CUSTOMERS . " where customers_email_address = '" . tep_db_input($email_address) . "'");
				  if ($check_customer_query->__get('NumRows')>0) {

				  /// include the password crypto functions
				  require_once(DIR_WS_FUNCTIONS . 'password_funcs.php');

				  $check_customer = $check_customer_query->fetchAssoc();

				  /**
				    * TODO: Utiliser class page.customer.php
				    */
				  $new_password = tep_create_random_value(ENTRY_PASSWORD_MIN_LENGTH);
				  $crypted_password = tep_encrypt_password($new_password);

				  $DB->query("update " . TABLE_CUSTOMERS . " set customers_password = '" . tep_db_input($crypted_password) . "' where customers_id = '" . (int)$check_customer['customers_id'] . "'");

				  if(!$page->_call('customer','userUpdatepassword', $_POST)){
				  	tep_mail($check_customer['customers_firstname'] . ' ' . $check_customer['customers_lastname'], $email_address, EMAIL_PASSWORD_REMINDER_SUBJECT, sprintf(EMAIL_PASSWORD_REMINDER_BODY, $new_password), STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
			        $page->messageStack->add_session('login', SUCCESS_PASSWORD_SENT, 'success');
				  }

				  /**
				   * TODO: rendre modificable via admin/ var de conf la redirection apres enregisrement new user
				   */
				  tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));

				} else {
				  $page->messageStack->add('password_forgotten', TEXT_NO_EMAIL_ADDRESS_FOUND);
				}
      }
      /* Arrivé via admin */
      elseif (isset($_GET['cID']) && is_numeric($_GET['cID'])){
	$cID = tep_db_prepare_input($_GET['cID']);
	$check_customer_query=$DB->query = tep_db_query("select customers_email_address from " . TABLE_CUSTOMERS . " where customers_id = '" . tep_db_input($cID) . "'");
	if ($check_customer_query__get('NumRows')>0) {
	  $check_customer = $check_customer_query->fetchAssoc();
	  $email_address=$check_customer['customers_email_address'];
	}
      }



    break;

    /**
     * \internal execution historique liste des commandes
     * Display list customers order
     */
    case 'history':
      $page->force_content('account_history.php');
    break;
    /**
     * \section execution affiche une commande
     * \a (int) $_GET['order_id']
     */
    case 'history_info':
      $page->force_content('account_history_info.php');

      if (!isset($_GET['order_id']) || (isset($_GET['order_id']) && !is_numeric($_GET['order_id'])))  tep_redirect(tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'));

      // Begin RMA Returns System - added order status ID to query
        $customer_info_query = tep_db_query("select customers_id, orders_status from " . TABLE_ORDERS . " where orders_id = '". (int)$_GET['order_id'] . "'");
        $customer_info = tep_db_fetch_array($customer_info_query);
      //   $orders_status = $customer_info['orders_status'];
        if ($customer_info['customers_id'] != $customer_id) {
          tep_redirect(tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'));
        }
      // End RMA Returns System


        $order = new order((int)$_GET['order_id']);


    break;
    case 'pdf';
      /**
       * \section Generation des doc pdf client
      */

      /* Modele dans include/module/template_pdf */
      if (!isset($_GET['order_id']) || (isset($_GET['order_id']) && !is_numeric($_GET['order_id'])))  tep_redirect(tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'));
      // Begin RMA Returns System - added order status ID to query
        $customer_info_query = tep_db_query("select customers_id, orders_status from " . TABLE_ORDERS . " where orders_id = '". (int)$_GET['order_id'] . "'");
        $customer_info = tep_db_fetch_array($customer_info_query);
      //   $orders_status = $customer_info['orders_status'];
        if ($customer_info['customers_id'] != $customer_id)  tep_redirect(tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'));

        $time0   = time();
        require(DIR_WS_CLASSES . 'order.php');
        $order = new order((int)$_GET['order_id']);

	osCSS_pdf::getInstance();

        $pageloop = "1";

        $get_customer_comments = (isset($_POST['show_comments']))? ' and h.orders_status_id = ' . DEFAULT_ORDERS_STATUS_ID : '' ;
        $pull_w_status =(isset($_POST['pull_status']))? " and o.orders_status = ". $_POST['pull_status']:'';

        $orders_query = tep_db_query("select o.orders_id,o.orders_status,h.comments,MIN(h.date_added) from " . TABLE_ORDERS . " o, " . TABLE_ORDERS_STATUS_HISTORY . " h where o.orders_id in (" . tep_db_input($_GET['order_id']) . ") and h.orders_id = o.orders_id" . $pull_w_status . $get_customer_comments . ' group by o.orders_id');


        if (!tep_db_num_rows($orders_query) > 0) message_handler('FAILED_TO_OPEN');
        $orders = tep_db_fetch_array($orders_query);

          $type=($orders['orders_status']==DEFAULT_ORDERS_STATUS_COMPLETED)?'invoice' : 'packingslip';

	  $pdf=osCSS_pdf::OutputInit($type);

          $order = new order($_GET['order_id']);
	  include(osCSS_pdf::getPathModele());

          $time1  = time();
          if ($time1 >= $time0 + 30) {
            $time0 = $time1;
            header('X-bpPing: Pong');
          }

	  $pdf=osCSS_pdf::OutputEnd($type);
    break;
    /**
     * \section execution modukle aca complementaire
     */
    case 'aca':
      if (!isset($_GET['mod']))
        tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));

      $page->force_content('account_aca.php');

        //       if (isset($_POST['action']) && ($_POST['action'] == 'process'))
        //         if(!$page->_call('customer','insert_password', $_POST)) tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
    break;
    default:
      if (isset($_GET['aca_mod']) && !is_numeric($_GET['aca_mod']) &&  isset($_GET['aca_action'])){
        $module=$_GET['aca_mod'];
        $type='account';
        $aca=account::getInstance();

        $aca_module=$aca->ret_modules();
        /* cf content/page.php */
        $page->force_content('page'.$page->ext);

        if (isset($_GET['action']) ) {
            if ($aca->check_action($module,$_GET['action']) ) {
            /** Exe == true */
              $aca->after_check_action($module,$_GET['action']);
                //               tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action'))));
            }
        }
       }
  }

  $page->post_init();

  switch($get_action){
    case 'edit':
    $page->breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ACCOUNT, 'action=edit', 'SSL'));
    break;
    case 'history':
      $page->breadcrumb->add(NAVBAR_TITLE_3, tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'));
    break;
    case 'newsletters':
      $page->breadcrumb->add(NAVBAR_TITLE_4, tep_href_link(FILENAME_ACCOUNT, 'action=newsletters', 'SSL'));
    break;
    case 'password':
      $page->breadcrumb->add(NAVBAR_TITLE_5, tep_href_link(FILENAME_ACCOUNT, 'action=password', 'SSL'));
    break;
    case 'history_info':
      $page->breadcrumb->add(NAVBAR_TITLE_6, tep_href_link(FILENAME_ACCOUNT, 'action=history_info&amp;order_id='.$_GET['order_id'], 'SSL'));
    break;
  }

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');

?>