<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/01/11, 03:00
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  Chargeur pour oscss
  Output a form textarea field w/ tiny_mce

  NOTE:

  Les déclinaisons (_top, _head, _draw) sont appelé respectivement dans le fichier .top (/content/xxxx.top.inc), header (noyau ) , et à la place de l'element html dans le gabarit

*/

/**
  Chargement des class de plugin
*/



class tiny_mce_oscss extends oscss_cstr {

  function tiny_mce_options(){
    global $oscss;
  }

  /**
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param string $name, liste des id separe par des virgules (textearea, textarea1)
  */
  function _top($name, $width, $height){
    global $oscss;


    $this->dim['width']=(!empty($width))?$width : '250';
    $this->dim['height']=(!empty($height))? $height : '50';
    $this->name=(isset($this->name) && tep_not_null($this->name))? $this->name.','.$name : $name;
  }


  function _head(){
    global $oscss;

    $dirs = opendir('editeur/tiny_mce/template_html/');

    $template='';

    while ($file = @readdir($dirs)) {
        if (substr("$file", -4) == '.htm') {
            $name=substr("$file",0,strlen($file)-4);
            $template .='{
			  title : "'.$name.'",
			  src : "editeur/tiny_mce/template_html/'.$file.'",
			  description : ""
			  },';
        }
    }
    closedir($dirs);

      tep_include_file ("editeur/tiny_mce/tiny_mce.js",true);
    echo '<script type="text/javascript" src="'.tep_get_http() . DIR_WS_ADMIN.'editeur/tiny_mce/plugins/tinybrowser/tb_tinymce.js.php"></script>';
    echo '<script type="text/javascript">//<!--'."\n"
    .'tinyMCE.init({'."\n"
      // General options
    . (tep_not_null($this->name)? 'mode : "exact",'."\n". 'elements : "'.str_replace(array('[',']'),array('_'), $this->name).'" ,'."\n" : ' mode : "textareas",'."\n" )
    .'theme : "advanced",'."\n"
    .'relative_urls : false,'."\n"
    .'remove_script_host : false,'."\n"
    .'language : "fr",'."\n"
    .'width : '.$this->dim['width'].','."\n"
    .'height : '.$this->dim['height'].','."\n"
    .'plugins : "safari,table,pagebreak,advimage,advlink,contextmenu,paste,media,fullscreen,template,iframe",'."\n"
    .'file_browser_callback : "tinyBrowser",'."\n"
    .'extended_valid_elements : "iframe[src|width|height|name|align|style|frameborder]",'."\n"

      // Theme options
    .'theme_advanced_buttons1 : "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,styleselect,formatselect,fontselect,fontsizeselect, template",'."\n"
    .'theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,|,image,media,|,iframe,|,forecolor,backcolor,|,code",'."\n"
    .'theme_advanced_buttons3 : "tablecontrols,|,pagebreak,|,sub,sup,fullscreen",'."\n"
    .'theme_advanced_toolbar_location : "top",'."\n"
    .'theme_advanced_toolbar_align : "left",'."\n"
    .'theme_advanced_statusbar_location : "bottom",'."\n"
    .'theme_advanced_resizing : true,'."\n"
    .'template_templates : ['
    .$template
    .'],'."\n"
      // Example content CSS (should be your site CSS)
      .'content_css : "'.HTTP_CATALOG_SERVER.DIR_WS_TEMPLATES.TEMPLATE_NAME.'/sample.css", '."\n"

      .' });'."\n"
      .'//--></script>'."\n";
  }

  /**
  * @author oscim - OscssTeam
  * @version 1.0
  Output a form textarea field w/ tiny_mce
  */
  function _draw($name, $width, $height, $text='') {
    global $oscss;
    $w= (!empty($width))? $width : $this->dim['width'];
    $h=(!empty($height))? $height : $this->dim['height'];

    $field = ''.tep_draw_textarea_field($name, str_replace(array('[',']'),array('_'), $name), $w/7, $h/10, $text).''."\n";
    return $field;
  }

}
?>